/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.stack;

import net.java.stun4j.NetAccessPointDescriptor;
import net.java.stun4j.ResponseCollector;
import net.java.stun4j.StunAddress;
import net.java.stun4j.StunException;
import net.java.stun4j.StunMessageEvent;
import net.java.stun4j.message.Request;
import net.java.stun4j.stack.StunProvider;
import net.java.stun4j.stack.TransactionID;

class StunClientTransaction
implements Runnable {
    public static final int MAX_RETRANSMISSIONS = 8;
    public static final int ORIGINAL_WAIT_INTERVAL = 100;
    public static final int MAX_WAIT_INTERVAL = 1600;
    private int retransmissionsCounter = 0;
    private int lastWaitInterval = 100;
    private StunProvider providerCallback = null;
    private Request request = null;
    private StunAddress requestDestination = null;
    private TransactionID transactionID = null;
    private NetAccessPointDescriptor apDescriptor = null;
    private ResponseCollector responseCollector = null;
    private boolean cancelled = false;
    private long nextRetransmissionDate = -1L;
    private Thread runningThread = null;

    public StunClientTransaction(StunProvider providerCallback, Request request, StunAddress requestDestination, NetAccessPointDescriptor apDescriptor, ResponseCollector responseCollector) {
        this.providerCallback = providerCallback;
        this.request = request;
        this.apDescriptor = apDescriptor;
        this.responseCollector = responseCollector;
        this.requestDestination = requestDestination;
        this.transactionID = TransactionID.createTransactionID();
        try {
            request.setTransactionID(this.transactionID.getTransactionID());
        }
        catch (StunException ex) {
            throw new IllegalArgumentException("The TransactionID class genereated an invalid transaction ID");
        }
        this.runningThread = new Thread(this);
    }

    public void run() {
        this.runningThread.setName("CliTran");
        while (this.retransmissionsCounter++ < 8) {
            this.waitUntilNextRetransmissionDate();
            if (this.cancelled) {
                return;
            }
            if (this.lastWaitInterval < 1600) {
                this.lastWaitInterval *= 2;
            }
            try {
                this.providerCallback.getNetAccessManager().sendMessage(this.request, this.apDescriptor, this.requestDestination);
            }
            catch (StunException stunException) {
                // empty catch block
            }
            this.schedule(this.lastWaitInterval);
        }
        this.responseCollector.processTimeout();
        this.providerCallback.removeClientTransaction(this);
    }

    void sendRequest() throws StunException {
        this.providerCallback.getNetAccessManager().sendMessage(this.request, this.apDescriptor, this.requestDestination);
        this.schedule(100L);
        this.runningThread.start();
    }

    Request getRequest() {
        return this.request;
    }

    synchronized void waitUntilNextRetransmissionDate() {
        long current = System.currentTimeMillis();
        while (this.nextRetransmissionDate - current > 0L) {
            try {
                this.wait(this.nextRetransmissionDate - current);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.cancelled) {
                return;
            }
            current = System.currentTimeMillis();
        }
    }

    void schedule(long timeout) {
        this.nextRetransmissionDate = System.currentTimeMillis() + timeout;
    }

    synchronized void cancel() {
        this.cancelled = true;
        this.notifyAll();
    }

    void handleResponse(StunMessageEvent evt) {
        this.cancel();
        this.responseCollector.processResponse(evt);
    }

    TransactionID getTransactionID() {
        return this.transactionID;
    }
}

