/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.stack;

import java.util.Arrays;
import java.util.Random;

class TransactionID {
    private byte[] transactionID = new byte[16];
    private static Random random = new Random(System.currentTimeMillis());
    private int hashCode = 0;

    private TransactionID() {
    }

    static TransactionID createTransactionID() {
        TransactionID tid = new TransactionID();
        long left = System.currentTimeMillis();
        long right = random.nextLong();
        for (int i = 0; i < 8; ++i) {
            tid.transactionID[i] = (byte)(left >> i * 8 & 0xFFL);
            tid.transactionID[i + 8] = (byte)(right >> i * 8 & 0xFFL);
        }
        tid.hashCode = tid.transactionID[3] << 24 & 0xFF000000 | tid.transactionID[2] << 16 & 0xFF0000 | tid.transactionID[1] << 8 & 0xFF00 | tid.transactionID[0] & 0xFF;
        return tid;
    }

    static TransactionID createTransactionID(byte[] transactionID) {
        TransactionID tid = new TransactionID();
        System.arraycopy(transactionID, 0, tid.transactionID, 0, 16);
        tid.hashCode = tid.transactionID[3] << 24 & 0xFF000000 | tid.transactionID[2] << 16 & 0xFF0000 | tid.transactionID[1] << 8 & 0xFF00 | tid.transactionID[0] & 0xFF;
        return tid;
    }

    public byte[] getTransactionID() {
        return this.transactionID;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TransactionID)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        byte[] targetBytes = ((TransactionID)obj).transactionID;
        return Arrays.equals(this.transactionID, targetBytes);
    }

    public boolean equals(byte[] targetID) {
        return Arrays.equals(this.transactionID, targetID);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer idStr = new StringBuffer();
        for (int i = 0; i < this.transactionID.length; ++i) {
            idStr.append("0x");
            if ((this.transactionID[i] & 0xFF) <= 15) {
                idStr.append("0");
            }
            idStr.append(Integer.toHexString(this.transactionID[i] & 0xFF).toUpperCase());
            if (i >= this.transactionID.length) continue;
            idStr.append(" ");
        }
        return idStr.toString();
    }
}

