/*
 * Decompiled with CFR 0.152.
 */
package com.casaerwin.brutus;

import com.casaerwin.brutus.Album;
import com.casaerwin.brutus.DBM;
import com.casaerwin.brutus.DBMArtist;
import com.casaerwin.brutus.DBMTrack;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class DBMAlbum
extends DBM {
    private static PreparedStatement newKeyAlbum;
    private static PreparedStatement insertAlbum;
    private static PreparedStatement deleteAlbum;
    private static PreparedStatement retrieveAlbum;
    public static boolean psOpened;
    int DBMAlbumRC;
    SQLException sqlEx;
    Vector albumTitles = new Vector();
    Vector row;

    DBMAlbum() {
        if (!psOpened) {
            try {
                String string = "SELECT MAX ALB_SEQ + 1 AS NEW_KEY FROM ALBUMS;";
                newKeyAlbum = conn.prepareStatement(string);
                string = "INSERT INTO ALBUMS VALUES(?, ?, ?, ?, ?, ?, ?);";
                insertAlbum = conn.prepareStatement(string);
                string = "DELETE FROM ALBUMS WHERE ALB_PARENT_ID = ? AND ALB_PARENT_KEY = ?;";
                deleteAlbum = conn.prepareStatement(string);
                string = "SELECT ALB_SEQ, ALB_COMPOSER, ALB_ORCHESTRA, ALB_CONDUCTOR, ALB_GENRE FROM ALBUMS WHERE ALB_PARENT_ID = ? AND ALB_PARENT_KEY = ?;";
                retrieveAlbum = conn.prepareStatement(string);
                this.DBMAlbumRC = 0;
                psOpened = true;
            }
            catch (SQLException sQLException) {
                this.sqlEx = sQLException;
                this.DBMAlbumRC = 12;
                this.handleSQLException(sQLException);
            }
        }
    }

    public void storeAlbum(Album album) {
        try {
            insertAlbum.setInt(1, this.getNewPrimaryKey());
            if (this.DBMAlbumRC == 0) {
                insertAlbum.setString(2, album.getComposer());
                insertAlbum.setString(3, album.getOrchestra());
                insertAlbum.setString(4, album.getConductor());
                insertAlbum.setInt(5, album.getGenre());
                insertAlbum.setInt(6, album.getIdentifier());
                insertAlbum.setInt(7, album.getSequence());
                insertAlbum.executeUpdate();
            }
            this.DBMAlbumRC = 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMAlbumRC = 12;
            this.handleSQLException(sQLException);
        }
    }

    int getNewPrimaryKey() {
        try {
            ResultSet resultSet = newKeyAlbum.executeQuery();
            if (resultSet.next()) {
                this.DBMAlbumRC = 0;
                return resultSet.getInt("NEW_KEY");
            }
            this.DBMAlbumRC = 8;
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMAlbumRC = 12;
            this.handleSQLException(sQLException);
            return 0;
        }
    }

    public void deleteAlbum(int n, int n2) {
        try {
            deleteAlbum.setInt(1, n);
            deleteAlbum.setInt(2, n2);
            deleteAlbum.executeUpdate();
            this.DBMAlbumRC = 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMAlbumRC = 12;
            this.handleSQLException(sQLException);
        }
    }

    public void retrieveAlbum(Album album) {
        try {
            retrieveAlbum.setInt(1, album.getIdentifier());
            retrieveAlbum.setInt(2, album.getSequence());
            ResultSet resultSet = retrieveAlbum.executeQuery();
            if (resultSet.next()) {
                album.setComposer(resultSet.getString("ALB_COMPOSER"));
                album.setOrchestra(resultSet.getString("ALB_ORCHESTRA"));
                album.setConductor(resultSet.getString("ALB_CONDUCTOR"));
                album.setGenre(resultSet.getInt("ALB_GENRE"));
                this.DBMAlbumRC = 0;
                DBMArtist dBMArtist = new DBMArtist();
                dBMArtist.retrieveArtist(album.getIdentifier(), album.getSequence());
                for (int i = 0; i < dBMArtist.artList.size(); ++i) {
                    this.row = (Vector)dBMArtist.artList.get(i);
                    album.addArtist(this.row);
                }
                DBMTrack dBMTrack = new DBMTrack();
                dBMTrack.retrieveTrack(album.getIdentifier(), album.getSequence());
                for (int i = 0; i < dBMTrack.trackTitles.size(); ++i) {
                    album.trackList.add((String)dBMTrack.trackTitles.get(i));
                }
            } else {
                this.DBMAlbumRC = 8;
            }
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMAlbumRC = 12;
            this.handleSQLException(sQLException);
        }
    }

    static {
        psOpened = false;
    }
}

