/*
 * Decompiled with CFR 0.152.
 */
package com.casaerwin.brutus;

import com.casaerwin.brutus.DBM;
import com.casaerwin.brutus.DBMArtist;
import com.casaerwin.brutus.DBMTrack;
import com.casaerwin.brutus.Opera;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class DBMOpera
extends DBM {
    private static PreparedStatement newKeyOpera;
    private static PreparedStatement insertOpera;
    private static PreparedStatement deleteOpera;
    private static PreparedStatement retrieveOpera;
    public static boolean psOpened;
    int DBMOperaRC;
    SQLException sqlEx;
    Vector operaTitles;
    Vector row;

    DBMOpera() {
        if (!psOpened) {
            try {
                String string = "SELECT MAX OPE_SEQ + 1 AS NEW_KEY FROM OPERAS;";
                newKeyOpera = conn.prepareStatement(string);
                string = "INSERT INTO OPERAS VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
                insertOpera = conn.prepareStatement(string);
                string = "DELETE FROM OPERAS WHERE OPE_PARENT_ID = ? AND OPE_PARENT_KEY = ?;";
                deleteOpera = conn.prepareStatement(string);
                string = "SELECT OPE_COMPOSER, OPE_LIBRETTIST, OPE_CONDUCTOR, OPE_ORCHESTRA, OPE_CHORUS, OPE_CHORUSMASTER, OPE_DIRECTOR FROM OPERAS WHERE OPE_PARENT_ID = ? AND OPE_PARENT_KEY = ?;";
                retrieveOpera = conn.prepareStatement(string);
                this.DBMOperaRC = 0;
                psOpened = true;
            }
            catch (SQLException sQLException) {
                this.sqlEx = sQLException;
                this.DBMOperaRC = 12;
                this.handleSQLException(sQLException);
            }
        }
    }

    public void storeOpera(Opera opera) {
        try {
            insertOpera.setInt(1, this.getNewPrimaryKey());
            if (this.DBMOperaRC > 0) {
                return;
            }
            insertOpera.setString(2, opera.getComposer());
            insertOpera.setString(3, opera.getLibrettist());
            insertOpera.setString(4, opera.getConductor());
            insertOpera.setString(5, opera.getOrchestra());
            insertOpera.setString(6, opera.getChorus());
            insertOpera.setString(7, opera.getChorusMaster());
            insertOpera.setString(8, opera.getDirector());
            insertOpera.setInt(9, opera.getIdentifier());
            insertOpera.setInt(10, opera.getSequence());
            insertOpera.executeUpdate();
            this.DBMOperaRC = 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMOperaRC = 12;
            this.handleSQLException(sQLException);
        }
    }

    int getNewPrimaryKey() {
        try {
            ResultSet resultSet = newKeyOpera.executeQuery();
            if (resultSet.next()) {
                this.DBMOperaRC = 0;
                return resultSet.getInt("NEW_KEY");
            }
            this.DBMOperaRC = 8;
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMOperaRC = 12;
            this.handleSQLException(sQLException);
            return 0;
        }
    }

    public void deleteOpera(int n, int n2) {
        try {
            deleteOpera.setInt(1, n);
            deleteOpera.setInt(2, n2);
            deleteOpera.executeUpdate();
            this.DBMOperaRC = 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMOperaRC = 12;
            this.handleSQLException(sQLException);
        }
    }

    public void retrieveOpera(Opera opera) {
        try {
            retrieveOpera.setInt(1, opera.getIdentifier());
            retrieveOpera.setInt(2, opera.getSequence());
            ResultSet resultSet = retrieveOpera.executeQuery();
            int n = 0;
            while (resultSet.next()) {
                opera.setComposer(resultSet.getString("OPE_COMPOSER"));
                opera.setLibrettist(resultSet.getString("OPE_LIBRETTIST"));
                opera.setConductor(resultSet.getString("OPE_CONDUCTOR"));
                opera.setOrchestra(resultSet.getString("OPE_ORCHESTRA"));
                opera.setChorus(resultSet.getString("OPE_CHORUS"));
                opera.setChorusMaster(resultSet.getString("OPE_CHORUSMASTER"));
                opera.setDirector(resultSet.getString("OPE_DIRECTOR"));
                this.DBMOperaRC = 0;
                ++n;
            }
            if (n > 0) {
                DBMArtist dBMArtist = new DBMArtist();
                dBMArtist.retrieveArtist(opera.getIdentifier(), opera.getSequence());
                for (int i = 0; i < dBMArtist.artList.size(); ++i) {
                    this.row = (Vector)dBMArtist.artList.get(i);
                    opera.addArtist(this.row);
                }
                DBMTrack dBMTrack = new DBMTrack();
                dBMTrack.retrieveTrack(opera.getIdentifier(), opera.getSequence());
                for (int i = 0; i < dBMTrack.trackTitles.size(); ++i) {
                    opera.trackList.add((String)dBMTrack.trackTitles.get(i));
                }
            } else {
                this.DBMOperaRC = 8;
            }
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMOperaRC = 12;
            this.handleSQLException(sQLException);
        }
    }
}

