/*
 * Decompiled with CFR 0.152.
 */
package com.casaerwin.brutus;

import com.casaerwin.brutus.DBM;
import com.casaerwin.brutus.DBMArtist;
import com.casaerwin.brutus.Score;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class DBMScore
extends DBM {
    private static PreparedStatement newKeyScore;
    private static PreparedStatement insertScore;
    private static PreparedStatement deleteScore;
    private static PreparedStatement retrieveScore;
    public static boolean psOpened;
    int DBMScoreRC;
    SQLException sqlEx;
    Vector scoreTitles;
    Vector row;

    DBMScore() {
        if (!psOpened) {
            try {
                String string = "SELECT MAX SCO_SEQ + 1 AS NEW_KEY FROM SCORES;";
                newKeyScore = conn.prepareStatement(string);
                string = "INSERT INTO SCORES VALUES(?, ?, ?, ?, ?, ?, ?);";
                insertScore = conn.prepareStatement(string);
                string = "DELETE FROM SCORES WHERE SCO_PARENT_ID = ? AND SCO_PARENT_KEY = ?;";
                deleteScore = conn.prepareStatement(string);
                string = "SELECT SCO_COMPOSER, SCO_GENRE, SCO_INSTRUMENTATION, SCO_LIBRETTIST FROM SCORES WHERE SCO_PARENT_ID = ? AND SCO_PARENT_KEY = ?;";
                retrieveScore = conn.prepareStatement(string);
                this.DBMScoreRC = 0;
                psOpened = true;
            }
            catch (SQLException sQLException) {
                this.sqlEx = sQLException;
                this.DBMScoreRC = 12;
                this.handleSQLException(sQLException, "DBMScore", "Constructor");
            }
        }
    }

    public void storeScore(Score score) {
        try {
            insertScore.setInt(1, this.getNewPrimaryKey());
            if (this.DBMScoreRC > 0) {
                return;
            }
            insertScore.setString(2, score.getComposer());
            insertScore.setInt(3, score.getGenre());
            insertScore.setInt(4, score.getInstrumentation());
            insertScore.setString(5, score.getLibrettist());
            insertScore.setInt(6, score.getIdentifier());
            insertScore.setInt(7, score.getSequence());
            insertScore.executeUpdate();
            this.DBMScoreRC = 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMScoreRC = 12;
            this.handleSQLException(sQLException, "DBMScore", "storeScore()");
        }
    }

    int getNewPrimaryKey() {
        try {
            ResultSet resultSet = newKeyScore.executeQuery();
            if (resultSet.next()) {
                this.DBMScoreRC = 0;
                return resultSet.getInt("NEW_KEY");
            }
            this.DBMScoreRC = 8;
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMScoreRC = 12;
            this.handleSQLException(sQLException, "DBMScore", "getNewPrimaryKey()");
            return 0;
        }
    }

    public void deleteScore(int n, int n2) {
        try {
            deleteScore.setInt(1, n);
            deleteScore.setInt(2, n2);
            deleteScore.executeUpdate();
            this.DBMScoreRC = 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMScoreRC = 12;
            this.handleSQLException(sQLException, "DBMScore", "deleteScore()");
        }
    }

    public void retrieveScore(Score score) {
        try {
            retrieveScore.setInt(1, score.getIdentifier());
            retrieveScore.setInt(2, score.getSequence());
            ResultSet resultSet = retrieveScore.executeQuery();
            int n = 0;
            while (resultSet.next()) {
                score.setComposer(resultSet.getString("SCO_COMPOSER"));
                score.setGenre(resultSet.getInt("SCO_GENRE"));
                score.setInstrumentation(resultSet.getInt("SCO_INSTRUMENTATION"));
                score.setLibrettist(resultSet.getString("SCO_LIBRETTIST"));
                this.DBMScoreRC = 0;
                ++n;
            }
            if (n > 0) {
                DBMArtist dBMArtist = new DBMArtist();
                dBMArtist.retrieveArtist(score.getIdentifier(), score.getSequence());
                for (int i = 0; i < dBMArtist.artList.size(); ++i) {
                    this.row = (Vector)dBMArtist.artList.get(i);
                    score.addArtist(this.row);
                }
            } else {
                this.DBMScoreRC = 8;
            }
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMScoreRC = 12;
            this.handleSQLException(sQLException, "DBMScore", "retrieveScore()");
        }
    }
}

