/*
 * Decompiled with CFR 0.152.
 */
package com.casaerwin.brutus;

import com.casaerwin.brutus.DBMArtist;
import com.casaerwin.brutus.DBMEntity;
import com.casaerwin.brutus.DBMMessenger;
import com.casaerwin.brutus.DBMScore;
import com.casaerwin.brutus.Score;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class ScoreDialog
extends JDialog
implements ActionListener {
    private int rc = 0;
    DBMMessenger dbmMessenger = new DBMMessenger();
    Font hdr1Font = new Font("sanserif", 1, 16);
    Font hdr2Font = new Font("sanserif", 1, 12);
    Font labelFont = new Font("sanserif", 1, 10);
    Color lblColor = new Color(204, 204, 102);
    Color bttnColor = new Color(185, 255, 185);
    JLabel titleLabel = new JLabel(this.dbmMessenger.getMessage(26) + ": ");
    JLabel compLabel = new JLabel(this.dbmMessenger.getMessage(50) + ": ");
    JLabel librLabel = new JLabel(this.dbmMessenger.getMessage(42) + ": ");
    JLabel mediaLabel = new JLabel(this.dbmMessenger.getMessage(44) + ": ");
    JLabel genreLabel = new JLabel(this.dbmMessenger.getMessage(64) + ": ");
    JLabel instrLabel = new JLabel(this.dbmMessenger.getMessage(83) + ": ");
    JLabel locLabel = new JLabel(this.dbmMessenger.getMessage(45) + ": ");
    JLabel commLabel = new JLabel(this.dbmMessenger.getMessage(46) + ": ");
    Object[] mediaOb = new Object[]{"1 - " + this.dbmMessenger.getMessage(51), "2 - " + this.dbmMessenger.getMessage(52), "3 - " + this.dbmMessenger.getMessage(53), "4 - " + this.dbmMessenger.getMessage(0), "5 - " + this.dbmMessenger.getMessage(54)};
    Object[] genreOb = new Object[]{"01 - " + this.dbmMessenger.getMessage(8), "02 - " + this.dbmMessenger.getMessage(65), "03 - " + this.dbmMessenger.getMessage(67), "04 - " + this.dbmMessenger.getMessage(66), "05 - " + this.dbmMessenger.getMessage(68), "06 - " + this.dbmMessenger.getMessage(69), "08 - " + this.dbmMessenger.getMessage(130), "09 - " + this.dbmMessenger.getMessage(131), "10 - " + this.dbmMessenger.getMessage(132), "11 - " + this.dbmMessenger.getMessage(133), "12 - " + this.dbmMessenger.getMessage(134), "13 - " + this.dbmMessenger.getMessage(135), "14 - " + this.dbmMessenger.getMessage(136), "07 - " + this.dbmMessenger.getMessage(54)};
    Object[] instrOb = new Object[]{"01 - " + this.dbmMessenger.getMessage(84), "02 - " + this.dbmMessenger.getMessage(85), "03 - " + this.dbmMessenger.getMessage(86), "04 - " + this.dbmMessenger.getMessage(87), "05 - " + this.dbmMessenger.getMessage(88), "06 - " + this.dbmMessenger.getMessage(89), "07 - " + this.dbmMessenger.getMessage(90), "08 - " + this.dbmMessenger.getMessage(91), "09 - " + this.dbmMessenger.getMessage(92), "10 - " + this.dbmMessenger.getMessage(93), "11 - " + this.dbmMessenger.getMessage(94), "12 - " + this.dbmMessenger.getMessage(95), "13 - " + this.dbmMessenger.getMessage(96), "14 - " + this.dbmMessenger.getMessage(97)};
    JTextField titleTF = new JTextField();
    JTextField compTF = new JTextField();
    JTextField librTF = new JTextField();
    JTextField locTF = new JTextField();
    JTextArea commTA;
    JComboBox mediaCB = new JComboBox<Object>(this.mediaOb);
    JComboBox genreCB = new JComboBox<Object>(this.genreOb);
    JComboBox instrCB = new JComboBox<Object>(this.instrOb);
    JButton addButton = new JButton(this.dbmMessenger.getMessage(55));
    JButton delButton = new JButton(this.dbmMessenger.getMessage(112));
    JButton newButton = new JButton(this.dbmMessenger.getMessage(56));
    JButton updButton = new JButton(this.dbmMessenger.getMessage(57));
    JButton delOButton = new JButton(this.dbmMessenger.getMessage(58));
    JButton retButton = new JButton(this.dbmMessenger.getMessage(59));
    Vector rowData;
    Vector row;
    Vector colNames;
    JTable castTable;
    int selectedCharacterRow;
    Score score;

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    ScoreDialog(Frame frame, Score score, int n) {
        super(frame, true);
        if (n != 1) {
            if (n != 2) {
                return;
            }
        }
        this.score = score;
        this.setSize(560, 480);
        this.setTitle(this.dbmMessenger.getMessage(36));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.rowData = new Vector();
        this.colNames = new Vector();
        this.colNames.addElement(this.dbmMessenger.getMessage(38));
        if (n == 1) {
            for (int i = 0; i < 6; ++i) {
                this.row = new Vector();
                this.row.add(0, "");
                this.rowData.add(this.row);
            }
        } else if (n == 2) {
            for (int i = 0; i < this.score.characterList.size(); ++i) {
                this.row = new Vector();
                Vector vector = (Vector)this.score.characterList.get(i);
                this.row.add(0, vector.get(0));
                this.rowData.add(this.row);
            }
        }
        this.castTable = new JTable(this.rowData, this.colNames);
        this.castTable.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.castTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    ScoreDialog.this.delButton.setEnabled(false);
                } else {
                    ScoreDialog.this.selectedCharacterRow = listSelectionModel.getMinSelectionIndex();
                    ScoreDialog.this.delButton.setEnabled(true);
                }
            }
        });
        this.castTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.castTable.setFont(this.labelFont);
        JScrollPane jScrollPane = new JScrollPane(this.castTable);
        this.commTA = new JTextArea(5, 50);
        this.commTA.setFont(this.hdr2Font);
        JScrollPane jScrollPane2 = new JScrollPane(this.commTA, 22, 31);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 25.0, 5.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.newButton.setFont(this.hdr1Font);
        this.newButton.addActionListener(this);
        if (n != 1) {
            this.newButton.setEnabled(false);
        }
        gridBagLayout.setConstraints(this.newButton, gridBagConstraints);
        jPanel.add(this.newButton);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 25.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.updButton.setFont(this.hdr1Font);
        this.updButton.addActionListener(this);
        if (n != 2) {
            this.updButton.setEnabled(false);
        }
        gridBagLayout.setConstraints(this.updButton, gridBagConstraints);
        jPanel.add(this.updButton);
        this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 25.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.delOButton.setFont(this.hdr1Font);
        this.delOButton.addActionListener(this);
        if (n != 2) {
            this.delOButton.setEnabled(false);
        }
        gridBagLayout.setConstraints(this.delOButton, gridBagConstraints);
        jPanel.add(this.delOButton);
        this.buildConstraints(gridBagConstraints, 3, 0, 1, 1, 25.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.retButton.setFont(this.hdr1Font);
        this.retButton.addActionListener(this);
        gridBagLayout.setConstraints(this.retButton, gridBagConstraints);
        jPanel.add(this.retButton);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0.0, 5.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        this.titleLabel.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.titleLabel, gridBagConstraints);
        jPanel.add(this.titleLabel);
        this.buildConstraints(gridBagConstraints, 1, 1, 3, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.titleTF.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.titleTF, gridBagConstraints);
        jPanel.add(this.titleTF);
        if (n == 2) {
            this.titleTF.setText(this.score.getTitle());
        }
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0.0, 5.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        this.compLabel.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.compLabel, gridBagConstraints);
        jPanel.add(this.compLabel);
        this.buildConstraints(gridBagConstraints, 1, 2, 3, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.compTF.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.compTF, gridBagConstraints);
        jPanel.add(this.compTF);
        if (n == 2) {
            this.compTF.setText(this.score.getComposer());
        }
        this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 0.0, 5.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        this.librLabel.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.librLabel, gridBagConstraints);
        jPanel.add(this.librLabel);
        this.buildConstraints(gridBagConstraints, 1, 3, 3, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.librTF.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.librTF, gridBagConstraints);
        jPanel.add(this.librTF);
        if (n == 2) {
            this.librTF.setText(this.score.getLibrettist());
        }
        this.buildConstraints(gridBagConstraints, 0, 4, 1, 1, 0.0, 5.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        this.locLabel.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.locLabel, gridBagConstraints);
        jPanel.add(this.locLabel);
        this.buildConstraints(gridBagConstraints, 1, 4, 3, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.locTF.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.locTF, gridBagConstraints);
        jPanel.add(this.locTF);
        if (n == 2) {
            this.locTF.setText(this.score.getLocation());
        }
        this.buildConstraints(gridBagConstraints, 0, 5, 1, 1, 0.0, 5.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.mediaLabel.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.mediaLabel, gridBagConstraints);
        jPanel.add(this.mediaLabel);
        this.buildConstraints(gridBagConstraints, 1, 5, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.genreLabel.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.genreLabel, gridBagConstraints);
        jPanel.add(this.genreLabel);
        this.buildConstraints(gridBagConstraints, 2, 5, 2, 1, 0.0, 5.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.instrLabel.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.instrLabel, gridBagConstraints);
        jPanel.add(this.instrLabel);
        this.buildConstraints(gridBagConstraints, 0, 6, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.mediaCB.setFont(this.hdr2Font);
        this.mediaCB.setEditable(false);
        gridBagLayout.setConstraints(this.mediaCB, gridBagConstraints);
        jPanel.add(this.mediaCB);
        if (n == 2) {
            this.mediaCB.setSelectedIndex(this.score.getMedia() - 1);
        }
        this.buildConstraints(gridBagConstraints, 1, 6, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.genreCB.setFont(this.hdr2Font);
        this.genreCB.setEditable(false);
        gridBagLayout.setConstraints(this.genreCB, gridBagConstraints);
        jPanel.add(this.genreCB);
        if (n == 2) {
            this.genreCB.setSelectedIndex(this.score.getGenre() - 1);
        }
        this.buildConstraints(gridBagConstraints, 2, 6, 2, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.instrCB.setFont(this.hdr2Font);
        this.instrCB.setEditable(false);
        gridBagLayout.setConstraints(this.instrCB, gridBagConstraints);
        jPanel.add(this.instrCB);
        if (n == 2) {
            this.instrCB.setSelectedIndex(this.score.getInstrumentation() - 1);
        }
        this.buildConstraints(gridBagConstraints, 0, 7, 4, 1, 0.0, 25.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        this.buildConstraints(gridBagConstraints, 0, 8, 4, 1, 0.0, 5.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.addButton.setFont(this.hdr1Font);
        this.addButton.addActionListener(this);
        gridBagLayout.setConstraints(this.addButton, gridBagConstraints);
        jPanel.add(this.addButton);
        this.buildConstraints(gridBagConstraints, 0, 9, 4, 1, 0.0, 5.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.commLabel.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.commLabel, gridBagConstraints);
        jPanel.add(this.commLabel);
        this.buildConstraints(gridBagConstraints, 0, 10, 4, 1, 0.0, 25.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jScrollPane2, gridBagConstraints);
        jPanel.add(jScrollPane2);
        if (n == 2) {
            this.commTA.append(this.score.getComments());
        }
        this.setContentPane(jPanel);
        this.setVisible(true);
    }

    public void addRow(DefaultTableModel defaultTableModel) {
        this.row = new Vector();
        this.row.add(0, "");
        defaultTableModel.addRow(this.row);
        defaultTableModel.fireTableDataChanged();
    }

    public void deleteRow(DefaultTableModel defaultTableModel) {
        defaultTableModel.removeRow(this.selectedCharacterRow);
        defaultTableModel.fireTableDataChanged();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addButton) {
            this.addRow((DefaultTableModel)this.castTable.getModel());
        } else if (object == this.delButton) {
            this.deleteRow((DefaultTableModel)this.castTable.getModel());
        } else if (object == this.newButton) {
            this.validateScore();
            if (this.rc == 0) {
                this.populateScore();
                DBMEntity dBMEntity = new DBMEntity();
                dBMEntity.storeEntity(this.score);
                DBMScore dBMScore = new DBMScore();
                dBMScore.storeScore(this.score);
                DBMArtist dBMArtist = new DBMArtist();
                int n = 0;
                int n2 = this.score.characterList.size();
                for (int i = n; i < n2; ++i) {
                    this.row = (Vector)this.score.characterList.get(i);
                    dBMArtist.storeArtist((String)this.row.get(1), (String)this.row.get(2), (String)this.row.get(0), this.score.getIdentifier(), this.score.getSequence());
                }
                this.resetDialog();
            }
        } else if (object == this.updButton) {
            this.validateScore();
            if (this.rc == 0) {
                this.populateScore();
                DBMEntity dBMEntity = new DBMEntity();
                dBMEntity.updateEntity(this.score);
                DBMScore dBMScore = new DBMScore();
                dBMScore.deleteScore(this.score.getIdentifier(), this.score.getSequence());
                dBMScore.storeScore(this.score);
                DBMArtist dBMArtist = new DBMArtist();
                dBMArtist.deleteArtist(this.score.getIdentifier(), this.score.getSequence());
                int n = 0;
                int n3 = this.score.characterList.size();
                for (int i = n; i < n3; ++i) {
                    this.row = (Vector)this.score.characterList.get(i);
                    dBMArtist.storeArtist((String)this.row.get(1), (String)this.row.get(2), (String)this.row.get(0), this.score.getIdentifier(), this.score.getSequence());
                }
                if (dBMEntity.DBMEntityRC == 0) {
                    if (dBMScore.DBMScoreRC == 0) {
                        this.setVisible(false);
                    }
                }
            }
        } else if (object == this.delOButton) {
            String string = this.dbmMessenger.getMessage(137) + " " + this.score.getTitle() + " " + this.dbmMessenger.getMessage(139) + "?";
            int n = JOptionPane.showConfirmDialog(null, string);
            if (n == 0) {
                DBMEntity dBMEntity = new DBMEntity();
                dBMEntity.deleteEntity(this.score);
                if (dBMEntity.DBMEntityRC == 0) {
                    string = this.score.getTitle() + " " + this.dbmMessenger.getMessage(138) + ".";
                    JOptionPane.showMessageDialog(null, string);
                    this.setVisible(false);
                }
            }
        } else if (object == this.retButton) {
            this.setVisible(false);
        }
    }

    public void validateScore() {
        DBMMessenger dBMMessenger = new DBMMessenger();
        String string = dBMMessenger.getMessage(60);
        if (this.titleTF.getText().equals("") || this.titleTF.getText() == null) {
            String string2 = dBMMessenger.getMessage(26) + ": " + string;
            JOptionPane.showMessageDialog(null, string2, string, 0);
            this.titleTF.setCaretPosition(0);
            this.rc = 1;
        } else if (this.locTF.getText().equals("") || this.locTF.getText() == null) {
            String string3 = dBMMessenger.getMessage(45) + ": " + string;
            JOptionPane.showMessageDialog(null, string3, string, 0);
            this.locTF.setCaretPosition(0);
            this.rc = 1;
        }
    }

    public void populateScore() {
        this.score.setTitle(this.titleTF.getText());
        this.score.setComposer(this.compTF.getText());
        this.score.setLibrettist(this.librTF.getText());
        this.score.setLocation(this.locTF.getText());
        String string = (String)this.mediaCB.getSelectedItem();
        this.score.setMedia(Integer.parseInt(string.substring(0, 1)));
        String string2 = (String)this.genreCB.getSelectedItem();
        this.score.setGenre(Integer.parseInt(string2.substring(0, 2)));
        String string3 = (String)this.instrCB.getSelectedItem();
        this.score.setInstrumentation(Integer.parseInt(string3.substring(0, 2)));
        this.score.characterList.clear();
        int n = 0;
        int n2 = this.castTable.getRowCount();
        for (int i = n; i < n2; ++i) {
            String string4 = (String)this.castTable.getValueAt(i, 0);
            if (string4.equals("")) continue;
            this.row = new Vector();
            this.row.add(0, string4);
            this.row.add(1, "");
            this.row.add(2, "");
            this.score.addCharacter(this.row);
        }
        this.score.setComments(this.commTA.getText());
    }

    public void resetDialog() {
        this.titleTF.setText("");
        this.compTF.setText("");
        this.librTF.setText("");
        this.locTF.setText("");
        this.commTA.setText("");
        this.mediaCB.setSelectedItem(this.mediaOb[0]);
        this.genreCB.setSelectedItem(this.genreOb[0]);
        this.instrCB.setSelectedItem(this.instrOb[0]);
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.castTable.getModel();
        if (defaultTableModel.getRowCount() > 0) {
            int n;
            for (n = defaultTableModel.getRowCount() - 1; n >= 0; --n) {
                defaultTableModel.removeRow(n);
            }
            for (n = 0; n < 6; ++n) {
                this.row = new Vector();
                this.row.add(0, "");
                defaultTableModel.addRow(this.row);
            }
        }
    }
}

