/*
 * Decompiled with CFR 0.152.
 */
package com.lemckes.cellarboss;

import com.lemckes.cellarboss.CellarBoss;
import com.lemckes.cellarboss.IdName;
import com.lemckes.cellarboss.IdNameList;
import com.lemckes.cellarboss.IdNameWithDefaultManagerView;
import com.lemckes.cellarboss.VarietiesIdNameTableModel;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;

public class VarietiesManagerView
extends IdNameWithDefaultManagerView {
    private static final String DEFAULT_LABEL = "Style";

    public VarietiesManagerView(IdNameList idNameList, IdNameList idNameSelectorList) {
        super(idNameList, idNameSelectorList, DEFAULT_LABEL);
        this.idNameSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VarietiesManagerView.this.checkInput();
                    }
                });
            }
        });
    }

    @Override
    protected void setTableModel() {
        this.getDataTable().setModel(new VarietiesIdNameTableModel(this.idNameList));
    }

    @Override
    public void setSelectorModels() {
        IdName sel = this.idNameSelector.getSelected();
        this.idNameSelector.setIdNames(CellarBoss.getWineList().getStyles());
        this.idNameSelector.setSelected(sel);
    }

    @Override
    protected void checkInput() {
        boolean styleChanged;
        boolean enabled = false;
        boolean hasText = this.getNameFieldText().length() > 0;
        boolean textChanged = !this.editIdName.getName().equals(this.getNameFieldText());
        boolean textUnique = !this.idNameList.containsName(this.getNameFieldText());
        Integer variety = this.editIdName.getId();
        Integer style = null;
        if (this.idNameSelector.getSelected() != null) {
            style = this.idNameSelector.getSelected().getId();
        }
        Integer defaultStyle = CellarBoss.getWineList().getDefaultStyle(variety);
        boolean bl = styleChanged = style != CellarBoss.getWineList().getDefaultStyle(variety);
        if (hasText) {
            enabled = textChanged && textUnique || !textChanged && styleChanged;
        }
        this.enableSaveButton(enabled);
    }

    @Override
    protected boolean saveDefaultRecord() throws SQLException {
        boolean saved = true;
        Integer variety = this.editIdName.getId();
        variety = CellarBoss.getWineList().getVarieties().findIdNameForName(this.editIdName.getName()).getId();
        Integer style = this.idNameSelector.getSelected().getId();
        CellarBoss.getWineList().setVarietyStyle(variety, style);
        return saved;
    }

    @Override
    protected void newRecord() {
        super.newRecord();
        this.idNameSelector.setSelected((IdName)null);
    }

    @Override
    protected void editRecord() {
        super.editRecord();
        Integer variety = this.editIdName.getId();
        Integer style = CellarBoss.getWineList().getDefaultStyle(variety);
        this.idNameSelector.setSelected(style);
    }

    @Override
    protected void deleteRecord() {
        super.deleteRecord();
        Integer variety = this.editIdName.getId();
        CellarBoss.getWineList().deleteDefaultStyle(variety);
    }
}

