/*
 * Decompiled with CFR 0.152.
 */
package com.lemckes.cellarboss;

import com.lemckes.cellarboss.Bottle;
import com.lemckes.cellarboss.IdName;
import com.lemckes.cellarboss.IdNameList;
import com.lemckes.cellarboss.util.DatabaseConnection;
import com.lemckes.cellarboss.util.DbUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.EventListenerList;

public class WineList {
    private List<Bottle> bottles = new ArrayList<Bottle>();
    private IdNameList wineries;
    private IdNameList regions;
    private Map<Integer, Integer> wineryRegions;
    private IdNameList varieties;
    private IdNameList styles;
    private Map<Integer, Integer> varietyStyles;
    private IdNameList locations;
    private Connection connection;
    private boolean dataOk = false;
    private EventListenerList listenerList;

    public WineList(Properties props) {
        try {
            DatabaseConnection.setProperties(props);
            this.connection = DatabaseConnection.getConnection();
            this.wineries = new IdNameList(this.connection, "wineries");
            this.regions = new IdNameList(this.connection, "regions");
            this.varieties = new IdNameList(this.connection, "varieties");
            this.styles = new IdNameList(this.connection, "styles");
            this.locations = new IdNameList(this.connection, "locations");
            this.wineryRegions = new HashMap<Integer, Integer>();
            this.varietyStyles = new HashMap<Integer, Integer>();
            this.listenerList = new EventListenerList();
        }
        catch (SQLException ex) {
            DatabaseConnection.closeConnection();
            DbUtils.logSQLException(this.getClass(), "WineList.<init>", ex);
        }
    }

    public void readDatabase() throws SQLException {
        this.wineries.readRecords();
        this.regions.readRecords();
        this.varieties.readRecords();
        this.styles.readRecords();
        this.locations.readRecords();
        this.readWineryRegions();
        this.readVarietyStyles();
        this.readBottles();
        this.dataOk = true;
    }

    private void readBottles() throws SQLException {
        String q = "select * from bottles order by winery, style, variety, name, vintage";
        PreparedStatement ps = this.connection.prepareStatement(q);
        ps.execute();
        ResultSet rs = ps.getResultSet();
        while (rs.next()) {
            int winery = rs.getInt("winery");
            IdName w = this.wineries.findIdNameForId(winery);
            int region = rs.getInt("region");
            IdName r = this.regions.findIdNameForId(region);
            int variety = rs.getInt("variety");
            IdName v = this.varieties.findIdNameForId(variety);
            int style = rs.getInt("style");
            IdName s = this.styles.findIdNameForId(style);
            int location = rs.getInt("location");
            IdName l = this.locations.findIdNameForId(location);
            int vintage = rs.getInt("vintage");
            int keepTil = rs.getInt("keep_til");
            String notes = rs.getString("notes");
            String name = rs.getString("name");
            int quantity = rs.getInt("quantity");
            int price = rs.getInt("price");
            int id = rs.getInt("id");
            Bottle b = new Bottle(w, r, v, vintage, keepTil, notes, price, quantity, l, s, name, id);
            this.bottles.add(b);
        }
    }

    public void saveBottle(Bottle bottle) throws SQLException {
        boolean isNewBottle = bottle.getId() == null;
        String q = isNewBottle ? "insert into bottles (winery, region, variety, vintage, keep_til, notes, price, quantity, location, style, name) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)" : "update bottles set winery=?, region=?, variety=?, vintage=?, keep_til=?, notes=?, price=?, quantity=?, location=?, style=?, name=? where id = ?";
        PreparedStatement ps = this.connection.prepareStatement(q);
        int paramIndex = 1;
        ps.setInt(paramIndex++, bottle.getWinery().getId());
        ps.setInt(paramIndex++, bottle.getRegion().getId());
        ps.setInt(paramIndex++, bottle.getVariety().getId());
        ps.setInt(paramIndex++, bottle.getVintage());
        ps.setInt(paramIndex++, bottle.getKeepTil());
        ps.setString(paramIndex++, bottle.getNotes());
        ps.setInt(paramIndex++, bottle.getPrice());
        ps.setInt(paramIndex++, bottle.getQuantity());
        ps.setInt(paramIndex++, bottle.getLocation().getId());
        ps.setInt(paramIndex++, bottle.getStyle().getId());
        ps.setString(paramIndex++, bottle.getName());
        if (!isNewBottle) {
            ps.setInt(paramIndex++, bottle.getId());
        }
        ps.executeUpdate();
        if (isNewBottle) {
            this.bottles.clear();
            this.readBottles();
        }
        this.fireDataUpdated();
    }

    public void deleteBottle(Bottle bottle) throws SQLException {
        String q = "delete from bottles where id = " + bottle.getId();
        PreparedStatement ps = this.connection.prepareStatement(q);
        ps.executeUpdate();
        this.bottles.remove(bottle);
        this.fireDataUpdated();
    }

    private void readWineryRegions() throws SQLException {
        String q = "select * from default_regions";
        PreparedStatement ps = this.connection.prepareStatement(q);
        ps.execute();
        ResultSet rs = ps.getResultSet();
        while (rs.next()) {
            int winery = rs.getInt("winery_id");
            int region = rs.getInt("region_id");
            this.wineryRegions.put(winery, region);
        }
    }

    public void setWineryRegion(Integer winery, Integer region) throws SQLException {
        PreparedStatement ps = null;
        try {
            boolean isNewRecord = !this.wineryRegions.containsKey(winery);
            String q = isNewRecord ? "insert into default_regions (region_id, winery_id) values (?, ?)" : "update default_regions set region_id=? where winery_id=?";
            ps = this.connection.prepareStatement(q);
            int paramIndex = 1;
            ps.setInt(paramIndex++, region);
            ps.setInt(paramIndex++, winery);
            ps.executeUpdate();
            DbUtils.closeStatement(ps);
            this.wineryRegions.put(winery, region);
        }
        catch (SQLException ex) {
            DbUtils.closeStatement(ps);
            throw ex;
        }
    }

    public Integer getDefaultRegion(Integer winery) {
        return this.wineryRegions.get(winery);
    }

    public void deleteDefaultRegion(Integer winery) {
        PreparedStatement ps = null;
        try {
            String q = "delete from default_regions where id = " + winery;
            ps = this.connection.prepareStatement(q);
            ps.executeUpdate();
            DbUtils.closeStatement(ps);
            this.wineryRegions.remove(winery);
        }
        catch (SQLException ex) {
            DbUtils.closeStatement(ps);
            DbUtils.logSQLException(this.getClass(), "deleteDefaultRegion", ex);
        }
    }

    private void readVarietyStyles() throws SQLException {
        String q = "select * from default_styles";
        PreparedStatement ps = this.connection.prepareStatement(q);
        ps.execute();
        ResultSet rs = ps.getResultSet();
        while (rs.next()) {
            int variety = rs.getInt("variety_id");
            int style = rs.getInt("style_id");
            this.varietyStyles.put(variety, style);
        }
    }

    public void setVarietyStyle(Integer variety, Integer style) throws SQLException {
        PreparedStatement ps = null;
        try {
            boolean isNewRecord = !this.varietyStyles.containsKey(variety);
            String q = isNewRecord ? "insert into default_styles(style_id, variety_id) values (?, ?)" : "update default_styles set style_id=? where variety_id=?";
            ps = this.connection.prepareStatement(q);
            int paramIndex = 1;
            ps.setInt(paramIndex++, style);
            ps.setInt(paramIndex++, variety);
            ps.executeUpdate();
            DbUtils.closeStatement(ps);
            this.varietyStyles.put(variety, style);
        }
        catch (SQLException ex) {
            DbUtils.closeStatement(ps);
            throw ex;
        }
    }

    public Integer getDefaultStyle(Integer variety) {
        return this.varietyStyles.get(variety);
    }

    public void deleteDefaultStyle(Integer variety) {
        PreparedStatement ps = null;
        try {
            String q = "delete from default_styles where id = " + variety;
            ps = this.connection.prepareStatement(q);
            ps.executeUpdate();
            DbUtils.closeStatement(ps);
            this.varietyStyles.remove(variety);
        }
        catch (SQLException ex) {
            DbUtils.closeStatement(ps);
            DbUtils.logSQLException(this.getClass(), "deleteDefaultStyle", ex);
        }
    }

    public void addUpdateListener(UpdateListener l) {
        this.listenerList.add(UpdateListener.class, l);
    }

    public void removeUpdateListener(UpdateListener l) {
        this.listenerList.remove(UpdateListener.class, l);
    }

    private void fireDataUpdated() {
        for (UpdateListener l : (UpdateListener[])this.listenerList.getListeners(UpdateListener.class)) {
            l.dataUpdated();
        }
    }

    public List<Bottle> getBottles() {
        return this.bottles;
    }

    public IdNameList getLocations() {
        return this.locations;
    }

    public IdNameList getRegions() {
        return this.regions;
    }

    public IdNameList getStyles() {
        return this.styles;
    }

    public IdNameList getVarieties() {
        return this.varieties;
    }

    public Map<Integer, Integer> getVarietyStyles() {
        return this.varietyStyles;
    }

    public IdNameList getWineries() {
        return this.wineries;
    }

    public Map<Integer, Integer> getWineryRegions() {
        return this.wineryRegions;
    }

    public boolean isDataOk() {
        return this.dataOk;
    }

    public static interface UpdateListener
    extends EventListener {
        public void dataUpdated();
    }
}

