/*
 * Decompiled with CFR 0.152.
 */
package com.lemckes.cellarboss;

import com.lemckes.cellarboss.Bottle;
import com.lemckes.cellarboss.WineList;
import javax.swing.table.AbstractTableModel;

public class WineListTableModel
extends AbstractTableModel
implements WineList.UpdateListener {
    WineList wineList;

    public WineListTableModel() {
    }

    public WineListTableModel(WineList wineList) {
        this.wineList = wineList;
        this.wineList.addUpdateListener(this);
    }

    @Override
    public void dataUpdated() {
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return Columns.values().length;
    }

    @Override
    public String getColumnName(int column) {
        return Columns.values()[column].displayName;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Columns.values()[columnIndex].klass;
    }

    @Override
    public int getRowCount() {
        int count = 0;
        if (this.wineList != null) {
            count = this.wineList.getBottles().size();
        }
        return count;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object value = null;
        Columns col = Columns.values()[column];
        Bottle bot = this.wineList.getBottles().get(row);
        switch (col) {
            case ID: {
                value = bot.getId();
                break;
            }
            case KEEPTIL: {
                value = bot.getKeepTil();
                break;
            }
            case LOCATION: {
                value = bot.getLocation();
                break;
            }
            case NAME: {
                value = bot.getName();
                break;
            }
            case NOTES: {
                value = bot.getNotes();
                break;
            }
            case PRICE: {
                value = bot.getPrice();
                break;
            }
            case QUANTITY: {
                value = bot.getQuantity();
                break;
            }
            case REGION: {
                value = bot.getRegion();
                break;
            }
            case STYLE: {
                value = bot.getStyle();
                break;
            }
            case VARIETY: {
                value = bot.getVariety();
                break;
            }
            case VINTAGE: {
                value = bot.getVintage();
                break;
            }
            case WINERY: {
                value = bot.getWinery();
            }
        }
        return value;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public static enum Columns {
        WINERY("Winery", Object.class),
        NAME("Name", String.class),
        VARIETY("Variety", Object.class),
        VINTAGE("Vintage", Integer.class),
        KEEPTIL("Keep 'til", Integer.class),
        QUANTITY("Quantity", Integer.class),
        LOCATION("Location", Object.class),
        NOTES("Notes", String.class),
        PRICE("Price", Integer.class),
        REGION("Region", Object.class),
        STYLE("Style", Object.class),
        ID("Id", Integer.class);

        String displayName;
        Class klass;

        private Columns(String name, Class clasz) {
            this.displayName = name;
            this.klass = clasz;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Class getColumnClass() {
            return this.klass;
        }
    }
}

