/*
 * Decompiled with CFR 0.152.
 */
package com.lemckes.cellarboss.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatabaseConnection {
    private static String dbSystemHome = "/home/shared/Derby";
    private static String dbDriver = "org.apache.derby.jdbc.EmbeddedDriver";
    private static String dbDatabase = "jdbc:derby:winelist;create=true";
    private static Connection connection;

    public static void setProperties(Properties props) {
        Properties p = System.getProperties();
        p.setProperty("derby.system.home", props.getProperty("derby.system.home", dbSystemHome));
    }

    private static Connection createConnection() throws SQLException {
        Connection con = null;
        try {
            Class.forName(dbDriver).newInstance();
            con = DriverManager.getConnection(dbDatabase);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(DatabaseConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(DatabaseConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DatabaseConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
        return con;
    }

    public static Connection getConnection() throws SQLException {
        if (connection == null) {
            connection = DatabaseConnection.createConnection();
        }
        return connection;
    }

    public static void closeConnection() {
        try {
            if (connection != null) {
                connection.close();
            }
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 50000 && "XJ015".equals(ex.getSQLState())) {
                System.out.println("Derby shut down normally");
            }
            System.err.println("Derby did not shut down normally");
            ex.printStackTrace();
        }
    }
}

