/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementTransformer;
import net.sf.jasperreports.engine.export.GenericElementTransformerContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericElementReportTransformer {
    private static final Log log = LogFactory.getLog(GenericElementReportTransformer.class);

    public static void transformGenericElements(JasperPrint report, String transformerExportKey) {
        TransformerContext transformerContext = new TransformerContext(report);
        List pages = report.getPages();
        Iterator pageIt = pages.iterator();
        while (pageIt.hasNext()) {
            JRPrintPage page = (JRPrintPage)pageIt.next();
            GenericElementReportTransformer.transformElements(transformerContext, transformerExportKey, page.getElements());
        }
    }

    protected static void transformElements(TransformerContext context, String transformerExportKey, List elements) {
        ListIterator<JRPrintElement> it = elements.listIterator();
        while (it.hasNext()) {
            JRPrintElement element = (JRPrintElement)it.next();
            if (element instanceof JRGenericPrintElement) {
                JRGenericPrintElement genericElement = (JRGenericPrintElement)element;
                GenericElementTransformer handler = (GenericElementTransformer)GenericElementHandlerEnviroment.getHandler(genericElement.getGenericType(), transformerExportKey);
                if (handler == null || !handler.toExport(genericElement)) continue;
                JRPrintElement transformed = handler.transformElement(context, genericElement);
                if (log.isDebugEnabled()) {
                    log.debug("Transformed element " + genericElement + " to " + transformed + " using the " + transformerExportKey + " transformer");
                }
                it.set(transformed);
                continue;
            }
            if (!(element instanceof JRPrintFrame)) continue;
            JRPrintFrame frame = (JRPrintFrame)element;
            GenericElementReportTransformer.transformElements(context, transformerExportKey, frame.getElements());
        }
    }

    protected static class TransformerContext
    implements GenericElementTransformerContext {
        private final JasperPrint report;

        public TransformerContext(JasperPrint report) {
            this.report = report;
        }

        public JasperPrint getReport() {
            return this.report;
        }
    }
}

