/*
 * Decompiled with CFR 0.152.
 */
package panels;

import application.Schedule;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import panels.CoursesTableModel;
import panels.TableSorter;
import resources.Course;

public class CoursesPanel
extends JPanel
implements Observer {
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JTextField tfCredits;
    private JTextField tfHowMany;
    private JTextField tfName;
    private JTextField tfNumber;
    private JTextField tfPrefix;
    private JTextField tfSectionPrefix;
    private CoursesPanelListener coursesPanelListener;
    private Schedule schedule = Schedule.getSchedule();
    private CoursesTableModel ptm;
    private TableSorter sorter;
    private TableColumn prefixColumn;
    private TableColumn numberColumn;
    private TableColumn sectionColumn;
    private TableColumn nameColumn;
    private TableColumn creditsColumn;
    private JTextField editPrefix = new JTextField();
    private JTextField editNumber = new JTextField();
    private JTextField editSection = new JTextField();
    private JTextField editName = new JTextField();
    private JTextField editCredits = new JTextField();

    public CoursesPanel() {
        this.initComponents();
        this.ptm = new CoursesTableModel();
        this.sorter = new TableSorter(this.ptm);
        this.sorter.addMouseListenerToHeaderInTable(this.jTable1);
        this.jTable1.setModel(this.sorter);
        this.addListeners();
        this.setColumnSizes();
    }

    private void setColumnSizes() {
        TableColumn column = null;
        column = this.jTable1.getColumnModel().getColumn(0);
        column.setPreferredWidth(30);
        column = this.jTable1.getColumnModel().getColumn(1);
        column.setPreferredWidth(30);
        column = this.jTable1.getColumnModel().getColumn(2);
        column.setPreferredWidth(30);
        column = this.jTable1.getColumnModel().getColumn(3);
        column.setPreferredWidth(70);
        column = this.jTable1.getColumnModel().getColumn(4);
        column.setPreferredWidth(30);
        this.prefixColumn = this.jTable1.getColumnModel().getColumn(0);
        this.prefixColumn.setCellEditor(new DefaultCellEditor(this.editPrefix));
        this.numberColumn = this.jTable1.getColumnModel().getColumn(1);
        this.numberColumn.setCellEditor(new DefaultCellEditor(this.editNumber));
        this.sectionColumn = this.jTable1.getColumnModel().getColumn(2);
        this.sectionColumn.setCellEditor(new DefaultCellEditor(this.editSection));
        this.nameColumn = this.jTable1.getColumnModel().getColumn(3);
        this.nameColumn.setCellEditor(new DefaultCellEditor(this.editName));
        this.creditsColumn = this.jTable1.getColumnModel().getColumn(4);
        this.creditsColumn.setCellEditor(new DefaultCellEditor(this.editCredits));
    }

    private void addListeners() {
        this.coursesPanelListener = new CoursesPanelListener();
        this.jButton1.addActionListener(this.coursesPanelListener);
        this.jButton2.addActionListener(this.coursesPanelListener);
        CourseColListener ccl = new CourseColListener();
        this.editPrefix.addActionListener(ccl);
        this.editNumber.addActionListener(ccl);
        this.editSection.addActionListener(ccl);
        this.editName.addActionListener(ccl);
        this.editCredits.addActionListener(ccl);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel3 = new JPanel();
        this.jButton1 = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.tfPrefix = new JTextField();
        this.tfNumber = new JTextField();
        this.tfName = new JTextField();
        this.tfCredits = new JTextField();
        this.tfSectionPrefix = new JTextField();
        this.tfHowMany = new JTextField();
        this.jPanel4 = new JPanel();
        this.jButton2 = new JButton();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jScrollPane1.setToolTipText("Double Click in cell to change section info, or on header to sort");
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setToolTipText("Double click to change info in cell");
        this.jScrollPane1.setViewportView(this.jTable1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 0.9;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButton1.setText("Delete Selected Course(s)");
        this.jButton1.setToolTipText("Delete selected sections from list");
        this.jButton1.setMaximumSize(new Dimension(250, 26));
        this.jButton1.setMinimumSize(new Dimension(200, 26));
        this.jButton1.setPreferredSize(new Dimension(215, 26));
        this.jPanel3.add(this.jButton1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 17, 0);
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = -53;
        gridBagConstraints.ipady = -25;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(17, 17, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(new CompoundBorder(new EtchedBorder(), new BevelBorder(0)));
        this.jLabel1.setText("Course Prefix:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(17, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Number:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Credits:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("Section Prefix:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText("How Many Sections:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        this.tfPrefix.setToolTipText("e.g. COP for Computer Programming");
        this.tfPrefix.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CoursesPanel.this.tfPrefixActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(17, 6, 0, 18);
        this.jPanel2.add((Component)this.tfPrefix, gridBagConstraints);
        this.tfNumber.setToolTipText("e.g. 2800");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 18);
        this.jPanel2.add((Component)this.tfNumber, gridBagConstraints);
        this.tfName.setToolTipText("e.g. Intro to Java");
        this.tfName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CoursesPanel.this.tfNameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 18);
        this.jPanel2.add((Component)this.tfName, gridBagConstraints);
        this.tfCredits.setToolTipText("e.g. 3.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 18);
        this.jPanel2.add((Component)this.tfCredits, gridBagConstraints);
        this.tfSectionPrefix.setToolTipText("usually a single character.  may be left blank.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 18);
        this.jPanel2.add((Component)this.tfSectionPrefix, gridBagConstraints);
        this.tfHowMany.setToolTipText("add this many sections to the list at one time.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 18);
        this.jPanel2.add((Component)this.tfHowMany, gridBagConstraints);
        this.jButton2.setText("Add Course Sections");
        this.jButton2.setToolTipText("Add these sections to the list");
        this.jPanel4.add(this.jButton2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 17, 0);
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(17, 17, 0, 17);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void tfNameActionPerformed(ActionEvent evt) {
    }

    private void tfPrefixActionPerformed(ActionEvent evt) {
    }

    public void update(Observable observable, Object obj) {
        this.ptm.fireTableDataChanged();
    }

    class CourseColListener
    implements ActionListener {
        CourseColListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int row = CoursesPanel.this.jTable1.getSelectedRow();
            int theRealIndex = CoursesPanel.this.sorter.map(row);
            Course courseModified = (Course)CoursesPanel.this.schedule.getCourses().get(theRealIndex);
            if (e.getSource() == CoursesPanel.this.editPrefix) {
                System.out.println("I hear edit the prefix");
                String prefixString = CoursesPanel.this.editPrefix.getText().trim().toUpperCase();
                courseModified.setField(prefixString);
            } else if (e.getSource() == CoursesPanel.this.editNumber) {
                String prefixString = CoursesPanel.this.editNumber.getText().trim();
                courseModified.setCourseNumber(prefixString);
            } else if (e.getSource() == CoursesPanel.this.editSection) {
                String whole = CoursesPanel.this.editSection.getText().trim();
                if (whole.indexOf(45) > 0) {
                    StringTokenizer stTok = new StringTokenizer(whole, "-");
                    if (stTok.hasMoreTokens()) {
                        courseModified.setSectionPrefix(stTok.nextToken());
                    }
                    if (stTok.hasMoreTokens()) {
                        String number = stTok.nextToken().trim();
                        try {
                            int num = Integer.parseInt(number);
                            courseModified.setSectionNumber(num);
                        }
                        catch (NumberFormatException nfe) {
                            return;
                        }
                    }
                }
            } else if (e.getSource() == CoursesPanel.this.editName) {
                String nameString = CoursesPanel.this.editName.getText().trim();
                courseModified.setCourseName(nameString);
            } else if (e.getSource() == CoursesPanel.this.editCredits) {
                int creditHours;
                String creditsString = CoursesPanel.this.editPrefix.getText().trim();
                try {
                    creditHours = (int)Double.parseDouble(creditsString);
                }
                catch (NumberFormatException nfe) {
                    return;
                }
                courseModified.setCreditHours(creditHours);
            }
            CoursesPanel.this.schedule.setChanged(true);
        }
    }

    class CoursesPanelListener
    implements ActionListener {
        CoursesPanelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("I hear |" + e.getActionCommand() + "|");
            if (e.getActionCommand().equals("Add Course Sections")) {
                String prefix = CoursesPanel.this.tfPrefix.getText().trim().toUpperCase();
                String courseNumber = CoursesPanel.this.tfNumber.getText().trim();
                String courseName = CoursesPanel.this.tfName.getText().trim();
                String creditHoursString = CoursesPanel.this.tfCredits.getText().trim();
                int creditHours = 0;
                try {
                    creditHours = Integer.parseInt(creditHoursString);
                }
                catch (Exception ex) {
                    try {
                        creditHours = (int)Double.parseDouble(creditHoursString);
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                }
                if (prefix.length() != 0 && courseNumber.length() != 0 && courseName.length() != 0) {
                    int sections = this.getSectionCount();
                    String sectionPrefix = CoursesPanel.this.tfSectionPrefix.getText().trim().length() == 0 ? "Sect" : CoursesPanel.this.tfSectionPrefix.getText().trim();
                    for (int i = 1; i <= sections; ++i) {
                        Course hold = new Course(prefix, courseNumber, courseName, sectionPrefix, i, creditHours);
                        CoursesPanel.this.schedule.addCourse(hold);
                    }
                    CoursesPanel.this.tfPrefix.setText("");
                    CoursesPanel.this.tfNumber.setText("");
                    CoursesPanel.this.tfName.setText("");
                    CoursesPanel.this.tfSectionPrefix.setText("");
                    CoursesPanel.this.tfHowMany.setText("");
                }
            } else if (e.getActionCommand().equals("Delete Selected Course(s)")) {
                System.out.println("I'm deleting a course over here");
                int[] selected = CoursesPanel.this.jTable1.getSelectedRows();
                for (int i = selected.length - 1; i >= 0; --i) {
                    int realIndex = CoursesPanel.this.sorter.map(selected[i]);
                    CoursesPanel.this.schedule.removeCourse((Course)CoursesPanel.this.schedule.getCourses().get(realIndex));
                }
            }
        }

        private int getSectionCount() {
            int sections;
            try {
                sections = Integer.parseInt(CoursesPanel.this.tfHowMany.getText());
            }
            catch (Exception e) {
                sections = 1;
            }
            System.out.println("Making sections: " + sections);
            return sections;
        }
    }
}

