/*
 * Decompiled with CFR 0.152.
 */
package panels;

import application.Schedule;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import panels.TableSorter;
import resources.Professor;

public class ProfessorsPanel
extends JPanel
implements Observer {
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JScrollPane jScrollPane1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTable profTable;
    private ProfessorPanelListener professorPanelListener;
    private Schedule schedule = Schedule.getSchedule();
    private ProfessorTableModel ptm;
    private TableSorter sorter;
    private TableColumn firstColumn;
    private TableColumn lastColumn;
    private TableColumn statusColumn;
    private JTextField editFirst = new JTextField();
    private JTextField editLast = new JTextField();
    private JComboBox cbStatus = new JComboBox<String>(new String[]{"Full Time", "Adjunct"});

    public ProfessorsPanel() {
        this.initComponents();
        this.ptm = new ProfessorTableModel();
        this.sorter = new TableSorter(this.ptm);
        this.sorter.addMouseListenerToHeaderInTable(this.profTable);
        this.profTable.setModel(this.sorter);
        this.addListeners();
        this.setColumnSizes();
    }

    private void setColumnSizes() {
        TableColumn column = null;
        column = this.profTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(100);
        column = this.profTable.getColumnModel().getColumn(1);
        column.setPreferredWidth(100);
        column = this.profTable.getColumnModel().getColumn(2);
        column.setPreferredWidth(50);
        this.firstColumn = this.profTable.getColumnModel().getColumn(0);
        this.lastColumn = this.profTable.getColumnModel().getColumn(1);
        this.statusColumn = this.profTable.getColumnModel().getColumn(2);
        this.firstColumn.setCellEditor(new DefaultCellEditor(this.editFirst));
        this.lastColumn.setCellEditor(new DefaultCellEditor(this.editLast));
        this.statusColumn.setCellEditor(new DefaultCellEditor(this.cbStatus));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.profTable = new JTable();
        this.jPanel3 = new JPanel();
        this.jButton1 = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jPanel5 = new JPanel();
        this.jButton2 = new JButton();
        this.jPanel6 = new JPanel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.setAutoscrolls(true);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setMaximumSize(new Dimension(300, Integer.MAX_VALUE));
        this.jPanel2.setMinimumSize(new Dimension(260, 260));
        this.jPanel2.setPreferredSize(new Dimension(250, 400));
        this.jScrollPane1.setToolTipText("Double click header to sort");
        this.jScrollPane1.setMaximumSize(new Dimension(260, Short.MAX_VALUE));
        this.jScrollPane1.setMinimumSize(new Dimension(250, 22));
        this.jScrollPane1.setPreferredSize(new Dimension(250, 153));
        this.profTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.profTable.setToolTipText("Double click to modify prof info");
        this.profTable.setPreferredScrollableViewportSize(new Dimension(300, 400));
        this.jScrollPane1.setViewportView(this.profTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.9;
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButton1.setText("Delete Selected Professor(s)");
        this.jButton1.setToolTipText("Remove Profs that are not needed in the schedule");
        this.jButton1.setMaximumSize(new Dimension(175, 26));
        this.jButton1.setMinimumSize(new Dimension(250, 26));
        this.jButton1.setPreferredSize(new Dimension(200, 26));
        this.jPanel3.add(this.jButton1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(17, 0, 17, 0);
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.9;
        gridBagConstraints.insets = new Insets(30, 17, 30, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(new CompoundBorder(new EtchedBorder(), new BevelBorder(0)));
        this.jLabel1.setText("First Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(17, 6, 0, 0);
        this.jPanel4.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Last Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel4.add((Component)this.jLabel2, gridBagConstraints);
        this.jTextField1.setToolTipText("Enter first name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.insets = new Insets(17, 6, 0, 18);
        this.jPanel4.add((Component)this.jTextField1, gridBagConstraints);
        this.jTextField2.setToolTipText("Enter Last Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new Insets(6, 6, 0, 18);
        this.jPanel4.add((Component)this.jTextField2, gridBagConstraints);
        this.jButton2.setText("Add Professor");
        this.jButton2.setToolTipText("Add this professor to the list");
        this.jPanel5.add(this.jButton2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 17, 0);
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("Full Time");
        this.jRadioButton1.setToolTipText("Full time / Part time professor");
        this.buttonGroup1.add(this.jRadioButton1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel6.add((Component)this.jRadioButton1, gridBagConstraints);
        this.jRadioButton2.setText("Adjunct");
        this.jRadioButton2.setToolTipText("Full time / Part time professor");
        this.buttonGroup1.add(this.jRadioButton2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel6.add((Component)this.jRadioButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets = new Insets(17, 0, 0, 0);
        this.jPanel4.add((Component)this.jPanel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 17, 0, 17);
        this.add((Component)this.jPanel4, gridBagConstraints);
    }

    private void addListeners() {
        ProfessorPanelListener professorPanelListener = new ProfessorPanelListener();
        this.jButton1.addActionListener(professorPanelListener);
        this.jButton2.addActionListener(professorPanelListener);
        this.cbStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("I hear the combobox");
                int row = ProfessorsPanel.this.profTable.getSelectedRow();
                System.out.println("on row " + row);
                if (row >= 0) {
                    String status = (String)((JComboBox)e.getSource()).getSelectedItem();
                    System.out.println("with status " + status);
                    Professor profModified = (Professor)ProfessorsPanel.this.schedule.getProfessors().get(row);
                    System.out.println("I got this prof" + profModified);
                    if (status.equals("Full Time")) {
                        profModified.setStatus(1);
                    } else {
                        profModified.setStatus(2);
                    }
                    System.out.println("It now looks like this " + profModified);
                    ProfessorsPanel.this.schedule.setChanged(true);
                }
            }
        });
        this.editFirst.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("I hear the textfield1");
                int row = ProfessorsPanel.this.profTable.getSelectedRow();
                System.out.println("on row " + row);
                int theRealIndex = ProfessorsPanel.this.sorter.map(row);
                System.out.println("The real row is row " + theRealIndex);
                if (theRealIndex >= 0) {
                    String first = ProfessorsPanel.this.editFirst.getText();
                    System.out.println("with first: " + first);
                    Professor profModified = (Professor)ProfessorsPanel.this.schedule.getProfessors().get(theRealIndex);
                    System.out.println("I got this prof" + profModified);
                    profModified.setFirstName(first);
                    System.out.println("It now looks like this " + profModified);
                    ProfessorsPanel.this.schedule.setChanged(true);
                }
            }
        });
        this.editLast.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = ProfessorsPanel.this.profTable.getSelectedRow();
                System.out.println("on row " + row);
                int theRealIndex = ProfessorsPanel.this.sorter.map(row);
                System.out.println("The real row is row " + theRealIndex);
                if (theRealIndex >= 0) {
                    String last = ProfessorsPanel.this.editLast.getText();
                    System.out.println("with last: " + last);
                    Professor profModified = (Professor)ProfessorsPanel.this.schedule.getProfessors().get(theRealIndex);
                    System.out.println("I got this prof" + profModified);
                    profModified.setLastName(last);
                    System.out.println("It now looks like this " + profModified);
                    ProfessorsPanel.this.schedule.setChanged(true);
                }
            }
        });
    }

    public void update(Observable observable, Object obj) {
        this.ptm.fireTableDataChanged();
    }

    class ProfessorTableModel
    extends AbstractTableModel {
        private Schedule schedule;
        final String[] columnNames = new String[]{"First Name", "Last Name", "Status"};

        public ProfessorTableModel() {
            this.schedule = Schedule.getSchedule();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.schedule.getProfessors().size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Class getColumnClass(int c) {
            return " ".getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public Object getValueAt(int row, int col) {
            Professor professor = (Professor)this.schedule.getProfessors().get(row);
            switch (col) {
                case 0: {
                    return professor.getFirstName();
                }
                case 1: {
                    return professor.getLastName();
                }
                case 2: {
                    int status = professor.getStatus();
                    if (status == 1) {
                        return "Full Time";
                    }
                    return "Adjunct";
                }
            }
            return "";
        }

        public void setValueAt(Object value, int row, int col) {
        }
    }

    class ProfessorPanelListener
    implements ActionListener {
        ProfessorPanelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("I hear |" + e.getActionCommand() + "|");
            if (e.getActionCommand().equals("Add Professor")) {
                String first = ProfessorsPanel.this.jTextField1.getText().trim();
                String last = ProfessorsPanel.this.jTextField2.getText().trim();
                if (first.equals("") || last.equals("")) {
                    return;
                }
                int status = ProfessorsPanel.this.jRadioButton1.isSelected() ? 1 : 2;
                Professor prof = new Professor(first, last, status);
                ProfessorsPanel.this.schedule.addProfessor(prof);
                ProfessorsPanel.this.jTextField1.setText("");
                ProfessorsPanel.this.jTextField2.setText("");
            } else if (e.getActionCommand().equals("Delete Selected Professor(s)")) {
                System.out.println("I'm deleting a prof over here");
                int[] selected = ProfessorsPanel.this.profTable.getSelectedRows();
                for (int i = selected.length - 1; i >= 0; --i) {
                    int realIndex = ProfessorsPanel.this.sorter.map(selected[i]);
                    ProfessorsPanel.this.schedule.removeProfessor((Professor)ProfessorsPanel.this.schedule.getProfessors().get(realIndex));
                }
            }
        }
    }
}

