/*
 * Decompiled with CFR 0.152.
 */
package resources;

import application.Schedule;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import resources.Constants;
import resources.SchedCourse;

public class Professor
implements Constants,
Comparable,
Serializable {
    static final long serialVersionUID = 911L;
    public static final int FULL_TIME = 1;
    public static final int ADJUNCT = 2;
    public static final int OTHER = 3;
    protected int status;
    protected String firstName;
    protected String lastName;

    public Professor(String firstName, String lastName, int status) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.status = status == 1 || status == 2 ? status : 3;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public int getStatus() {
        return this.status;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String toString() {
        if (this.lastName.trim().equals("STAFF")) {
            return this.lastName;
        }
        return this.lastName + ", " + this.firstName;
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof Professor)) {
            return 0;
        }
        if (!this.lastName.equals(((Professor)obj).lastName)) {
            return this.lastName.compareTo(((Professor)obj).lastName);
        }
        if (!this.firstName.equals(((Professor)obj).firstName)) {
            return this.firstName.compareTo(((Professor)obj).firstName);
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Professor)) {
            return false;
        }
        Professor professor2 = (Professor)obj;
        return this.compareTo(professor2) == 0 && this.status == professor2.status;
    }

    public void draw(Graphics g, Rectangle r) {
        Schedule schedule = Schedule.getSchedule();
        for (SchedCourse schedCourse : schedule.getSchedCourses()) {
            if (!this.equals(schedCourse.getProfessor())) continue;
            schedCourse.drawGraphical(g, 0, r);
        }
    }
}

