
/**
 *  Classroom Scheduler
 *  Copyright (C) 2004 Colin Archibald, Ph.D.
 *  https://sourceforge.net/projects/cr-scheduler/
 *
 *  Licensed under the Academic Free License version 2.0
 */

package panels;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.table.*;

import application.*;
import resources.*;

/**
 *
 * @author  Colin
 */
public class BookPanel extends javax.swing.JPanel implements Observer{
    
    /** Creates new form TestGridbag */
    public BookPanel() {
        initComponents();
        btm = new BookTableModel();
        TableSorter sorter = new TableSorter(btm);
         
        sorter.addMouseListenerToHeaderInTable(jTable1);        
        jTable1.setModel(sorter);
        addListeners();
        
        setColumnSizes();        
        
    }
    private void setColumnSizes(){
                // adjust the width of the columns
        TableColumn column = null;
        
        column = jTable1.getColumnModel().getColumn(0);
        column.setPreferredWidth(100);
        column = jTable1.getColumnModel().getColumn(1);
        column.setPreferredWidth(10);
        column = jTable1.getColumnModel().getColumn(2);
        column.setPreferredWidth(50);
        column = jTable1.getColumnModel().getColumn(3);
        column.setPreferredWidth(50);
        column = jTable1.getColumnModel().getColumn(4);
        column.setPreferredWidth(20);
        column = jTable1.getColumnModel().getColumn(5);
        column.setPreferredWidth(50);
                
        int avail = jTable1.getWidth();
        System.out.println("You've got " + avail + " available to work");
   /*     for (int i = 0; i < tableData[0].getFields().length; i++)  {
            column = scheduleTable.getColumnModel().getColumn(i);
            int width = (Math.max(tableData[0].getFields()[i].getLength(),
                                 tableData[0].getFields()[i].getName().length())
                                 + 2)
                                 * scheduleTable.getFont().getSize();
            column.setPreferredWidth(width);
        }
    */
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jPanel3 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jTextField1 = new javax.swing.JTextField();
        jTextField2 = new javax.swing.JTextField();
        jTextField3 = new javax.swing.JTextField();
        jTextField4 = new javax.swing.JTextField();
        jTextField5 = new javax.swing.JTextField();
        jTextField6 = new javax.swing.JTextField();
        jPanel4 = new javax.swing.JPanel();
        jButton2 = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane1.setViewportView(jTable1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 0.9;
        jPanel1.add(jScrollPane1, gridBagConstraints);

        jButton1.setText("Delete Selected Book(s)");
        jButton1.setMaximumSize(new java.awt.Dimension(175, 26));
        jButton1.setMinimumSize(new java.awt.Dimension(250, 26));
        jButton1.setPreferredSize(new java.awt.Dimension(175, 26));
        jPanel3.add(jButton1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(17, 0, 17, 0);
        jPanel1.add(jPanel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = -53;
        gridBagConstraints.ipady = -25;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(17, 17, 0, 0);
        add(jPanel1, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel2.setBorder(new javax.swing.border.CompoundBorder(new javax.swing.border.EtchedBorder(), new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED)));
        jLabel1.setText("Title:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(17, 6, 0, 0);
        jPanel2.add(jLabel1, gridBagConstraints);

        jLabel2.setText("Edition:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPanel2.add(jLabel2, gridBagConstraints);

        jLabel3.setText("Author:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPanel2.add(jLabel3, gridBagConstraints);

        jLabel4.setText("Publisher:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPanel2.add(jLabel4, gridBagConstraints);

        jLabel5.setText("Year:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPanel2.add(jLabel5, gridBagConstraints);

        jLabel6.setText("ISBN:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPanel2.add(jLabel6, gridBagConstraints);

        jTextField1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextField1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.insets = new java.awt.Insets(17, 6, 0, 18);
        jPanel2.add(jTextField1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 18);
        jPanel2.add(jTextField2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 18);
        jPanel2.add(jTextField3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 18);
        jPanel2.add(jTextField4, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 18);
        jPanel2.add(jTextField5, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 18);
        jPanel2.add(jTextField6, gridBagConstraints);

        jButton2.setText("Add Book");
        jPanel4.add(jButton2);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(17, 0, 17, 0);
        jPanel2.add(jPanel4, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(17, 17, 0, 17);
        add(jPanel2, gridBagConstraints);

    }//GEN-END:initComponents
    
    private void jTextField1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField1ActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_jTextField1ActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JTextField jTextField2;
    private javax.swing.JTextField jTextField3;
    private javax.swing.JTextField jTextField4;
    private javax.swing.JTextField jTextField5;
    private javax.swing.JTextField jTextField6;
    // End of variables declaration//GEN-END:variables
    
    private BooksPanelListener booksPanelListener; 
    private Schedule schedule = Schedule.getSchedule();
    private BookTableModel btm;
   
    private void addListeners() {
        booksPanelListener = new BooksPanelListener();
        jButton1.addActionListener(booksPanelListener);
        jButton2.addActionListener(booksPanelListener);
    }
    
    public void update(java.util.Observable observable, Object obj) {
        btm.fireTableDataChanged(); 
    }    
    
    /**
     * Inner class to handle the events
     */
    
    class BooksPanelListener implements ActionListener {

        public void actionPerformed(ActionEvent e) {
            System.out.println("I hear " + "|"+e.getActionCommand()+"|");
            if (e.getActionCommand().equals("Add Book")){

                // get the strings from the fields
                //firstField.getText().trim();
                String  title = jTextField1.getText().trim();
                String  edition = jTextField2.getText().trim();
                String  author = jTextField3.getText().trim();
                String  publisher = jTextField4.getText().trim();
                String  year = jTextField5.getText().trim();
                String  isbn = jTextField6.getText().trim();
                
                if (title.equals("") && author.equals(""))
                    // go back - do nothing not enough info
                    return;
                
                Textbook myBook = new Textbook(title, edition, author,
                    publisher, year, isbn);  // create the Textbook
                System.out.println(myBook);                    
                schedule.addBook(myBook); // add it to the schedule
                jTextField1.setText("");  // resert the fields to blank
                jTextField2.setText("");
                jTextField3.setText("");
                jTextField4.setText("");
                jTextField5.setText("");
                jTextField6.setText("");
            } else if (e.getActionCommand().equals("Modify Book")){
                System.out.println("I'm Modifying a book over here");
            } else if (e.getActionCommand().equals("Delete Selected Book(s)")){
                System.out.println("I'm deleting a book over here");
            }
        }      
    } // end inner class
    
    public class BookTableModel extends AbstractTableModel {
    private Schedule schedule; 
    
    final String[] columnNames = { "Title",
    "Ed.",
    "Author",
    "Publisher",
    "Year",
    "ISBN"
    };
    /** Creates a new instance of BookTableModel */
    public BookTableModel() {
        schedule = Schedule.getSchedule();
    }
    public int getColumnCount() {
        return columnNames.length;
    }
    public int getRowCount() {
        return schedule.getBooks().size();
    }
    public String getColumnName(int col) {
        return columnNames[col];
    }
    
    public Class getColumnClass(int c) {
        return " ".getClass();
    }
     public boolean isCellEditable(int row, int col) {
         return false;
     }
     public Object getValueAt(int row, int col) {
         Textbook book = (Textbook)schedule.getBooks().get(row);
         switch(col){
             case 0: return book.getTitle();
             case 1: return book.getEdition();
             case 2: return book.getAuthor();
             case 3: return book.getPublisher();
             case 4: return book.getYear();
             case 5: return book.getISBN();
         }
         return null; // should never do this
    }
    public void setValueAt(Object value, int row, int col) {
        fireTableCellUpdated(row, col);
    }
}




}
