/**
 *  Classroom Scheduler
 *  Copyright (C) 2004 Colin Archibald, Ph.D.
 *  https://sourceforge.net/projects/cr-scheduler/
 *
 *  Licensed under the Academic Free License version 2.0
 */

package panels;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.print.*;
import javax.swing.*;
import javax.swing.table.*;
import application.*;
import resources.*;
/**
 *
 * @author  Colin
 */
public class ModifySchedule extends javax.swing.JPanel implements Observer {
    
    /** Creates new form TestGridbag */
    public ModifySchedule(Component parent) {
        this.parent = parent;
        initComponents();
        // for table editing
        professorTableCB = new JComboBox();  // appears easier to add the elements here as a parameter to constuctor
        timeSlotTableCB = new JComboBox();
        classroomTableCB = new JComboBox();
        crnTableTF = new JTextField();
        myCE = new DialogCellEditor();

        stm = new ScheduleTableModel();
        sorter = new TableSorter(stm);
        sorter.addMouseListenerToHeaderInTable(jTable1);
        jTable1.setModel(sorter);
        addListeners();
        setColumnSizes();
        
        roomColumn.setCellEditor(new DefaultCellEditor(classroomTableCB));
        timeSlotColumn.setCellEditor(new DefaultCellEditor(timeSlotTableCB));
        professorColumn.setCellEditor(new DefaultCellEditor(professorTableCB));
        crnColumn.setCellEditor(new DefaultCellEditor(crnTableTF));
        noteColumn.setCellEditor(myCE);
    }
    private void setColumnSizes(){
        // adjust the width of the columns
        TableColumn column = null;
        
        column = jTable1.getColumnModel().getColumn(0);
        column.setPreferredWidth(110);
        column = jTable1.getColumnModel().getColumn(1); // CRN
        column.setMaxWidth(45);
        column = jTable1.getColumnModel().getColumn(2); // time slot
        column.setMaxWidth(65);
        column = jTable1.getColumnModel().getColumn(3); 
        column.setPreferredWidth(75);
        column = jTable1.getColumnModel().getColumn(4);
        column.setPreferredWidth(100);       
        column = jTable1.getColumnModel().getColumn(5); // conflict
        column.setMaxWidth(50);    
        column = jTable1.getColumnModel().getColumn(6); // note
        column.setMaxWidth(100);    
        
        courseColumn = jTable1.getColumnModel().getColumn(0);
        crnColumn = jTable1.getColumnModel().getColumn(1);
        roomColumn = jTable1.getColumnModel().getColumn(2);        
        timeSlotColumn = jTable1.getColumnModel().getColumn(3);
        professorColumn = jTable1.getColumnModel().getColumn(4);
        conflictColumn = jTable1.getColumnModel().getColumn(5);
        noteColumn = jTable1.getColumnModel().getColumn(6);
        
        // tried to center text in col using a cell renderer, but
        // the tcr object is null.  I think I need to set the renderer
        // which would require a new class.
        //TableCellRenderer tcr = crnColumn.getCellRenderer();
        //((JLabel)tcr).setHorizontalAlignment(Label.CENTER);
    }
    
    private void addListeners() {
        ModifyPanelListener modifyPanelListener = new ModifyPanelListener();
        addButton.addActionListener(modifyPanelListener);
        deleteButton.addActionListener(modifyPanelListener);
        // Need to remove these later
        //professorTableCB.addActionListener(modifyPanelListener);
        //timeSlotTableCB.addActionListener(modifyPanelListener);
        //classroomTableCB.addActionListener(modifyPanelListener);
        //crnTableTF.addActionListener(modifyPanelListener);  
        printButton.addActionListener(modifyPanelListener);
//        ((JButton) myCE.getTableCellEditorComponent()).addActionListener(modifyPanelListener);        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jPanel3 = new javax.swing.JPanel();
        deleteButton = new javax.swing.JButton();
        printButton = new javax.swing.JButton();
        sectionCounter = new javax.swing.JTextField();
        sectionCounterLabel = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        courseList = new javax.swing.JList();
        jPanel4 = new javax.swing.JPanel();
        addButton = new javax.swing.JButton();
        cbTimeSlot = new javax.swing.JComboBox();
        cbClassroom = new javax.swing.JComboBox();
        cbProfessor = new javax.swing.JComboBox();

        setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jScrollPane1.setToolTipText("Double click/drop down to edit.  Course and Conflict may not be edited");
        jScrollPane1.setPreferredSize(new java.awt.Dimension(400, 403));
        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jTable1.setToolTipText("Edit by drop down, or double click.  Course and Conflict cannot be edited");
        jTable1.setPreferredScrollableViewportSize(new java.awt.Dimension(300, 400));
        jScrollPane1.setViewportView(jTable1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.RELATIVE;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 0.9;
        jPanel1.add(jScrollPane1, gridBagConstraints);

        deleteButton.setToolTipText("Remove from schedule.  Return the removed sections to the list of sections available to be scheduled");
        deleteButton.setActionCommand("Delete Selected Course(s)");
        deleteButton.setLabel("Delete Selected Course(s)");
        deleteButton.setMaximumSize(new java.awt.Dimension(175, 26));
        deleteButton.setMinimumSize(new java.awt.Dimension(250, 26));
        deleteButton.setPreferredSize(new java.awt.Dimension(190, 26));
        deleteButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteButtonActionPerformed(evt);
            }
        });

        jPanel3.add(deleteButton);

        printButton.setText("Print Schedule");
        printButton.setToolTipText("Send schedule to printer");
        jPanel3.add(printButton);

        sectionCounter.setBackground(java.awt.Color.lightGray);
        sectionCounter.setText("             ");
        sectionCounter.setToolTipText("This many sections are in the schedule");
        sectionCounter.setFocusable(false);
        sectionCounter.setMargin(new java.awt.Insets(0, 5, 0, 5));
        sectionCounter.setMinimumSize(new java.awt.Dimension(35, 20));
        sectionCounter.setPreferredSize(new java.awt.Dimension(35, 20));
        sectionCounter.setRequestFocusEnabled(false);
        jPanel3.add(sectionCounter);

        sectionCounterLabel.setText("sections.");
        jPanel3.add(sectionCounterLabel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(17, 0, 0, 0);
        jPanel1.add(jPanel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(17, 17, 17, 0);
        add(jPanel1, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel2.setBorder(new javax.swing.border.CompoundBorder(new javax.swing.border.EtchedBorder(), new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED)));
        jPanel2.setPreferredSize(new java.awt.Dimension(178, 500));
        jLabel1.setText("Time Slot:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 11, 10, 11);
        jPanel2.add(jLabel1, gridBagConstraints);

        jLabel2.setText("Classroom:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(10, 11, 10, 11);
        jPanel2.add(jLabel2, gridBagConstraints);

        jLabel3.setText("Professor:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(10, 11, 10, 11);
        jPanel2.add(jLabel3, gridBagConstraints);

        courseList.setToolTipText("Course sections that may be scheduled");
        jScrollPane2.setViewportView(courseList);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.9;
        gridBagConstraints.insets = new java.awt.Insets(2, 5, 3, 5);
        jPanel2.add(jScrollPane2, gridBagConstraints);

        addButton.setText("Add Course(s)");
        addButton.setToolTipText("Add the course(es) to the schedule");
        jPanel4.add(addButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel2.add(jPanel4, gridBagConstraints);

        cbTimeSlot.setToolTipText("Select a time slot");
        cbTimeSlot.setAlignmentX(0.0F);
        cbTimeSlot.setAlignmentY(0.0F);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 30;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        jPanel2.add(cbTimeSlot, gridBagConstraints);

        cbClassroom.setToolTipText("Select a classroom");
        cbClassroom.setAlignmentX(0.0F);
        cbClassroom.setAlignmentY(0.0F);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 30;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        jPanel2.add(cbClassroom, gridBagConstraints);

        cbProfessor.setToolTipText("Select a professor");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 30;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        jPanel2.add(cbProfessor, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(17, 17, 17, 17);
        add(jPanel2, gridBagConstraints);

    }//GEN-END:initComponents

    private void deleteButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deleteButtonActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_deleteButtonActionPerformed
        
    public void update(java.util.Observable observable, Object obj) {
        stm.fireTableDataChanged();
                         
        // add the unscheduled courses to the list available to schedule
        ArrayList courses = schedule.getCourses();
        Vector unScheduledCourses = new Vector(20,10);
        
        for (int i = 0; i < courses.size(); i++)
            if (!((Course)courses.get(i)).getIsScheduled())
                unScheduledCourses.addElement(courses.get(i));
        
        courseList.setListData(unScheduledCourses);
        
        cbProfessor.removeAllItems();
        Iterator it = schedule.getProfessors().iterator();
        while(it.hasNext())
            cbProfessor.addItem(it.next());
        
        cbTimeSlot.removeAllItems();
        it = schedule.getTimeSlots().iterator();
        while(it.hasNext())
            cbTimeSlot.addItem(it.next());
        
        cbClassroom.removeAllItems();
        it = schedule.getClassrooms().iterator();
        while(it.hasNext())
            cbClassroom.addItem(it.next()); 
        
        // repeat for the table Combo boxes
        professorTableCB.removeAllItems();
        it = schedule.getProfessors().iterator();
        while(it.hasNext())
            professorTableCB.addItem(it.next());
        
        timeSlotTableCB.removeAllItems();
        it = schedule.getTimeSlots().iterator();
        while(it.hasNext())
            timeSlotTableCB.addItem(it.next());
        
        classroomTableCB.removeAllItems();
        it = schedule.getClassrooms().iterator();
        while(it.hasNext())
            classroomTableCB.addItem(it.next());
        
        sectionCounter.setText(String.valueOf(schedule.getSchedCourses().size()));
        
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addButton;
    private javax.swing.JComboBox cbClassroom;
    private javax.swing.JComboBox cbProfessor;
    private javax.swing.JComboBox cbTimeSlot;
    private javax.swing.JList courseList;
    private javax.swing.JButton deleteButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTable jTable1;
    private javax.swing.JButton printButton;
    private javax.swing.JTextField sectionCounter;
    private javax.swing.JLabel sectionCounterLabel;
    // End of variables declaration//GEN-END:variables
    

    private Schedule schedule = Schedule.getSchedule();
    private Component parent;
    
    private ScheduleTableModel stm;
    private TableSorter sorter;
    
    private TableColumn courseColumn;
    private TableColumn crnColumn;
    private TableColumn roomColumn;
    private TableColumn timeSlotColumn;
    private TableColumn professorColumn;
    private TableColumn conflictColumn;
    private TableColumn noteColumn;
    
    private JComboBox professorTableCB, timeSlotTableCB, classroomTableCB;
    private JTextField crnTableTF;
    private DialogCellEditor myCE;
    
    class ModifyPanelListener implements ActionListener {
        
        public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
            System.out.println("I hear this:\n" + actionEvent.getSource() + "\n");
            
            if(actionEvent.getSource() == printButton) {
                printTheView(schedule, true);
            }
            
            if (actionEvent.getSource() == addButton) {
                Object[] coursesToSchedule = courseList.getSelectedValues();
                
                if (coursesToSchedule.length == 0) {
                    JOptionPane.showMessageDialog(parent, "Select a course to be scheduled");
                    return;
                }
                Professor profToSchedule = (Professor) cbProfessor.getSelectedItem();
                
                if (profToSchedule == null) {
                    JOptionPane.showMessageDialog(parent, "Select a professor to be scheduled");
                    return;
                }
                TimeSlot timeSlotToSchedule = (TimeSlot) cbTimeSlot.getSelectedItem();
                
                if (timeSlotToSchedule == null) {
                    JOptionPane.showMessageDialog(parent, "Select a time slot to schedule");
                    return;
                }
                int selected = cbClassroom.getSelectedIndex();
                
                if (selected < 0) {
                    JOptionPane.showMessageDialog(parent, "Select a room to schedule");
                    return;
                }
                
                Classroom classroomToSchedule = (Classroom) schedule.getClassrooms().get(selected);
                
                for(int i = 0; i < coursesToSchedule.length; i++) {
                    SchedCourse theNewScheduledCourse = new SchedCourse(
                    profToSchedule,
                    classroomToSchedule,
                    (Course) coursesToSchedule[i],
                    timeSlotToSchedule);
                    schedule.addSchedCourse(theNewScheduledCourse);
                }
            } else if (actionEvent.getSource() == deleteButton) {
                // Determine which items to be deleted.
                int[] selected = jTable1.getSelectedRows();
                
                for (int i = selected.length - 1; i >= 0; i--) {
                    // Removes the items from the list                    
                    crnColumn.getCellEditor().cancelCellEditing();
                    roomColumn.getCellEditor().cancelCellEditing();
                    timeSlotColumn.getCellEditor().cancelCellEditing();
                    professorColumn.getCellEditor().cancelCellEditing();
                    noteColumn.getCellEditor().cancelCellEditing();
                    schedule.removeSchedCourse((SchedCourse) schedule.getSchedCourses().get(selected[i]));
                }
            }             
        }
    }
    
        // this is a helper for the actionListener
    
    private void printTheView(Pageable toPrint, boolean confirm) {
        System.out.println("I'm going to print a table");
        
        PrinterJob printJob = PrinterJob.getPrinterJob();  // Get a printing object
        printJob.setPageable(toPrint);    // The schedule is printable
        
        if (confirm) {
            if (printJob.printDialog())   // Display print dialog
            {                                        // If true is returned...
                try {
                    printJob.print();                // then print
                }
                catch(PrinterException pe) {
                    System.out.println(pe);
                    JOptionPane.showMessageDialog(ClassroomScheduler.getFrame(),
                    "Error printing a schedule.",
                    "Unknown Printer Error",
                    JOptionPane.ERROR_MESSAGE);
                }
            }
        } 
    }
}
