/**
 *  Classroom Scheduler
 *  Copyright (C) 2004 Colin Archibald, Ph.D.
 *  https://sourceforge.net/projects/cr-scheduler/
 *
 *  Licensed under the Academic Free License version 2.0
 */

package panels;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;

import application.*;
import resources.*;

public class ProfessorsPanel extends javax.swing.JPanel implements Observer {
    
    /** Creates new form ProfessorPanel */
    public ProfessorsPanel() {
        initComponents();
        
        ptm = new ProfessorTableModel();
        sorter = new TableSorter(ptm);
        sorter.addMouseListenerToHeaderInTable(profTable);
        profTable.setModel(sorter);
        addListeners();
        setColumnSizes();
        
    }

    private void setColumnSizes(){
        // adjust the width of the columns
        TableColumn column = null;
        
        column = profTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(100);
        column = profTable.getColumnModel().getColumn(1);
        column.setPreferredWidth(100);
        column = profTable.getColumnModel().getColumn(2);
        column.setPreferredWidth(50);
        
        
        firstColumn = profTable.getColumnModel().getColumn(0);
        lastColumn = profTable.getColumnModel().getColumn(1);
        statusColumn = profTable.getColumnModel().getColumn(2);
        
        firstColumn.setCellEditor(new DefaultCellEditor(editFirst));
        lastColumn.setCellEditor(new DefaultCellEditor(editLast));
        statusColumn.setCellEditor(new DefaultCellEditor(cbStatus));
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        jPanel2 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        profTable = new javax.swing.JTable();
        jPanel3 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jPanel4 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jTextField1 = new javax.swing.JTextField();
        jTextField2 = new javax.swing.JTextField();
        jPanel5 = new javax.swing.JPanel();
        jButton2 = new javax.swing.JButton();
        jPanel6 = new javax.swing.JPanel();
        jRadioButton1 = new javax.swing.JRadioButton();
        jRadioButton2 = new javax.swing.JRadioButton();

        setLayout(new java.awt.GridBagLayout());

        setAutoscrolls(true);
        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel2.setMaximumSize(new java.awt.Dimension(300, 2147483647));
        jPanel2.setMinimumSize(new java.awt.Dimension(260, 260));
        jPanel2.setPreferredSize(new java.awt.Dimension(250, 400));
        jScrollPane1.setToolTipText("Double click header to sort");
        jScrollPane1.setMaximumSize(new java.awt.Dimension(260, 32767));
        jScrollPane1.setMinimumSize(new java.awt.Dimension(250, 22));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(250, 153));
        profTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        profTable.setToolTipText("Double click to modify prof info");
        profTable.setPreferredScrollableViewportSize(new java.awt.Dimension(300, 400));
        jScrollPane1.setViewportView(profTable);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.weighty = 0.9;
        jPanel2.add(jScrollPane1, gridBagConstraints);

        jButton1.setText("Delete Selected Professor(s)");
        jButton1.setToolTipText("Remove Profs that are not needed in the schedule");
        jButton1.setMaximumSize(new java.awt.Dimension(175, 26));
        jButton1.setMinimumSize(new java.awt.Dimension(250, 26));
        jButton1.setPreferredSize(new java.awt.Dimension(200, 26));
        jPanel3.add(jButton1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(17, 0, 17, 0);
        jPanel2.add(jPanel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.weighty = 0.9;
        gridBagConstraints.insets = new java.awt.Insets(30, 17, 30, 0);
        add(jPanel2, gridBagConstraints);

        jPanel4.setLayout(new java.awt.GridBagLayout());

        jPanel4.setBorder(new javax.swing.border.CompoundBorder(new javax.swing.border.EtchedBorder(), new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED)));
        jLabel1.setText("First Name:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(17, 6, 0, 0);
        jPanel4.add(jLabel1, gridBagConstraints);

        jLabel2.setText("Last Name:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPanel4.add(jLabel2, gridBagConstraints);

        jTextField1.setToolTipText("Enter first name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.insets = new java.awt.Insets(17, 6, 0, 18);
        jPanel4.add(jTextField1, gridBagConstraints);

        jTextField2.setToolTipText("Enter Last Name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 18);
        jPanel4.add(jTextField2, gridBagConstraints);

        jButton2.setText("Add Professor");
        jButton2.setToolTipText("Add this professor to the list");
        jPanel5.add(jButton2);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(17, 0, 17, 0);
        jPanel4.add(jPanel5, gridBagConstraints);

        jPanel6.setLayout(new java.awt.GridBagLayout());

        jRadioButton1.setSelected(true);
        jRadioButton1.setText("Full Time");
        jRadioButton1.setToolTipText("Full time / Part time professor");
        buttonGroup1.add(jRadioButton1);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jRadioButton1, gridBagConstraints);

        jRadioButton2.setText("Adjunct");
        jRadioButton2.setToolTipText("Full time / Part time professor");
        buttonGroup1.add(jRadioButton2);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel6.add(jRadioButton2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets = new java.awt.Insets(17, 0, 0, 0);
        jPanel4.add(jPanel6, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 17, 0, 17);
        add(jPanel4, gridBagConstraints);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JRadioButton jRadioButton1;
    private javax.swing.JRadioButton jRadioButton2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JTextField jTextField2;
    private javax.swing.JTable profTable;
    // End of variables declaration//GEN-END:variables
    
    private ProfessorPanelListener professorPanelListener;
    private Schedule schedule = Schedule.getSchedule();
    private ProfessorTableModel ptm;
    private TableSorter sorter;
    private TableColumn firstColumn;
    private TableColumn lastColumn;
    private TableColumn statusColumn;
    private JTextField editFirst = new JTextField();
    private JTextField editLast = new JTextField();
    private JComboBox cbStatus = new JComboBox(new String[]{"Full Time","Adjunct"});
    
    private void addListeners() {
        ProfessorPanelListener professorPanelListener = new ProfessorPanelListener();
        jButton1.addActionListener(professorPanelListener);
        jButton2.addActionListener(professorPanelListener);
        
        // use an anonymous class
        cbStatus.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                System.out.println("I hear the combobox");
                int row = profTable.getSelectedRow();
                System.out.println("on row " + row);
                if (row >= 0) {
                    String status = (String)((JComboBox)e.getSource()).getSelectedItem();
                    System.out.println("with status " + status);
                    Professor profModified = (Professor)schedule.getProfessors().get(row);
                    System.out.println("I got this prof" +profModified);
                    if (status.equals("Full Time"))
                        profModified.setStatus(Professor.FULL_TIME);
                    else
                        profModified.setStatus(Professor.ADJUNCT);
                    System.out.println("It now looks like this " + profModified);
                    schedule.setChanged(true);
                }
            }
        });
        editFirst.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e) {
                System.out.println("I hear the textfield1");
                int row = profTable.getSelectedRow();
                System.out.println("on row " + row);
                int theRealIndex = sorter.map(row);
                System.out.println("The real row is row " + theRealIndex);
                if (theRealIndex >= 0) {
                    String first = editFirst.getText();
                    System.out.println("with first: " + first);
                    Professor profModified = (Professor)schedule.getProfessors().get(theRealIndex);
                    System.out.println("I got this prof" +profModified);
                    profModified.setFirstName(first);
                    System.out.println("It now looks like this " + profModified);
                    schedule.setChanged(true);
                }
            }
        });
        editLast.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e) {
                int row = profTable.getSelectedRow();
                System.out.println("on row " + row);
                int theRealIndex = sorter.map(row);
                System.out.println("The real row is row " + theRealIndex);
                if (theRealIndex >= 0) {
                    String last = editLast.getText();
                    System.out.println("with last: " + last);
                    Professor profModified = (Professor)schedule.getProfessors().get(theRealIndex);
                    System.out.println("I got this prof" +profModified);
                    profModified.setLastName(last);
                    System.out.println("It now looks like this " + profModified);
                    schedule.setChanged(true);
                }
            }
        });
    }
    
    public void update(java.util.Observable observable, Object obj) {
        ptm.fireTableDataChanged();
    }
    
    /**
     * Inner class to handle the events
     */
    
    class ProfessorPanelListener implements ActionListener {
        
        public void actionPerformed(ActionEvent e) {
            System.out.println("I hear " + "|"+e.getActionCommand()+"|");
            if (e.getActionCommand().equals("Add Professor")){
                String  first = jTextField1.getText().trim();
                String  last = jTextField2.getText().trim();
                
                if (first.equals("") || last.equals(""))
                    return; // go back - do nothing not enough info
                int status;
                if (jRadioButton1.isSelected()) {
                    status = Professor.FULL_TIME;
                } else {
                    status = Professor.ADJUNCT;
                }
                
                Professor prof = new Professor(first,last,status);
                schedule.addProfessor(prof); // add it to the schedule
                jTextField1.setText("");  // resert the fields to blank
                jTextField2.setText("");
                
            } else if (e.getActionCommand().equals("Delete Selected Professor(s)")){
                System.out.println("I'm deleting a prof over here");
                // Determine which items to be deleted
                int[] selected = profTable.getSelectedRows();
                
                for (int i = selected.length - 1 ; i >= 0 ; i--) {
                    int realIndex = sorter.map(selected[i]);
                    // Removes the items from the list
                    schedule.removeProfessor((Professor)
                    schedule.getProfessors().get(realIndex));
                }
            }
        }
    } // end inner class
    
    
    class ProfessorTableModel extends AbstractTableModel {
        private Schedule schedule;

        final String[] columnNames = {
            "First Name",
            "Last Name",
            "Status",
        };
        /** Creates a new instance of BookTableModel */
        public ProfessorTableModel() {
            schedule = Schedule.getSchedule();
        }
        public int getColumnCount() {
            return columnNames.length;
        }
        public int getRowCount() {
            return schedule.getProfessors().size();
        }
        public String getColumnName(int col) {
            return columnNames[col];
        }

        public Class getColumnClass(int c) {
            return " ".getClass();
        }
        public boolean isCellEditable(int row, int col) {
            return true;
        }
        public Object getValueAt(int row, int col) {
            Professor professor = (Professor)schedule.getProfessors().get(row);
            switch(col){
                case 0: return professor.getFirstName();
                case 1: return professor.getLastName();
                case 2:
                    int status = professor.getStatus();
                    if (status == Professor.FULL_TIME)
                        return "Full Time";
                    else
                        return "Adjunct";

            }
            return ""; // should never do this
        }
        public void setValueAt(Object value, int row, int col) {
            //fireTableCellUpdated(row, col);
        }
    }
    
}
