/**
 *  Classroom Scheduler
 *  Copyright (C) 2004 Colin Archibald, Ph.D.
 *  https://sourceforge.net/projects/cr-scheduler/
 *
 *  Licensed under the Academic Free License version 2.0
 */

package panels;
import java.awt.*;
import java.util.*;
import javax.swing.*;
import application.*;
/**
 *
 * @author  Colin
 */
public class ScheduleConflicts extends javax.swing.JPanel implements Observer {
    
    /** Creates new form ScheduleSummary */
    public ScheduleConflicts() {
        initComponents();
        calcAndDisplaySummary();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        conflictsArea = new javax.swing.JTextArea();
        jPanel2 = new javax.swing.JPanel();
        printButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jScrollPane1.setViewportView(conflictsArea);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jScrollPane1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(18, 12, 6, 12);
        add(jPanel1, gridBagConstraints);

        printButton.setText("Print Conflicts");
        jPanel2.add(printButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 12, 12);
        add(jPanel2, gridBagConstraints);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea conflictsArea;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton printButton;
    // End of variables declaration//GEN-END:variables
    
    private void calcAndDisplaySummary(){
        
        conflictsArea.setText("There are no conflicts available.");
    }
    
    public void update(Observable o, Object arg) {
        Schedule.getSchedule().findConflicts();
        displayConflicts();
    }
        private void displayConflicts() {
        
        ArrayList conflicts = Schedule.getSchedule().getConflicts();
        
        if (conflicts == null || conflicts.size() == 0)
            conflictsArea.setText("No conflicts in current schedule.");
        else {
            conflictsArea.setText("");
            
            Iterator it = conflicts.iterator();
            while (it.hasNext())
                conflictsArea.append(it.next().toString());
        }
    }
    
}
