/*
 * ProfessorSummary.java
 *
 * Created on February 14, 2004, 12:31 PM
 */

package resources;

import application.*;
import java.util.*;
import java.io.*;

/**
 *
 * @author  Kyle Murphy
 */
public class ProfessorSummary implements Serializable {
    static final long serialVersionUID = 911;
    public static final String TOTAL = "Total";
    public static final String TOTAL_FULL = "Total Full Time";
    public static final String TOTAL_ADJUNCT = "Total Adjunct";
    public static final int NAME_COL = 24;
    public static final int SECTION_COL = 35;
    public static final int CREDIT_HOURS_COL = 45;
    
    /*
     * Stuff that needs to be tracked:
     *      Total Credit Hours
     *      Total Sections
     *      Link to Professor
     */
    
    private int totalCreditHours = 0;
    private int totalSections = 0;
    private Professor professor;
    
    /** Creates a new instance of ProfessorSummary */
    public ProfessorSummary(Professor professor) {
        this.setProfessor(professor);
        this.calculateCreditHours();
    }        
    
    public void setProfessor(Professor professor) {
        if(professor != null) {
            this.professor = professor;
        }    
    }
    
    public Professor getProfessor() {
        return this.professor;
    }
    
    public void setSections(int sections) {
        if(sections >= 0) {
            this.totalSections = sections;
        }    
    }
    
    public int getSections() {
        return this.totalSections;
    }
    
    public void incrementSections(int increment) {
        if(increment > 0) {
            this.setSections(this.getSections() + increment);
        }    
    }
    
    public void setCreditHours(int creditHours) {
        if(creditHours >= 0) {
            this.totalCreditHours = creditHours;
        }    
    }
    
    public int getCreditHours() {
        return this.totalCreditHours;
    }
    
    public void incrementCreditHours(int increment) {
        if(increment > 0) {
            this.setCreditHours(this.getCreditHours() + increment);
        }
    }
    
    public void calculateCreditHours() {
        Schedule schedule = Schedule.getSchedule();
        ArrayList schedCourses = schedule.getSchedCourses();
        
        Iterator i = schedCourses.iterator();
        while(i.hasNext()) {
            SchedCourse schedCourse = (SchedCourse) i.next();
            if(schedCourse.getProfessor().equals(this.getProfessor())) {
                this.incrementSections(1);
                this.incrementCreditHours(schedCourse.getCourse().getCreditHours());
            }
        }
    }
    
    public String toString() {
        String string = this.getProfessor().getFirstName() + " ";
        string += this.getProfessor().getLastName();
        string +=  space(string.length(), NAME_COL);
        string +=  this.getSections();
        string +=  space(string.length(), SECTION_COL);
        string +=  this.getCreditHours();
        string +=  space(string.length(), CREDIT_HOURS_COL);
            
        return string;
    }
    
    /**
     * @returns enough space to use up total, starting with used
     */
    private static String space(int used, int total){
       String result = "";
       if (used >= total)
           return result;
       for(int i = used; i < total; i++){
           result += " ";
       }
       return result;
    }
}
