/*
 * Decompiled with CFR 0.152.
 */
package freemind.main;

import freemind.common.NamedObject;
import freemind.common.TextTranslator;
import freemind.main.FreeMindMain;
import freemind.main.Tools;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import tests.freemind.FreeMindMainMock;

public class Resources
implements TextTranslator {
    private FreeMindMain main;
    static Resources resourcesInstance = null;
    private HashMap countryMap;
    private Logger logger = null;

    private Resources(FreeMindMain frame) {
        this.main = frame;
        if (this.logger == null) {
            this.logger = this.main.getLogger(this.getClass().getName());
        }
    }

    public static void createInstance(FreeMindMain frame) {
        if (resourcesInstance == null) {
            resourcesInstance = new Resources(frame);
        }
    }

    public URL getResource(String resource) {
        return this.main.getResource(resource);
    }

    public String getResourceString(String resource) {
        return this.main.getResourceString(resource);
    }

    public String getResourceString(String key, String resource) {
        return this.main.getResourceString(key, resource);
    }

    public static Resources getInstance() {
        if (resourcesInstance == null) {
            Resources.createInstance((FreeMindMain)new FreeMindMainMock());
            System.err.println("Resources without FreeMind called.");
        }
        return resourcesInstance;
    }

    public String getFreemindDirectory() {
        return this.main.getFreemindDirectory();
    }

    public FreeMindMain.VersionInformation getFreemindVersion() {
        return this.main.getFreemindVersion();
    }

    public int getIntProperty(String key, int defaultValue) {
        return this.main.getIntProperty(key, defaultValue);
    }

    public long getLongProperty(String key, long defaultValue) {
        try {
            return Long.parseLong(this.getProperty(key));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public boolean getBoolProperty(String key) {
        String boolProperty = this.getProperty(key);
        return Tools.safeEquals("true", boolProperty);
    }

    public Properties getProperties() {
        return this.main.getProperties();
    }

    public String getProperty(String key) {
        return this.main.getProperty(key);
    }

    public ResourceBundle getResources() {
        return this.main.getResources();
    }

    public HashMap getCountryMap() {
        if (this.countryMap == null) {
            String[] countryMapArray = new String[]{"de", "DE", "en", "UK", "en", "US", "es", "ES", "es", "MX", "fi", "FI", "fr", "FR", "hu", "HU", "it", "CH", "it", "IT", "nl", "NL", "no", "NO", "pt", "PT", "ru", "RU", "sl", "SI", "uk", "UA", "zh", "CN"};
            this.countryMap = new HashMap();
            for (int i = 0; i < countryMapArray.length; i += 2) {
                this.countryMap.put(countryMapArray[i], countryMapArray[i + 1]);
            }
        }
        return this.countryMap;
    }

    public Logger getLogger(String forClass) {
        return this.main.getLogger(forClass);
    }

    public void logException(Throwable e) {
        this.logException(e, "");
    }

    public void logException(Throwable e, String comment) {
        this.logger.log(Level.SEVERE, "An exception occured: " + comment, e);
    }

    public String format(String resourceKey, Object[] messageArguments) {
        MessageFormat formatter = new MessageFormat(this.getResourceString(resourceKey));
        String stringResult = formatter.format(messageArguments);
        return stringResult;
    }

    public NamedObject createTranslatedString(String key) {
        String fs = this.getResourceString(key);
        return new NamedObject(key, fs);
    }

    @Override
    public String getText(String pKey) {
        return this.getResourceString(pKey);
    }
}

