/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.JMapViewerTree;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.LayerGroup;
import org.openstreetmap.gui.jmapviewer.MapMarkerCircle;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.MapPolygonImpl;
import org.openstreetmap.gui.jmapviewer.MapRectangleImpl;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.events.JMVCommandEvent;
import org.openstreetmap.gui.jmapviewer.interfaces.JMapViewerEventListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.BingAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.MapQuestOpenAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.MapQuestOsmTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;

public class Demo
extends JFrame
implements JMapViewerEventListener {
    private static final long serialVersionUID = 1L;
    private final JMapViewerTree treeMap;
    private final JLabel zoomLabel;
    private final JLabel zoomValue;
    private final JLabel mperpLabelName;
    private final JLabel mperpLabelValue;

    public Demo() {
        super("JMapViewer Demo");
        this.setSize(400, 400);
        this.treeMap = new JMapViewerTree("Zones");
        this.map().addJMVListener(this);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(3);
        this.setExtendedState(6);
        JPanel panel = new JPanel();
        JPanel panelTop = new JPanel();
        JPanel panelBottom = new JPanel();
        JPanel helpPanel = new JPanel();
        this.mperpLabelName = new JLabel("Meters/Pixels: ");
        this.mperpLabelValue = new JLabel(String.format("%s", this.map().getMeterPerPixel()));
        this.zoomLabel = new JLabel("Zoom: ");
        this.zoomValue = new JLabel(String.format("%s", this.map().getZoom()));
        this.add((Component)panel, "North");
        this.add((Component)helpPanel, "South");
        panel.setLayout(new BorderLayout());
        panel.add((Component)panelTop, "North");
        panel.add((Component)panelBottom, "South");
        JLabel helpLabel = new JLabel("Use right mouse button to move,\n left double click or mouse wheel to zoom.");
        helpPanel.add(helpLabel);
        JButton button = new JButton("setDisplayToFitMapMarkers");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Demo.this.map().setDisplayToFitMapMarkers();
            }
        });
        JComboBox<TileSource> tileSourceSelector = new JComboBox<TileSource>(new TileSource[]{new OsmTileSource.Mapnik(), new OsmTileSource.CycleMap(), new BingAerialTileSource(), new MapQuestOsmTileSource(), new MapQuestOpenAerialTileSource()});
        tileSourceSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Demo.this.map().setTileSource((TileSource)e.getItem());
            }
        });
        JComboBox<TileLoader> tileLoaderSelector = new JComboBox<TileLoader>(new TileLoader[]{new OsmTileLoader(this.map())});
        tileLoaderSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Demo.this.map().setTileLoader((TileLoader)e.getItem());
            }
        });
        this.map().setTileLoader((TileLoader)tileLoaderSelector.getSelectedItem());
        panelTop.add(tileSourceSelector);
        panelTop.add(tileLoaderSelector);
        final JCheckBox showMapMarker = new JCheckBox("Map markers visible");
        showMapMarker.setSelected(this.map().getMapMarkersVisible());
        showMapMarker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Demo.this.map().setMapMarkerVisible(showMapMarker.isSelected());
            }
        });
        panelBottom.add(showMapMarker);
        final JCheckBox showTreeLayers = new JCheckBox("Tree Layers visible");
        showTreeLayers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Demo.this.treeMap.setTreeVisible(showTreeLayers.isSelected());
            }
        });
        panelBottom.add(showTreeLayers);
        final JCheckBox showToolTip = new JCheckBox("ToolTip visible");
        showToolTip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Demo.this.map().setToolTipText(null);
            }
        });
        panelBottom.add(showToolTip);
        final JCheckBox showTileGrid = new JCheckBox("Tile grid visible");
        showTileGrid.setSelected(this.map().isTileGridVisible());
        showTileGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Demo.this.map().setTileGridVisible(showTileGrid.isSelected());
            }
        });
        panelBottom.add(showTileGrid);
        final JCheckBox showZoomControls = new JCheckBox("Show zoom controls");
        showZoomControls.setSelected(this.map().getZoomControlsVisible());
        showZoomControls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Demo.this.map().setZoomContolsVisible(showZoomControls.isSelected());
            }
        });
        panelBottom.add(showZoomControls);
        final JCheckBox scrollWrapEnabled = new JCheckBox("Scrollwrap enabled");
        scrollWrapEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Demo.this.map().setScrollWrapEnabled(scrollWrapEnabled.isSelected());
            }
        });
        panelBottom.add(scrollWrapEnabled);
        panelBottom.add(button);
        panelTop.add(this.zoomLabel);
        panelTop.add(this.zoomValue);
        panelTop.add(this.mperpLabelName);
        panelTop.add(this.mperpLabelValue);
        this.add((Component)this.treeMap, "Center");
        LayerGroup germanyGroup = new LayerGroup("Germany");
        Layer germanyWestLayer = germanyGroup.addLayer("Germany West");
        Layer germanyEastLayer = germanyGroup.addLayer("Germany East");
        MapMarkerDot eberstadt = new MapMarkerDot(germanyEastLayer, "Eberstadt", 49.814284999, 8.642065999);
        MapMarkerDot ebersheim = new MapMarkerDot(germanyWestLayer, "Ebersheim", 49.91, 8.24);
        MapMarkerDot empty = new MapMarkerDot(germanyEastLayer, 49.71, 8.64);
        MapMarkerDot darmstadt = new MapMarkerDot(germanyEastLayer, "Darmstadt", 49.8588, 8.643);
        this.map().addMapMarker(eberstadt);
        this.map().addMapMarker(ebersheim);
        this.map().addMapMarker(empty);
        Layer franceLayer = this.treeMap.addLayer("France");
        this.map().addMapMarker(new MapMarkerDot(franceLayer, "La Gallerie", 48.71, -1.0));
        this.map().addMapMarker(new MapMarkerDot(43.604, 1.444));
        this.map().addMapMarker(new MapMarkerCircle(53.343, -6.267, 0.666));
        this.map().addMapRectangle(new MapRectangleImpl(new Coordinate(53.343, -6.267), new Coordinate(43.604, 1.444)));
        this.map().addMapMarker(darmstadt);
        this.treeMap.addLayer(germanyWestLayer);
        this.treeMap.addLayer(germanyEastLayer);
        MapPolygonImpl bermudas = new MapPolygonImpl(Demo.c(49.0, 1.0), Demo.c(45.0, 10.0), Demo.c(40.0, 5.0));
        this.map().addMapPolygon(bermudas);
        this.map().addMapPolygon(new MapPolygonImpl(germanyEastLayer, "Riedstadt", ebersheim, darmstadt, eberstadt, empty));
        this.map().addMapMarker(new MapMarkerCircle(germanyWestLayer, "North of Suisse", new Coordinate(48.0, 7.0), 0.5));
        Layer spain = this.treeMap.addLayer("Spain");
        this.map().addMapMarker(new MapMarkerCircle(spain, "La Garena", new Coordinate(40.4838, -3.39), 0.002));
        spain.setVisible(Boolean.FALSE);
        Layer wales = this.treeMap.addLayer("UK");
        this.map().addMapRectangle(new MapRectangleImpl(wales, "Wales", Demo.c(53.35, -4.57), Demo.c(51.64, -2.63)));
        this.map().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    Demo.this.map().getAttribution().handleAttribution(e.getPoint(), true);
                }
            }
        });
        this.map().addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point p = e.getPoint();
                boolean cursorHand = Demo.this.map().getAttribution().handleAttributionCursor(p);
                if (cursorHand) {
                    Demo.this.map().setCursor(new Cursor(12));
                } else {
                    Demo.this.map().setCursor(new Cursor(0));
                }
                if (showToolTip.isSelected()) {
                    Demo.this.map().setToolTipText(Demo.this.map().getPosition(p).toString());
                }
            }
        });
    }

    private JMapViewer map() {
        return this.treeMap.getViewer();
    }

    private static Coordinate c(double lat, double lon) {
        return new Coordinate(lat, lon);
    }

    public static void main(String[] args) {
        new Demo().setVisible(true);
    }

    private void updateZoomParameters() {
        if (this.mperpLabelValue != null) {
            this.mperpLabelValue.setText(String.format("%s", this.map().getMeterPerPixel()));
        }
        if (this.zoomValue != null) {
            this.zoomValue.setText(String.format("%s", this.map().getZoom()));
        }
    }

    @Override
    public void processCommand(JMVCommandEvent command) {
        if (command.getCommand().equals((Object)JMVCommandEvent.COMMAND.ZOOM) || command.getCommand().equals((Object)JMVCommandEvent.COMMAND.MOVE)) {
            this.updateZoomParameters();
        }
    }
}

