/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.imageio.ImageIO;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

public class Tile {
    public static final BufferedImage LOADING_IMAGE = Tile.loadImage("images/hourglass.png");
    public static final BufferedImage ERROR_IMAGE = Tile.loadImage("images/error.png");
    protected TileSource source;
    protected int xtile;
    protected int ytile;
    protected int zoom;
    protected BufferedImage image;
    protected String key;
    protected volatile boolean loaded;
    protected volatile boolean loading;
    protected volatile boolean error;
    protected String error_message;
    protected Map<String, String> metadata;

    public Tile(TileSource source, int xtile, int ytile, int zoom) {
        this(source, xtile, ytile, zoom, LOADING_IMAGE);
    }

    public Tile(TileSource source, int xtile, int ytile, int zoom, BufferedImage image) {
        this.source = source;
        this.xtile = xtile;
        this.ytile = ytile;
        this.zoom = zoom;
        this.image = image;
        this.key = Tile.getTileKey(source, xtile, ytile, zoom);
    }

    private static BufferedImage loadImage(String path) {
        try {
            return ImageIO.read(JMapViewer.class.getResourceAsStream(path));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void loadPlaceholderFromCache(TileCache cache) {
        final CachedCallable<BufferedImage> tmpImage = new CachedCallable<BufferedImage>(new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                return new BufferedImage(Tile.this.source.getTileSize(), Tile.this.source.getTileSize(), 1);
            }
        });
        for (int zoomDiff = 1; zoomDiff < 5; ++zoomDiff) {
            int zoomLow;
            int zoomHigh = this.zoom + zoomDiff;
            if (zoomDiff < 3 && zoomHigh <= 22) {
                int factor = 1 << zoomDiff;
                int xtileHigh = this.xtile << zoomDiff;
                int ytileHigh = this.ytile << zoomDiff;
                final double scale = 1.0 / (double)factor;
                CachedCallable<Graphics2D> graphics = new CachedCallable<Graphics2D>(new Callable<Graphics2D>(){

                    @Override
                    public Graphics2D call() throws Exception {
                        Graphics2D g = (Graphics2D)((BufferedImage)tmpImage.call()).getGraphics();
                        g.setTransform(AffineTransform.getScaleInstance(scale, scale));
                        return g;
                    }
                });
                int paintedTileCount = 0;
                for (int x = 0; x < factor; ++x) {
                    for (int y = 0; y < factor; ++y) {
                        Tile tile = cache.getTile(this.source, xtileHigh + x, ytileHigh + y, zoomHigh);
                        if (tile == null || !tile.isLoaded()) continue;
                        ++paintedTileCount;
                        tile.paint(graphics.call(), x * this.source.getTileSize(), y * this.source.getTileSize());
                    }
                }
                if (paintedTileCount == factor * factor) {
                    this.image = tmpImage.call();
                    return;
                }
            }
            if ((zoomLow = this.zoom - zoomDiff) < 0) continue;
            int xtileLow = this.xtile >> zoomDiff;
            int ytileLow = this.ytile >> zoomDiff;
            final int factor = 1 << zoomDiff;
            final double scale = factor;
            CachedCallable<Graphics2D> graphics = new CachedCallable<Graphics2D>(new Callable<Graphics2D>(){

                @Override
                public Graphics2D call() throws Exception {
                    Graphics2D g = (Graphics2D)((BufferedImage)tmpImage.call()).getGraphics();
                    AffineTransform at = new AffineTransform();
                    int translateX = Tile.this.xtile % factor * Tile.this.source.getTileSize();
                    int translateY = Tile.this.ytile % factor * Tile.this.source.getTileSize();
                    at.setTransform(scale, 0.0, 0.0, scale, -translateX, -translateY);
                    g.setTransform(at);
                    return g;
                }
            });
            Tile tile = cache.getTile(this.source, xtileLow, ytileLow, zoomLow);
            if (tile == null || !tile.isLoaded()) continue;
            tile.paint(graphics.call(), 0, 0);
            this.image = tmpImage.call();
            return;
        }
    }

    public TileSource getSource() {
        return this.source;
    }

    public int getXtile() {
        return this.xtile;
    }

    public int getYtile() {
        return this.ytile;
    }

    public int getZoom() {
        return this.zoom;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public void loadImage(InputStream input) throws IOException {
        this.image = ImageIO.read(input);
    }

    public String getKey() {
        return this.key;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public String getUrl() throws IOException {
        return this.source.getTileUrl(this.zoom, this.xtile, this.ytile);
    }

    public void paint(Graphics g, int x, int y) {
        if (this.image == null) {
            return;
        }
        g.drawImage(this.image, x, y, null);
    }

    public void paint(Graphics g, int x, int y, int width, int height) {
        if (this.image == null) {
            return;
        }
        g.drawImage(this.image, x, y, width, height, null);
    }

    public String toString() {
        return "Tile " + this.key;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.xtile;
        result = 31 * result + this.ytile;
        result = 31 * result + this.zoom;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tile other = (Tile)obj;
        if (this.xtile != other.xtile) {
            return false;
        }
        if (this.ytile != other.ytile) {
            return false;
        }
        if (this.zoom != other.zoom) {
            return false;
        }
        return this.getTileSource().equals(other.getTileSource());
    }

    public static String getTileKey(TileSource source, int xtile, int ytile, int zoom) {
        return zoom + "/" + xtile + "/" + ytile + "@" + source.getName();
    }

    public String getStatus() {
        if (this.error) {
            return "error";
        }
        if (this.loaded) {
            return "loaded";
        }
        if (this.loading) {
            return "loading";
        }
        return "new";
    }

    public boolean hasError() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.error_message;
    }

    public void setError(String message) {
        this.error = true;
        this.setImage(ERROR_IMAGE);
        this.error_message = message;
    }

    public void putValue(String key, String value) {
        if (value == null || value.isEmpty()) {
            if (this.metadata != null) {
                this.metadata.remove(key);
            }
            return;
        }
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, value);
    }

    public String getValue(String key) {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.get(key);
    }

    public Map<String, String> getMetadata() {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        return this.metadata;
    }

    public void initLoading() {
        this.error = false;
        this.loading = true;
    }

    public void finishLoading() {
        this.loading = false;
        this.loaded = true;
    }

    public TileSource getTileSource() {
        return this.source;
    }

    public void loadingCanceled() {
        this.loading = false;
        this.loaded = false;
    }

    private static class CachedCallable<V>
    implements Callable<V> {
        private V result;
        private Callable<V> callable;

        CachedCallable(Callable<V> callable) {
            this.callable = callable;
        }

        @Override
        public synchronized V call() {
            try {
                if (this.result == null) {
                    this.result = this.callable.call();
                }
                return this.result;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

