/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import jsyntaxpane.SyntaxStyle;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;
import jsyntaxpane.util.Configuration;
import jsyntaxpane.util.JarServiceProvider;

public class SyntaxStyles {
    public static final Pattern STYLE_PATTERN = Pattern.compile("Style\\.(\\w+)");
    Map<TokenType, SyntaxStyle> styles;
    private static SyntaxStyles instance = SyntaxStyles.createInstance();
    private static final Logger LOG = Logger.getLogger(SyntaxStyles.class.getName());
    private static SyntaxStyle DEFAULT_STYLE = new SyntaxStyle(Color.BLACK, 0);

    public void mergeStyles(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string = entry.getKey().toString();
            String string2 = entry.getValue().toString();
            try {
                TokenType tokenType = TokenType.valueOf(string);
                SyntaxStyle syntaxStyle = new SyntaxStyle(string2);
                this.put(tokenType, syntaxStyle);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.warning("illegal token type or style for: " + string);
            }
        }
    }

    private SyntaxStyles() {
    }

    private static SyntaxStyles createInstance() {
        SyntaxStyles syntaxStyles = new SyntaxStyles();
        Properties properties = JarServiceProvider.readProperties(SyntaxStyles.class);
        syntaxStyles.mergeStyles(properties);
        return syntaxStyles;
    }

    public static SyntaxStyles getInstance() {
        return instance;
    }

    public static SyntaxStyles read(Configuration configuration) {
        SyntaxStyles syntaxStyles = SyntaxStyles.createInstance();
        for (Configuration.StringKeyMatcher stringKeyMatcher : configuration.getKeys(STYLE_PATTERN)) {
            String string = stringKeyMatcher.group1;
            try {
                syntaxStyles.put(TokenType.valueOf(string), new SyntaxStyle(stringKeyMatcher.value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger.getLogger(SyntaxStyles.class.getName()).warning(String.format("Invalid Token Type [%s] for Style of ", string));
            }
        }
        return syntaxStyles;
    }

    public void put(TokenType tokenType, SyntaxStyle syntaxStyle) {
        if (this.styles == null) {
            this.styles = new HashMap<TokenType, SyntaxStyle>();
        }
        this.styles.put(tokenType, syntaxStyle);
    }

    public SyntaxStyle getStyle(TokenType tokenType) {
        if (this.styles != null && this.styles.containsKey((Object)tokenType)) {
            return this.styles.get((Object)tokenType);
        }
        return DEFAULT_STYLE;
    }

    public int drawText(Segment segment, int n, int n2, Graphics graphics, TabExpander tabExpander, Token token) {
        SyntaxStyle syntaxStyle = this.getStyle(token.type);
        return syntaxStyle.drawText(segment, n, n2, graphics, tabExpander, token.start);
    }
}

