/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.actions.DefaultSyntaxAction;
import jsyntaxpane.actions.gui.ComboCompletionDialog;
import jsyntaxpane.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteWordAction
extends DefaultSyntaxAction {
    private ComboCompletionDialog dlg;
    private Pattern wordsPattern = DEFAULT_WORDS_REGEXP;
    private static final Pattern DEFAULT_WORDS_REGEXP = Pattern.compile("\\w+");

    public CompleteWordAction() {
        super("COMPLETE_WORD");
    }

    @Override
    public void actionPerformed(JTextComponent jTextComponent, SyntaxDocument syntaxDocument, int n, ActionEvent actionEvent) {
        Token token = syntaxDocument.getWordAt(n, this.wordsPattern);
        if (token == null) {
            return;
        }
        String string = token.getString(syntaxDocument);
        jTextComponent.select(token.start, token.end());
        syntaxDocument.readLock();
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = syntaxDocument.getMatcher(this.wordsPattern, 0, token.start);
        this.addWords(matcher, string, arrayList);
        matcher = syntaxDocument.getMatcher(this.wordsPattern, token.end(), syntaxDocument.getLength() - token.end());
        this.addWords(matcher, string, arrayList);
        syntaxDocument.readUnlock();
        if (arrayList.size() == 0) {
            return;
        }
        if (arrayList.size() == 1) {
            jTextComponent.replaceSelection((String)arrayList.get(0));
            return;
        }
        if (this.dlg == null) {
            this.dlg = new ComboCompletionDialog(jTextComponent);
        }
        this.dlg.displayFor(string, arrayList);
    }

    public void setWordsRegexp(String string) {
        this.wordsPattern = Pattern.compile(string);
    }

    private void addWords(Matcher matcher, String string, List<String> list) {
        while (matcher != null && matcher.find()) {
            String string2 = matcher.group();
            if (!StringUtils.camelCaseMatch(string2, string) || list.contains(string2)) continue;
            list.add(string2);
        }
    }
}

