/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.mindmapmode;

import java.awt.EventQueue;
import java.io.File;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.core.undo.UndoHandler;
import org.freeplane.core.util.SysUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.DoAutomaticSave;
import org.freeplane.features.url.mindmapmode.DummyLockManager;
import org.freeplane.features.url.mindmapmode.LockManager;
import org.freeplane.features.url.mindmapmode.MFileManager;

public class MMapModel
extends MapModel {
    private static int unnamedMapsNumber = 1;
    private LockManager lockManager;
    private Timer timerForAutomaticSaving;
    private int titleNumber = 0;

    public MMapModel() {
        this.addExtension(IUndoHandler.class, (IExtension)new UndoHandler((MapModel)this));
        this.setLockManager(ResourceController.getResourceController().getBooleanProperty("experimental_file_locking_on") ? new LockManager() : new DummyLockManager());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MMapModel.this.scheduleTimerForAutomaticSaving();
            }
        });
    }

    public void destroy() {
        this.getLockManager().releaseLock();
        this.getLockManager().releaseTimer();
        if (this.getTimerForAutomaticSaving() != null) {
            this.getTimerForAutomaticSaving().cancel();
        }
        super.destroy();
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public Timer getTimerForAutomaticSaving() {
        return this.timerForAutomaticSaving;
    }

    public String getTitle() {
        URL url = this.getURL();
        if (url != null) {
            File file = this.getFile();
            if (file != null) {
                String fileName = file.getName();
                if (fileName.endsWith(".mm")) {
                    return fileName.substring(0, fileName.length() - ".mm".length());
                }
                return fileName;
            }
            return url.toString();
        }
        if (this.titleNumber == 0) {
            this.titleNumber = unnamedMapsNumber++;
        }
        return TextUtils.getText((String)"mindmap") + this.titleNumber;
    }

    public void scheduleTimerForAutomaticSaving() {
        if (!(UrlManager.getController() instanceof MFileManager)) {
            return;
        }
        int numberOfTempFiles = Integer.parseInt(ResourceController.getResourceController().getProperty("number_of_different_files_for_automatic_save"));
        if (numberOfTempFiles == 0) {
            return;
        }
        boolean filesShouldBeDeletedAfterShutdown = ResourceController.getResourceController().getBooleanProperty("delete_automatic_saves_at_exit");
        int delay = ResourceController.getResourceController().getTimeProperty("time_for_automatic_save");
        if (delay == 0) {
            return;
        }
        boolean useSingleBackupDirectory = ResourceController.getResourceController().getBooleanProperty("single_backup_directory");
        String singleBackupDirectory = ResourceController.getResourceController().getProperty("single_backup_directory_path");
        Timer timer = SysUtils.createTimer((String)"TimerForAutomaticSaving");
        timer.schedule((TimerTask)new DoAutomaticSave(this, numberOfTempFiles, filesShouldBeDeletedAfterShutdown, useSingleBackupDirectory, singleBackupDirectory), delay, (long)delay);
        this.setTimerForAutomaticSaving(timer);
    }

    void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    void setTimerForAutomaticSaving(Timer timerForAutomaticSaving) {
        this.timerForAutomaticSaving = timerForAutomaticSaving;
    }
}

