/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url.mindmapmode;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collection;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.styles.LogicalStyleKeys;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.MFileManager;

class ExportBranchAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public ExportBranchAction() {
        super("ExportBranchAction");
    }

    public void actionPerformed(ActionEvent e) {
        int returnVal;
        File file;
        final NodeModel existingNode = Controller.getCurrentModeController().getMapController().getSelectedNode();
        Controller controller = Controller.getCurrentController();
        final MapModel parentMap = controller.getMap();
        if (parentMap == null || existingNode == null || existingNode.isRoot()) {
            controller.getViewController().err("Could not export branch.");
            return;
        }
        if (parentMap.getFile() == null) {
            controller.getViewController().out("You must save the current map first!");
            ((MModeController)Controller.getCurrentModeController()).save();
        }
        if ((file = parentMap.getFile()) == null) {
            return;
        }
        JFileChooser chooser = new JFileChooser(file.getParentFile());
        chooser.setSelectedFile(new File(this.createFileName(TextController.getController().getShortPlainText(existingNode))));
        if (((MFileManager)UrlManager.getController()).getFileFilter() != null) {
            chooser.addChoosableFileFilter(((MFileManager)UrlManager.getController()).getFileFilter());
        }
        if ((returnVal = chooser.showSaveDialog(controller.getViewController().getCurrentRootComponent())) == 0) {
            IExtension[] oldExtensions;
            int overwriteMap;
            File chosenFile = chooser.getSelectedFile();
            String ext = FileUtils.getExtension((String)chosenFile.getName());
            if (!ext.equals("mm")) {
                chosenFile = new File(chosenFile.getParent(), chosenFile.getName() + ".mm");
            }
            try {
                Compat.fileToUrl((File)chosenFile);
            }
            catch (MalformedURLException ex) {
                UITools.errorMessage((Object)TextUtils.getText((String)"invalid_url"));
                return;
            }
            if (chosenFile.exists() && (overwriteMap = JOptionPane.showConfirmDialog(controller.getMapViewManager().getMapViewComponent(), TextUtils.getText((String)"map_already_exists"), "Freeplane", 0)) != 0) {
                return;
            }
            NodeModel parent = existingNode.getParentNode();
            File oldFile = parentMap.getFile();
            URI newUri = LinkController.toLinkTypeDependantURI((File)oldFile, (File)chosenFile);
            URI oldUri = LinkController.toLinkTypeDependantURI((File)chosenFile, (File)file);
            ((MLinkController)LinkController.getController()).setLink(existingNode, oldUri, 0);
            int nodePosition = parent.getIndex(existingNode);
            ModeController modeController = Controller.getCurrentModeController();
            modeController.undoableResolveParentExtensions((Object)LogicalStyleKeys.NODE_STYLE, existingNode);
            final MMapController mMapController = (MMapController)modeController.getMapController();
            mMapController.deleteNode(existingNode);
            IActor actor = new IActor(){
                private final boolean wasFolded;
                {
                    this.wasFolded = existingNode.isFolded();
                }

                public void undo() {
                    PersistentNodeHook.removeMapExtensions((NodeModel)existingNode);
                    existingNode.setMap(parentMap);
                    existingNode.setFolded(this.wasFolded);
                }

                public String getDescription() {
                    return "ExportBranchAction";
                }

                public void act() {
                    existingNode.setParent(null);
                    existingNode.setFolded(false);
                    mMapController.newModel(existingNode);
                }
            };
            Controller.getCurrentModeController().execute(actor, parentMap);
            MapModel map = existingNode.getMap();
            for (IExtension extension : oldExtensions = map.getRootNode().getSharedExtensions().values().toArray(new IExtension[0])) {
                Class<?> clazz = extension.getClass();
                if (!PersistentNodeHook.isMapExtension(clazz)) continue;
                existingNode.removeExtension(clazz);
            }
            Collection newExtensions = parentMap.getRootNode().getSharedExtensions().values();
            for (IExtension extension : newExtensions) {
                Class<?> clazz = extension.getClass();
                if (!PersistentNodeHook.isMapExtension(clazz)) continue;
                existingNode.addExtension(extension);
            }
            ((MFileManager)UrlManager.getController()).save(map, chosenFile);
            NodeModel newNode = mMapController.addNewNode(parent, nodePosition, existingNode.isLeft());
            ((MTextController)TextController.getController()).setNodeText(newNode, existingNode.getText());
            modeController.undoableCopyExtensions((Object)LogicalStyleKeys.NODE_STYLE, existingNode, newNode);
            map.getFile();
            ((MLinkController)LinkController.getController()).setLink(newNode, newUri, 0);
            map.destroy();
        }
    }

    private String createFileName(String shortText) {
        String[] words;
        StringBuilder builder = new StringBuilder(50);
        for (String word : words = shortText.split("\\s")) {
            if ("...".equals(word)) continue;
            builder.append(StringUtils.capitalize((String)word));
        }
        return builder.toString();
    }
}

