/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.FreeplaneMenuBar;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.FrameController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.main.application.Browser;
import org.freeplane.main.application.MapViewDockingWindows;
import org.freeplane.main.application.NavigationNextMapAction;
import org.freeplane.main.application.NavigationPreviousMapAction;
import org.freeplane.main.application.SplitPaneLayoutManagerDecorator;
import org.freeplane.view.swing.map.MapView;

class ApplicationViewController
extends FrameController {
    private static final String SPLIT_PANE_LAST_LEFT_POSITION = "split_pane_last_left_position";
    private static final String SPLIT_PANE_LAST_POSITION = "split_pane_last_position";
    private static final String SPLIT_PANE_LAST_RIGHT_POSITION = "split_pane_last_right_position";
    private static final String SPLIT_PANE_LAST_TOP_POSITION = "split_pane_last_top_position";
    private static final String SPLIT_PANE_LEFT_POSITION = "split_pane_left_position";
    private static final String SPLIT_PANE_POSITION = "split_pane_position";
    private static final String SPLIT_PANE_RIGHT_POSITION = "split_pane_right_position";
    private static final String SPLIT_PANE_TOP_POSITION = "split_pane_top_position";
    private final JFrame frame;
    private String mLocationPreferenceValue;
    private JComponent mMindMapComponent;
    private final JSplitPane mSplitPane;
    private final NavigationNextMapAction navigationNextMap;
    private final NavigationPreviousMapAction navigationPreviousMap = new NavigationPreviousMapAction();
    private final ResourceController resourceController;
    private JComponent mapPane;
    private MapViewDockingWindows mapViewWindows;

    public ApplicationViewController(Controller controller, IMapViewManager mapViewController, JFrame frame) {
        super(controller, mapViewController, "");
        controller.addAction((AFreeplaneAction)this.navigationPreviousMap);
        this.navigationNextMap = new NavigationNextMapAction();
        controller.addAction((AFreeplaneAction)this.navigationNextMap);
        this.resourceController = ResourceController.getResourceController();
        this.frame = frame;
        frame.getContentPane().setLayout(new BorderLayout());
        this.mLocationPreferenceValue = this.resourceController.getProperty("note_location", "bottom");
        this.mSplitPane = new JSplitPane(){

            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                return false;
            }
        };
        this.setSplitPaneLayoutManager();
        this.mapViewWindows = new MapViewDockingWindows();
        JComponent contentPane = this.mapViewWindows.getMapPane();
        frame.getContentPane().add((Component)contentPane, "Center");
        this.mapPane = this.mapViewWindows.getMapPane();
        frame.getContentPane().add((Component)this.mSplitPane, "Center");
        this.mSplitPane.setLeftComponent(this.mapPane);
        this.mSplitPane.setRightComponent(null);
        this.initFrame(frame);
    }

    public void changeNoteWindowLocation() {
        this.mLocationPreferenceValue = this.resourceController.getProperty("note_location");
        if (this.mMindMapComponent != null) {
            this.insertComponentIntoSplitPane(this.mMindMapComponent);
        }
    }

    public String getAdjustableProperty(String label) {
        return this.resourceController.getProperty(label);
    }

    public FreeplaneMenuBar getFreeplaneMenuBar() {
        return Controller.getCurrentModeController().getUserInputListenerFactory().getMenuBar();
    }

    public void insertComponentIntoSplitPane(JComponent pMindMapComponent) {
        this.mMindMapComponent = pMindMapComponent;
        int splitPanePosition = -1;
        int lastSplitPanePosition = -1;
        this.mapPane.setVisible(true);
        this.mSplitPane.setLeftComponent(null);
        this.mSplitPane.setRightComponent(null);
        if ("right".equals(this.mLocationPreferenceValue)) {
            this.mSplitPane.setOrientation(1);
            this.mSplitPane.setLeftComponent(this.mapPane);
            this.mSplitPane.setRightComponent(pMindMapComponent);
            splitPanePosition = this.resourceController.getIntProperty(SPLIT_PANE_RIGHT_POSITION, -1);
            lastSplitPanePosition = this.resourceController.getIntProperty(SPLIT_PANE_LAST_RIGHT_POSITION, -1);
        } else if ("left".equals(this.mLocationPreferenceValue)) {
            this.mSplitPane.setOrientation(1);
            this.mSplitPane.setLeftComponent(pMindMapComponent);
            this.mSplitPane.setRightComponent(this.mapPane);
            splitPanePosition = this.resourceController.getIntProperty(SPLIT_PANE_LEFT_POSITION, -1);
            lastSplitPanePosition = this.resourceController.getIntProperty(SPLIT_PANE_LAST_LEFT_POSITION, -1);
        } else if ("top".equals(this.mLocationPreferenceValue)) {
            this.mSplitPane.setOrientation(0);
            this.mSplitPane.setLeftComponent(pMindMapComponent);
            this.mSplitPane.setRightComponent(this.mapPane);
            splitPanePosition = this.resourceController.getIntProperty(SPLIT_PANE_TOP_POSITION, -1);
            lastSplitPanePosition = this.resourceController.getIntProperty(SPLIT_PANE_LAST_TOP_POSITION, -1);
        } else if ("bottom".equals(this.mLocationPreferenceValue)) {
            this.mSplitPane.setOrientation(0);
            this.mSplitPane.setLeftComponent(this.mapPane);
            this.mSplitPane.setRightComponent(pMindMapComponent);
            splitPanePosition = this.resourceController.getIntProperty(SPLIT_PANE_POSITION, -1);
            lastSplitPanePosition = this.resourceController.getIntProperty(SPLIT_PANE_LAST_POSITION, -1);
        }
        this.mSplitPane.setContinuousLayout(true);
        this.mSplitPane.setOneTouchExpandable(false);
        this.setSplitPaneLayoutManager();
        this.mSplitPane.setResizeWeight(1.0);
        if (splitPanePosition != -1 && lastSplitPanePosition != -1) {
            this.mSplitPane.setDividerLocation(splitPanePosition);
            this.mSplitPane.setLastDividerLocation(lastSplitPanePosition);
        } else {
            this.mSplitPane.setDividerLocation(0.5);
        }
    }

    public boolean isApplet() {
        return false;
    }

    public void openDocument(URI uri) throws IOException {
        new Browser().openDocument(uri);
    }

    public void openDocument(URL url) throws Exception {
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            uri = new URI(url.getProtocol(), url.getHost(), url.getPath(), url.getQuery(), url.getRef());
        }
        this.openDocument(uri);
    }

    public boolean quit() {
        if (!super.quit()) {
            return false;
        }
        this.frame.dispose();
        return true;
    }

    public void removeSplitPane() {
        this.saveSplitPanePosition();
        this.mMindMapComponent = null;
        this.mSplitPane.setLeftComponent(null);
        this.mSplitPane.setRightComponent(null);
        this.mSplitPane.setLeftComponent(this.mapPane);
        this.setSplitPaneLayoutManager();
        final Controller controller = Controller.getCurrentModeController().getController();
        IMapSelection selection = controller.getSelection();
        if (selection == null) {
            return;
        }
        final NodeModel node = selection.getSelected();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component component = controller.getMapViewManager().getComponent(node);
                if (component != null) {
                    component.requestFocus();
                }
            }
        });
    }

    private void setSplitPaneLayoutManager() {
        LayoutManager layout = this.mSplitPane.getLayout();
        if (layout instanceof SplitPaneLayoutManagerDecorator) {
            return;
        }
        this.mSplitPane.setLayout(new SplitPaneLayoutManagerDecorator(layout));
    }

    public void saveProperties() {
        this.saveSplitPanePosition();
        if (this.frame.isResizable()) {
            int winState = this.frame.getExtendedState() & 0xFFFFFFFE;
            if (6 != (winState & 6)) {
                this.resourceController.setProperty("appwindow_x", String.valueOf(this.frame.getX()));
                this.resourceController.setProperty("appwindow_y", String.valueOf(this.frame.getY()));
                this.resourceController.setProperty("appwindow_width", String.valueOf(this.frame.getWidth()));
                this.resourceController.setProperty("appwindow_height", String.valueOf(this.frame.getHeight()));
            }
            this.resourceController.setProperty("appwindow_state", String.valueOf(winState));
        }
        this.mapViewWindows.saveLayout();
    }

    private void saveSplitPanePosition() {
        if (this.mSplitPane == null) {
            return;
        }
        if ("right".equals(this.mLocationPreferenceValue)) {
            this.resourceController.setProperty(SPLIT_PANE_RIGHT_POSITION, "" + this.mSplitPane.getDividerLocation());
            this.resourceController.setProperty(SPLIT_PANE_LAST_RIGHT_POSITION, "" + this.mSplitPane.getLastDividerLocation());
        } else if ("left".equals(this.mLocationPreferenceValue)) {
            this.resourceController.setProperty(SPLIT_PANE_LEFT_POSITION, "" + this.mSplitPane.getDividerLocation());
            this.resourceController.setProperty(SPLIT_PANE_LAST_LEFT_POSITION, "" + this.mSplitPane.getLastDividerLocation());
        } else if ("top".equals(this.mLocationPreferenceValue)) {
            this.resourceController.setProperty(SPLIT_PANE_TOP_POSITION, "" + this.mSplitPane.getDividerLocation());
            this.resourceController.setProperty(SPLIT_PANE_LAST_TOP_POSITION, "" + this.mSplitPane.getLastDividerLocation());
        } else {
            this.resourceController.setProperty(SPLIT_PANE_POSITION, "" + this.mSplitPane.getDividerLocation());
            this.resourceController.setProperty(SPLIT_PANE_LAST_POSITION, "" + this.mSplitPane.getLastDividerLocation());
        }
    }

    protected void setFreeplaneMenuBar(FreeplaneMenuBar menuBar) {
        this.frame.setJMenuBar((JMenuBar)menuBar);
    }

    public void setTitle(String frameTitle) {
        this.frame.setTitle(frameTitle);
        this.mapViewWindows.setTitle();
    }

    public void setWaitingCursor(boolean waiting) {
        if (waiting) {
            this.frame.getRootPane().getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            this.frame.getRootPane().getGlassPane().setVisible(true);
        } else {
            this.frame.getRootPane().getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
            this.frame.getRootPane().getGlassPane().setVisible(false);
        }
    }

    public void viewNumberChanged(int number) {
        this.navigationPreviousMap.setEnabled(number > 1);
        this.navigationNextMap.setEnabled(number > 1);
    }

    public void initFrame(JFrame frame) {
        if (!Compat.isMacOsX()) {
            ImageIcon mWindowIcon = Compat.isLowerJdk((String)"1.6.0") ? new ImageIcon(ResourceController.getResourceController().getResource("/images/Freeplane_frame_icon.png")) : new ImageIcon(ResourceController.getResourceController().getResource("/images/Freeplane_frame_icon_64x64.png"));
            frame.setIconImage(mWindowIcon.getImage());
        }
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Controller.getCurrentController().quit(new ActionEvent(this, 0, "quit"));
            }
        });
        frame.setFocusTraversalKeysEnabled(false);
        int win_width = ResourceController.getResourceController().getIntProperty("appwindow_width", -1);
        int win_height = ResourceController.getResourceController().getIntProperty("appwindow_height", -1);
        int win_x = ResourceController.getResourceController().getIntProperty("appwindow_x", -1);
        int win_y = ResourceController.getResourceController().getIntProperty("appwindow_y", -1);
        UITools.setBounds((Component)frame, (int)win_x, (int)win_y, (int)win_width, (int)win_height);
        this.applyFrameSize(frame, win_x, win_y);
        int win_state = Integer.parseInt(ResourceController.getResourceController().getProperty("appwindow_state", "0"));
        win_state = (win_state & 1) != 0 ? 0 : win_state;
        frame.setExtendedState(win_state);
    }

    private void applyFrameSize(JFrame frame, int win_x, int win_y) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle r = env.getMaximumWindowBounds();
        for (GraphicsDevice device : env.getScreenDevices()) {
            if (device.equals(env.getDefaultScreenDevice())) continue;
            Rectangle bounds = device.getDefaultConfiguration().getBounds();
            r.add(bounds);
        }
        frame.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        frame.setPreferredSize(new Dimension(Math.min(r.width, frame.getBounds().width), Math.min(r.height, frame.getBounds().height)));
        frame.setLocation(Math.max(r.x, win_x), Math.max(r.y, win_y));
    }

    public void openMapsOnStart() {
        this.mapViewWindows.loadLayout();
    }

    public void focusTo(MapView currentMapView) {
        this.mapViewWindows.focusMapViewLater(currentMapView);
    }

    public void previousMapView() {
        this.mapViewWindows.selectPreviousMapView();
    }

    public void nextMapView() {
        this.mapViewWindows.selectNextMapView();
    }

    protected void setFullScreen(boolean fullScreen) {
        super.setFullScreen(fullScreen);
        if (fullScreen) {
            this.mapViewWindows.setTabAreaInvisiblePolicy((JFrame)UITools.getCurrentRootComponent());
        } else {
            this.mapViewWindows.setTabAreaVisiblePolicy((JFrame)UITools.getCurrentRootComponent());
        }
    }

    public Component getCurrentRootComponent() {
        Component mapViewComponent = this.controller.getMapViewManager().getMapViewComponent();
        return mapViewComponent != null ? SwingUtilities.getRoot(mapViewComponent) : this.frame;
    }

    public Component getMenuComponent() {
        return this.frame;
    }

    public List<? extends Component> getMapViewVector() {
        return this.mapViewWindows.getMapViewVector();
    }
}

