/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.mindmapmode.stylemode;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.StyleTranslatedObject;

public class DeleteUserStyleAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public DeleteUserStyleAction() {
        super("DeleteUserStyleAction");
    }

    public void actionPerformed(ActionEvent e) {
        ModeController modeController = Controller.getCurrentModeController();
        Controller controller = modeController.getController();
        final NodeModel selected = controller.getSelection().getSelected();
        if (selected.depth() < 2) {
            UITools.errorMessage((Object)TextUtils.getText((String)"can_not_delete_style_group"));
            return;
        }
        MapModel map = selected.getMap();
        final MapStyleModel styleModel = MapStyleModel.getExtension((MapModel)map);
        NodeModel styleNodeGroup = styleModel.getStyleNodeGroup(selected);
        if (!((StyleTranslatedObject)styleNodeGroup.getUserObject()).getObject().equals("styles.user-defined")) {
            UITools.errorMessage((Object)TextUtils.getText((String)"can_not_delete_predefined_style"));
            return;
        }
        MMapController mapController = (MMapController)modeController.getMapController();
        mapController.deleteNode(selected);
        IActor actor = new IActor(){

            public void undo() {
                styleModel.addStyleNode(selected);
            }

            public String getDescription() {
                return "DeleteStyle";
            }

            public void act() {
                styleModel.removeStyleNode(selected);
            }
        };
        Controller.getCurrentModeController().execute(actor, map);
    }
}

