/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.launcher;

import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URL;
import org.knopflerfish.framework.Main;

public class Launcher {
    private File frameworkDir;
    private int argCount;

    public Launcher() {
        if (this.isDefineNotSet("org.freeplane.basedirectory")) {
            this.frameworkDir = this.getPathToJar();
        } else {
            try {
                this.frameworkDir = new File(System.getProperty("org.freeplane.basedirectory")).getCanonicalFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.argCount = 0;
    }

    private static void fixX11AppName() {
        try {
            Toolkit xToolkit = Toolkit.getDefaultToolkit();
            if (xToolkit.getClass().getName().equals("sun.awt.X11.XToolkit")) {
                Field awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
                awtAppClassNameField.setAccessible(true);
                awtAppClassNameField.set(xToolkit, "Freeplane");
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            System.err.format("Couldn't set awtAppClassName: %s%n", e.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        Launcher.fixX11AppName();
        Launcher.workAroundForDataFlavorComparator_JDK8130242();
        new Launcher().launch(args);
    }

    private static void workAroundForDataFlavorComparator_JDK8130242() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.startsWith("1.7.") || javaVersion.startsWith("1.8.")) {
            System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        }
    }

    private void launch(String[] args) {
        this.setDefines();
        this.setArgProperties(args);
        this.run();
    }

    private void setDefines() {
        this.setDefine("org.knopflerfish.framework.readonly", "true");
        this.setDefine("org.knopflerfish.gosg.jars", "reference:file:" + this.getAbsolutePath("core") + '/');
        this.setDefine("org.freeplane.basedirectory", this.getAbsolutePath());
        this.setDefineIfNeeded("org.freeplane.globalresourcedir", this.getAbsolutePath("resources"));
        this.setDefineIfNeeded("java.security.policy", this.getAbsolutePath("freeplane.policy"));
        this.setDefine("org.osgi.framework.storage", this.getAbsolutePath("fwdir"));
        System.setSecurityManager(new SecurityManager());
    }

    private void setDefineIfNeeded(String name, String value) {
        if (this.isDefineNotSet(name)) {
            this.setDefine(name, value);
        }
    }

    private boolean isDefineNotSet(String name) {
        return System.getProperty(name, null) == null;
    }

    private String setDefine(String name, String value) {
        System.out.println(name + "=" + value);
        return System.setProperty(name, value);
    }

    private void run() {
        String[] args = new String[]{"-xargs", this.getAbsolutePath("props.xargs"), "-xargs", this.getAbsolutePath("init.xargs")};
        Main.main(args);
    }

    private String getAbsolutePath() {
        return this.frameworkDir.getAbsolutePath();
    }

    private String getAbsolutePath(String relativePath) {
        return new File(this.frameworkDir, relativePath).getAbsolutePath();
    }

    private File getPathToJar() {
        URL frameworkUrl = Main.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            return new File(frameworkUrl.toURI()).getCanonicalFile().getParentFile();
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void setArgProperties(String[] args) {
        for (String arg : args) {
            this.setArgumentProperty(arg);
        }
    }

    private void setArgumentProperty(String arg) {
        String propertyName = "org.freeplane.param" + ++this.argCount;
        System.setProperty(propertyName, arg);
    }
}

