/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.map.NodeModel;

public class EvaluationDependencies
implements IExtension {
    private HashMap<NodeModel, HashSet<NodeModel>> onNodeDependencies = new HashMap();
    private HashMap<NodeModel, HashSet<NodeModel>> onBranchDependencies = new HashMap();
    private HashSet<NodeModel> onAnyNodeDependencies = new HashSet();

    public Set<NodeModel> getDependencies(Set<NodeModel> result, NodeModel node) {
        HashSet<NodeModel> onNode = this.onNodeDependencies.get(node);
        if (onNode != null) {
            this.addRecursively(result, onNode);
        }
        for (Map.Entry<NodeModel, HashSet<NodeModel>> entry : this.onBranchDependencies.entrySet()) {
            if (!node.isDescendantOf(entry.getKey())) continue;
            this.addRecursively(result, entry.getValue());
        }
        this.addRecursively(result, this.onAnyNodeDependencies);
        return result;
    }

    private void addRecursively(Set<NodeModel> dependentNodes, HashSet<NodeModel> nodesToAdd) {
        for (NodeModel node : nodesToAdd) {
            if (!dependentNodes.add(node)) continue;
            dependentNodes.addAll(this.getDependencies(dependentNodes, node));
        }
    }

    public void accessNode(NodeModel formulaNode, NodeModel accessedNode) {
        this.getDependencySet(accessedNode, this.onNodeDependencies).add(formulaNode);
    }

    public void accessBranch(NodeModel formulaNode, NodeModel accessedNode) {
        this.getDependencySet(accessedNode, this.onBranchDependencies).add(formulaNode);
    }

    public void accessAll(NodeModel formulaNode) {
        this.onAnyNodeDependencies.add(formulaNode);
    }

    private HashSet<NodeModel> getDependencySet(NodeModel accessedNode, HashMap<NodeModel, HashSet<NodeModel>> dependenciesMap) {
        HashSet<Object> set = dependenciesMap.get(accessedNode);
        if (set == null) {
            set = new HashSet();
            dependenciesMap.put(accessedNode, set);
        }
        return set;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<NodeModel, HashSet<NodeModel>> entry : this.onNodeDependencies.entrySet()) {
            builder.append("onNode (" + entry.getKey().getText() + "):\n");
            for (NodeModel nodeModel : entry.getValue()) {
                builder.append("  " + nodeModel + "\n");
            }
        }
        for (Map.Entry<NodeModel, HashSet<NodeModel>> entry : this.onBranchDependencies.entrySet()) {
            builder.append("onBranch (" + entry.getKey().getText() + "):\n");
            for (NodeModel nodeModel : entry.getValue()) {
                builder.append("  " + nodeModel + "\n");
            }
        }
        if (!this.onAnyNodeDependencies.isEmpty()) {
            builder.append("onAnyNode:\n");
            for (NodeModel nodeModel : this.onAnyNodeDependencies) {
                builder.append("  " + nodeModel + "\n");
            }
        }
        return builder.toString();
    }

    public static enum Access {
        NODE,
        BRANCH,
        ALL;

    }
}

