/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.Script;
import java.io.File;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.script.CompileTimeStrategy;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.FreeplaneScriptBaseClass;
import org.freeplane.plugin.script.GroovyShell;
import org.freeplane.plugin.script.IFreeplaneScriptErrorHandler;
import org.freeplane.plugin.script.IScript;
import org.freeplane.plugin.script.ScriptClassLoader;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.ScriptResources;
import org.freeplane.plugin.script.ScriptSecurity;
import org.freeplane.plugin.script.ScriptingPermissions;
import org.freeplane.plugin.script.ScriptingSecurityManager;
import org.freeplane.plugin.script.proxy.ProxyFactory;

public class GroovyScript
implements IScript {
    private final Object script;
    private final ScriptingPermissions specificPermissions;
    private Script compiledScript;
    private Throwable errorsInScript;
    private IFreeplaneScriptErrorHandler errorHandler;
    private PrintStream outStream;
    private ScriptContext scriptContext;
    private CompileTimeStrategy compileTimeStrategy;
    private ScriptClassLoader scriptClassLoader;

    public GroovyScript(String script) {
        this((Object)script);
    }

    public GroovyScript(File script) {
        this((Object)script);
        this.compileTimeStrategy = new CompileTimeStrategy(script);
    }

    public GroovyScript(String script, ScriptingPermissions permissions) {
        this((Object)script, permissions);
    }

    public GroovyScript(File script, ScriptingPermissions permissions) {
        this((Object)script, permissions);
        this.compileTimeStrategy = new CompileTimeStrategy(script);
    }

    private GroovyScript(Object script, ScriptingPermissions permissions) {
        this.script = script;
        this.specificPermissions = permissions;
        this.compiledScript = null;
        this.errorsInScript = null;
        this.errorHandler = ScriptResources.IGNORING_SCRIPT_ERROR_HANDLER;
        this.outStream = System.out;
        this.scriptContext = null;
        this.compileTimeStrategy = new CompileTimeStrategy(null);
    }

    private GroovyScript(Object script) {
        this(script, null);
    }

    @Override
    public IScript setErrorHandler(IFreeplaneScriptErrorHandler pErrorHandler) {
        this.errorHandler = pErrorHandler;
        return this;
    }

    @Override
    public IScript setOutStream(PrintStream outStream) {
        this.outStream = outStream;
        return this;
    }

    @Override
    public IScript setScriptContext(ScriptContext scriptContext) {
        this.scriptContext = scriptContext;
        return this;
    }

    @Override
    public Object getScript() {
        return this.script;
    }

    public Script getCompiledScript() {
        return this.compiledScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(NodeModel node) {
        Object object;
        if (this.errorsInScript != null && this.compileTimeStrategy.canUseOldCompiledScript()) {
            throw new ExecuteScriptException(this.errorsInScript.getMessage(), this.errorsInScript);
        }
        PrintStream oldOut = System.out;
        try {
            this.trustedCompileAndCache();
            Binding binding = this.createBinding(node);
            this.compiledScript.setBinding(binding);
            System.setOut(this.outStream);
            object = this.compiledScript.run();
        }
        catch (Throwable throwable) {
            try {
                System.setOut(oldOut);
                throw throwable;
            }
            catch (GroovyRuntimeException e) {
                this.handleScriptRuntimeException(e);
                throw new RuntimeException(e);
            }
            catch (Throwable e) {
                if (Controller.getCurrentController().getSelection() != null && node.hasVisibleContent()) {
                    Controller.getCurrentModeController().getMapController().select(node);
                }
                throw new ExecuteScriptException(e.getMessage(), e);
            }
        }
        System.setOut(oldOut);
        return object;
    }

    private ScriptingSecurityManager createScriptingSecurityManager() {
        return new ScriptSecurity(this.script, this.specificPermissions, this.outStream).getScriptingSecurityManager();
    }

    private void trustedCompileAndCache() throws Throwable {
        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws PrivilegedActionException {
                try {
                    GroovyScript.this.compileAndCache();
                }
                catch (Exception e) {
                    throw new PrivilegedActionException(e);
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        });
    }

    private Script compileAndCache() throws Throwable {
        ScriptingSecurityManager scriptingSecurityManager = this.createScriptingSecurityManager();
        if (this.compileTimeStrategy.canUseOldCompiledScript()) {
            this.scriptClassLoader.setSecurityManager(scriptingSecurityManager);
            return this.compiledScript;
        }
        this.removeOldScript();
        this.errorsInScript = null;
        if (this.script instanceof Script) {
            return (Script)this.script;
        }
        try {
            Binding binding = this.createBindingForCompilation();
            this.scriptClassLoader = ScriptClassLoader.createClassLoader();
            this.scriptClassLoader.setSecurityManager(scriptingSecurityManager);
            GroovyShell shell = new GroovyShell(this.scriptClassLoader, binding, GroovyScript.createCompilerConfiguration());
            this.compileTimeStrategy.scriptCompileStart();
            if (this.script instanceof String) {
                this.compiledScript = shell.parse((String)this.script);
            } else if (this.script instanceof File) {
                this.compiledScript = shell.parse((File)this.script);
            } else {
                throw new IllegalArgumentException();
            }
            this.compileTimeStrategy.scriptCompiled();
            return this.compiledScript;
        }
        catch (Throwable e) {
            this.errorsInScript = e;
            throw e;
        }
    }

    private void removeOldScript() {
        if (this.compiledScript != null) {
            InvokerHelper.removeClass(this.compiledScript.getClass());
            this.compiledScript = null;
        }
    }

    private Binding createBinding(NodeModel node) {
        Binding binding = new Binding();
        binding.setVariable("c", (Object)ProxyFactory.createController(this.scriptContext));
        binding.setVariable("node", (Object)ProxyFactory.createNode(node, this.scriptContext));
        return binding;
    }

    private Binding createBindingForCompilation() {
        Binding binding = new Binding();
        binding.setVariable("c", null);
        binding.setVariable("node", null);
        return binding;
    }

    private void handleScriptRuntimeException(GroovyRuntimeException e) {
        this.outStream.print("message: " + e.getMessage());
        ModuleNode module = e.getModule();
        ASTNode astNode = e.getNode();
        int lineNumber = -1;
        lineNumber = module != null ? module.getLineNumber() : (astNode != null ? astNode.getLineNumber() : this.findLineNumberInString(e.getMessage(), lineNumber));
        this.outStream.print("Line number: " + lineNumber);
        this.errorHandler.gotoLine(lineNumber);
        throw new ExecuteScriptException(e.getMessage() + " at line " + lineNumber, e);
    }

    static CompilerConfiguration createCompilerConfiguration() {
        CompilerConfiguration config = new CompilerConfiguration();
        config.setScriptBaseClass(FreeplaneScriptBaseClass.class.getName());
        if (ScriptResources.getClasspath() != null && !ScriptResources.getClasspath().isEmpty()) {
            config.setClasspathList(ScriptResources.getClasspath());
        }
        return config;
    }

    private int findLineNumberInString(String resultString, int lineNumber) {
        Pattern pattern = Pattern.compile(".*@ line ([0-9]+).*", 32);
        Matcher matcher = pattern.matcher(resultString);
        if (matcher.matches()) {
            lineNumber = Integer.parseInt(matcher.group(1));
        }
        return lineNumber;
    }

    protected void finalize() throws Throwable {
        this.removeOldScript();
        super.finalize();
    }

    @Override
    public boolean permissionsEquals(ScriptingPermissions permissions) {
        if (this.specificPermissions == null) {
            return this.specificPermissions == permissions;
        }
        return this.specificPermissions.equals(permissions);
    }
}

