/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.addons;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.main.addons.AddOnProperties;
import org.freeplane.plugin.script.addons.AddOnInstallerPanel;
import org.freeplane.plugin.script.addons.ManageAddOnsPanel;

public class ManageAddOnsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private AddOnInstallerPanel addOnInstallerPanel;
    private JTabbedPane tabbedPane;

    public ManageAddOnsDialog(List<AddOnProperties> addOns) {
        super((Frame)UITools.getMenuComponent(), TextUtils.getText((String)"ManageAddOnsAction.text"), true);
        if (this.getOwner() != null) {
            Window[] ownedWindows;
            for (Window w : ownedWindows = this.getOwner().getOwnedWindows()) {
                if (!w.isVisible()) continue;
                w.toBack();
            }
        }
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setPreferredSize(this.getPreferredSizeForWindow());
        ManageAddOnsPanel manageAddOnsPanel = new ManageAddOnsPanel(this.filterNonThemes(addOns));
        ManageAddOnsPanel manageThemesPanel = new ManageAddOnsPanel(this.filterThemes(addOns));
        this.addOnInstallerPanel = new AddOnInstallerPanel(manageAddOnsPanel, manageThemesPanel);
        this.tabbedPane.addTab(ManageAddOnsDialog.getText("tab.install", new Object[0]), this.createIcon("/images/install_addons.png"), this.addOnInstallerPanel, ManageAddOnsDialog.getText("tab.install.tooltip", new Object[0]));
        this.tabbedPane.addTab(ManageAddOnsDialog.getText("tab.manage", new Object[0]), this.createIcon("/images/manage_addons.png"), manageAddOnsPanel, ManageAddOnsDialog.getText("tab.manage.tooltip", new Object[0]));
        this.tabbedPane.addTab(ManageAddOnsDialog.getText("tab.manage.themes", new Object[0]), this.createIcon("/images/manage_themes.png"), manageThemesPanel, ManageAddOnsDialog.getText("tab.manage.themes.tooltip", new Object[0]));
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton closeButton = new JButton();
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)closeButton, (String)TextUtils.getRawText((String)"close_btn"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageAddOnsDialog.this.setVisible(false);
            }
        });
        buttonPane.add(closeButton);
        this.pack();
        this.setDefaultCloseOperation(2);
        UITools.addEscapeActionToDialog((JDialog)this);
    }

    private List<AddOnProperties> filterThemes(List<AddOnProperties> addOns) {
        ArrayList<AddOnProperties> result = new ArrayList<AddOnProperties>(addOns.size());
        for (AddOnProperties addOn : addOns) {
            if (!addOn.isTheme()) continue;
            result.add(addOn);
        }
        return result;
    }

    private List<AddOnProperties> filterNonThemes(List<AddOnProperties> addOns) {
        ArrayList<AddOnProperties> result = new ArrayList<AddOnProperties>(addOns.size());
        for (AddOnProperties addOn : addOns) {
            if (addOn.isTheme()) continue;
            result.add(addOn);
        }
        return result;
    }

    private ImageIcon createIcon(String resource) {
        return new ImageIcon(ResourceController.getResourceController().getResource(resource));
    }

    private Dimension getPreferredSizeForWindow() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return new Dimension((int)screenSize.getWidth() * 4 / 5, (int)screenSize.getHeight() * 2 / 3);
    }

    private static String getResourceKey(String key) {
        return "ManageAddOnsDialog." + key;
    }

    static String getText(String key, Object ... parameters) {
        if (parameters.length == 0) {
            return TextUtils.getText((String)ManageAddOnsDialog.getResourceKey(key));
        }
        return TextUtils.format((String)ManageAddOnsDialog.getResourceKey(key), (Object[])parameters);
    }

    public void install(final URL url) {
        if (this.addOnInstallerPanel.isShowing()) {
            this.addOnInstallerPanel.getUrlField().setText(url.toString());
            this.tabbedPane.paintImmediately(0, 0, this.tabbedPane.getWidth(), this.tabbedPane.getHeight());
            this.addOnInstallerPanel.getInstallButton().doClick();
        } else {
            this.addOnInstallerPanel.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if (ManageAddOnsDialog.this.addOnInstallerPanel.isShowing()) {
                        ManageAddOnsDialog.this.addOnInstallerPanel.removeHierarchyListener(this);
                        ManageAddOnsDialog.this.install(url);
                    }
                }
            });
            this.tabbedPane.setSelectedComponent(this.addOnInstallerPanel);
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        }
    }
}

