/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.AbstractProxy;
import org.freeplane.plugin.script.proxy.Proxy;

class IconsProxy
extends AbstractProxy<NodeModel>
implements Proxy.Icons {
    IconsProxy(NodeModel delegate, ScriptContext scriptContext) {
        super(delegate, scriptContext);
    }

    @Override
    public void add(String name) {
        this.getIconController().addIcon((NodeModel)this.getDelegate(), IconStoreFactory.create().getMindIcon(name));
    }

    @Override
    public void addAll(Collection<String> names) {
        for (String name : names) {
            this.add(name);
        }
    }

    @Override
    public void addAll(Proxy.IconsRO icons) {
        for (String name : icons.getIcons()) {
            this.add(name);
        }
    }

    @Override
    @Deprecated
    public void addIcon(String name) {
        this.add(name);
    }

    private int findIcon(String iconID) {
        List icons = ((NodeModel)this.getDelegate()).getIcons();
        for (int i = 0; i < icons.size(); ++i) {
            if (!((MindIcon)icons.get(i)).getName().equals(iconID)) continue;
            return i;
        }
        return -1;
    }

    private MIconController getIconController() {
        return (MIconController)IconController.getController();
    }

    @Override
    public String getAt(int index) {
        List icons = ((NodeModel)this.getDelegate()).getIcons();
        return icons.size() <= index ? null : ((MindIcon)icons.get(index)).getName();
    }

    @Override
    public String getFirst() {
        List icons = ((NodeModel)this.getDelegate()).getIcons();
        return icons.isEmpty() ? null : ((MindIcon)icons.get(0)).getName();
    }

    @Override
    public boolean contains(String name) {
        List icons = ((NodeModel)this.getDelegate()).getIcons();
        for (MindIcon icon : icons) {
            if (!icon.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        List icons = ((NodeModel)this.getDelegate()).getIcons();
        return icons.size();
    }

    @Override
    public List<String> getIcons() {
        List icons = ((NodeModel)this.getDelegate()).getIcons();
        int size = icons.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(size);
        for (MindIcon icon : icons) {
            list.add(icon.getName());
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public List<URL> getUrls() {
        List icons = ((NodeModel)this.getDelegate()).getIcons();
        int size = icons.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<URL> list = new ArrayList<URL>(size);
        for (MindIcon icon : icons) {
            list.add(icon.getUrl());
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            final Iterator<String> iterator;
            {
                this.iterator = IconsProxy.this.getIcons().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public String next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("icons iterator is read-only");
            }
        };
    }

    @Override
    public boolean remove(int index) {
        if (index >= this.size()) {
            return false;
        }
        this.getIconController().removeIcon((NodeModel)this.getDelegate(), index);
        return true;
    }

    @Override
    public boolean remove(String iconID) {
        int index = this.findIcon(iconID);
        if (index == -1) {
            return false;
        }
        this.getIconController().removeIcon((NodeModel)this.getDelegate(), index);
        return true;
    }

    @Override
    @Deprecated
    public boolean removeIcon(String iconID) {
        return this.remove(iconID);
    }

    @Override
    public void clear() {
        this.getIconController().removeAllIcons((NodeModel)this.getDelegate());
    }

    public boolean asBoolean() {
        return this.size() > 0;
    }
}

