/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.AbstractProxy;
import org.freeplane.plugin.script.proxy.NodeProxy;
import org.freeplane.plugin.script.proxy.Proxy;

class LinkProxy
extends AbstractProxy<NodeModel>
implements Proxy.Link {
    LinkProxy(NodeModel delegate, ScriptContext scriptContext) {
        super(delegate, scriptContext);
    }

    @Override
    public String getText() {
        URI link = this.getUri();
        return link == null ? null : link.toString();
    }

    @Override
    public URI getUri() {
        return NodeLinks.getLink((NodeModel)((NodeModel)this.getDelegate()));
    }

    @Override
    public File getFile() {
        URI link = this.getUri();
        try {
            if (link == null) {
                return null;
            }
            if (!link.isAbsolute() && this.isFileUri(link)) {
                File mapFile = ((NodeModel)this.getDelegate()).getMap().getFile();
                return mapFile == null ? null : new File(mapFile.getParent(), link.getPath());
            }
            return new File(link);
        }
        catch (Exception e) {
            LogUtils.warn((String)("link is not a file uri: " + e));
            return null;
        }
    }

    private boolean isFileUri(URI link) {
        return link.getScheme() == null || link.getScheme().equals("file");
    }

    @Override
    public Proxy.Node getNode() {
        URI uri = this.getUri();
        if (uri == null) {
            return null;
        }
        String link = uri.toString();
        if (!link.startsWith("#")) {
            LogUtils.warn((String)(link + " is no node id link"));
            return null;
        }
        NodeModel targetNode = ((NodeModel)this.getDelegate()).getMap().getNodeForID(link.substring(1));
        if (targetNode == null) {
            LogUtils.warn((String)(link + ": node does not exist (anymore?)"));
            return null;
        }
        return new NodeProxy(targetNode, this.getScriptContext());
    }

    @Override
    @Deprecated
    public String get() {
        URI link = NodeLinks.getValidLink((NodeModel)((NodeModel)this.getDelegate()));
        return link == null ? null : link.toString();
    }

    private MLinkController getLinkController() {
        return (MLinkController)LinkController.getController();
    }

    @Override
    public void setText(String target) {
        try {
            if (!this.removeLinkIfNull(target)) {
                this.getLinkController().setLink((NodeModel)this.getDelegate(), new URI(target), 0);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void setUri(URI target) {
        if (!this.removeLinkIfNull(target)) {
            this.getLinkController().setLink((NodeModel)this.getDelegate(), target, 0);
        }
    }

    @Override
    public void setFile(File file) {
        if (!this.removeLinkIfNull(file)) {
            this.getLinkController().setLink((NodeModel)this.getDelegate(), file.toURI(), 0);
        }
    }

    @Override
    public void setNode(Proxy.Node node) {
        if (!this.removeLinkIfNull(node)) {
            if (this.getModeController().getMapController().getNodeFromID(node.getId()) == null) {
                throw new IllegalArgumentException("target node " + node.toString() + " belongs to a different map");
            }
            this.setText("#" + node.getId());
        }
    }

    @Override
    @Deprecated
    public boolean set(String target) {
        try {
            this.setText(target);
            return true;
        }
        catch (RuntimeException e) {
            LogUtils.warn((Throwable)e);
            return false;
        }
    }

    private boolean removeLinkIfNull(Object target) {
        if (target == null) {
            this.getLinkController().setLink((NodeModel)this.getDelegate(), (URI)null, 0);
            return true;
        }
        return false;
    }

    public boolean asBoolean() {
        return this.getUri() != null;
    }

    @Override
    public boolean remove() {
        return this.removeLinkIfNull(null);
    }
}

