/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.freeplane.core.util.TextUtils;

public class TranslatedObject {
    private String translation;
    private Object object;
    private Icon icon;
    private static ListCellRenderer listCellRenderer;

    public static TranslatedObject literal(String literal) {
        TranslatedObject result = new TranslatedObject();
        result.object = literal;
        result.translation = literal;
        return result;
    }

    private TranslatedObject() {
    }

    public TranslatedObject(Object object, String translation) {
        this.object = object;
        this.translation = translation;
    }

    public TranslatedObject(String object) {
        this.object = object;
        this.translation = TextUtils.getText(object);
    }

    public Object getObject() {
        return this.object;
    }

    public boolean objectEquals(Object o) {
        return this.object.equals(o);
    }

    public String toString() {
        return this.translation;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TranslatedObject)) {
            return false;
        }
        TranslatedObject nobj = (TranslatedObject)obj;
        return this.object.equals(nobj.object);
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public static TranslatedObject format(String value) {
        int separatorPos = value.indexOf(44);
        if (separatorPos == -1) {
            return new TranslatedObject(value);
        }
        String key = value.substring(0, separatorPos);
        String s1 = value.substring(separatorPos + 1);
        String text = TextUtils.format(key, s1);
        return new TranslatedObject(value, text);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public static ListCellRenderer getIconRenderer() {
        if (listCellRenderer == null) {
            listCellRenderer = new ListCellRenderer(){
                private ListCellRenderer delegate = new DefaultListCellRenderer();

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Icon icon;
                    Object renderedValue = value instanceof TranslatedObject ? ((icon = ((TranslatedObject)value).getIcon()) != null ? icon : value) : value;
                    return this.delegate.getListCellRendererComponent(list, renderedValue, index, isSelected, cellHasFocus);
                }
            };
        }
        return listCellRenderer;
    }

    public static TranslatedObject[] fromEnum(Class<? extends Enum<?>> enumeration) {
        return TranslatedObject.fromEnum(enumeration.getSimpleName() + ".", enumeration);
    }

    public static TranslatedObject[] fromEnum(String prefix, Class<? extends Enum<?>> enumeration) {
        Enum<?>[] enumConstants = enumeration.getEnumConstants();
        TranslatedObject[] objs = new TranslatedObject[enumConstants.length];
        int i = 0;
        for (Enum<?> value : enumConstants) {
            objs[i++] = new TranslatedObject(value, TextUtils.getText(prefix + value.toString()));
        }
        return objs;
    }
}

