/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.JDialog;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.n3.nanoxml.IXMLParser;
import org.freeplane.n3.nanoxml.StdXMLReader;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.n3.nanoxml.XMLException;
import org.freeplane.n3.nanoxml.XMLParserFactory;
import org.freeplane.n3.nanoxml.XMLWriter;

public class WindowConfigurationStorage {
    protected int height;
    protected int width;
    protected int x;
    protected int y;
    private final String name;

    public WindowConfigurationStorage(String name) {
        this.name = name;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    private String marshall() {
        XMLElement xml = new XMLElement();
        xml.setAttribute("x", Integer.toString(this.x));
        xml.setAttribute("y", Integer.toString(this.y));
        xml.setAttribute("width", Integer.toString(this.width));
        xml.setAttribute("height", Integer.toString(this.height));
        xml.setName(this.name);
        this.marshallSpecificElements(xml);
        StringWriter string = new StringWriter();
        XMLWriter writer = new XMLWriter(string);
        try {
            writer.write(xml);
            return string.toString();
        }
        catch (IOException e) {
            LogUtils.severe(e);
            return null;
        }
    }

    protected void marshallSpecificElements(XMLElement xml) {
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void storeDialogPositions(JDialog dialog) {
        this.storeDialogPositions(dialog, this.name);
    }

    public void storeDialogPositions(JDialog dialog, String window_preference_storage_property) {
        this.setX(dialog.getX());
        this.setY(dialog.getY());
        this.setWidth(dialog.getWidth());
        this.setHeight(dialog.getHeight());
        String marshalled = this.marshall();
        ResourceController.getResourceController().setProperty(window_preference_storage_property, marshalled);
    }

    public XMLElement restoreDialogPositions(JDialog dialog) {
        return this.restoreDialogPositions(dialog, this.name);
    }

    public XMLElement restoreDialogPositions(JDialog dialog, String window_preference_storage_property) {
        String marshalled = ResourceController.getResourceController().getProperty(window_preference_storage_property);
        return this.unmarschall(marshalled, dialog);
    }

    protected XMLElement unmarschall(String marshalled, JDialog dialog) {
        if (marshalled != null) {
            IXMLParser parser = XMLParserFactory.createDefaultXMLParser();
            StdXMLReader xmlReader = new StdXMLReader(new StringReader(marshalled));
            parser.setReader(xmlReader);
            try {
                XMLElement storage = (XMLElement)parser.parse();
                if (storage != null) {
                    this.x = Integer.parseInt(storage.getAttribute("x", "-1"));
                    this.y = Integer.parseInt(storage.getAttribute("y", "-1"));
                    this.width = Integer.parseInt(storage.getAttribute("width", "-1"));
                    this.height = Integer.parseInt(storage.getAttribute("height", "-1"));
                    UITools.setBounds(dialog, this.x, this.y, this.width, this.height);
                    return storage;
                }
            }
            catch (NumberFormatException e) {
                LogUtils.severe(e);
            }
            catch (XMLException e) {
                LogUtils.severe(e);
            }
        }
        UITools.setBounds(dialog, -1, -1, -1, -1);
        return null;
    }
}

