/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.PropertyBean;
import org.freeplane.core.ui.components.JComboBoxWithBorder;
import org.freeplane.core.util.LogUtils;

public class FontProperty
extends PropertyBean
implements IPropertyControl {
    private final String[] mAvailableFontFamilyNames;
    JComboBox mFontComboBox = new JComboBoxWithBorder();

    public FontProperty(String name) {
        super(name);
        this.mAvailableFontFamilyNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.mFontComboBox.setModel(new DefaultComboBoxModel<String>(this.mAvailableFontFamilyNames));
        this.mFontComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                FontProperty.this.firePropertyChangeEvent();
            }
        });
    }

    @Override
    public String getValue() {
        return this.mAvailableFontFamilyNames[this.mFontComboBox.getSelectedIndex()];
    }

    @Override
    public void layout(DefaultFormBuilder builder) {
        this.layout(builder, this.mFontComboBox);
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.mFontComboBox.setEnabled(pEnabled);
    }

    @Override
    public void setValue(String pValue) {
        for (int i = 0; i < this.mAvailableFontFamilyNames.length; ++i) {
            String fontName = this.mAvailableFontFamilyNames[i];
            if (!fontName.equals(pValue)) continue;
            this.mFontComboBox.setSelectedIndex(i);
            return;
        }
        LogUtils.severe("Unknown value:" + pValue);
        if (this.mFontComboBox.getModel().getSize() > 0) {
            this.mFontComboBox.setSelectedIndex(0);
        }
    }
}

