/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui;

import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Convertible;
import org.freeplane.core.util.Quantity;

public enum LengthUnits implements Convertible
{
    px(1.0),
    in((double)UITools.FONT_SCALE_FACTOR * 72.0),
    mm((double)UITools.FONT_SCALE_FACTOR * 72.0 / 25.4),
    cm((double)UITools.FONT_SCALE_FACTOR * 72.0 / 2.54),
    pt(UITools.FONT_SCALE_FACTOR);

    private final double factor;

    private LengthUnits(double factor) {
        this.factor = factor;
    }

    @Override
    public double factor() {
        return this.factor;
    }

    public static Quantity<LengthUnits> pixelsInPt(double value) {
        return new Quantity<LengthUnits>(value, px).in(pt);
    }

    public static Quantity<LengthUnits> fromStringInPt(String value) {
        return Quantity.fromString(value, px).in(pt);
    }
}

