/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Component;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.freeplane.core.ui.LengthUnits;
import org.freeplane.core.util.Quantity;

public class JComboBoxWithBorder
extends JComboBox {
    private RendererWithBorder rendererWithBorder;
    private static final int MARGIN = new Quantity<LengthUnits>(2.0, LengthUnits.pt).toBaseUnitsRounded();
    private static final Border STANDARD_BORDER = new EmptyBorder(0, MARGIN, 0, MARGIN);

    public JComboBoxWithBorder() {
        this.initializeRenderer();
    }

    public JComboBoxWithBorder(ComboBoxModel aModel) {
        super(aModel);
        this.initializeRenderer();
    }

    public JComboBoxWithBorder(Object[] items) {
        super(items);
        this.initializeRenderer();
    }

    public JComboBoxWithBorder(Vector<?> items) {
        super(items);
        this.initializeRenderer();
    }

    private void initializeRenderer() {
        this.rendererWithBorder = new RendererWithBorder();
        this.updateUI();
    }

    public ListCellRenderer getRenderer() {
        if (this.rendererWithBorder == null) {
            return super.getRenderer();
        }
        return this.rendererWithBorder;
    }

    private ListCellRenderer getBaseRenderer() {
        return super.getRenderer();
    }

    class RendererWithBorder
    implements ListCellRenderer {
        RendererWithBorder() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ListCellRenderer baseRenderer = JComboBoxWithBorder.this.getBaseRenderer();
            if (baseRenderer == null) {
                return null;
            }
            Component listCellRendererComponent = baseRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (listCellRendererComponent instanceof JComponent) {
                JComponent borderOwner = (JComponent)listCellRendererComponent;
                borderOwner.setBorder(STANDARD_BORDER);
            }
            return listCellRendererComponent;
        }
    }
}

