/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.net.URI;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.url.UrlManager;
import org.freeplane.main.application.FreeplaneSplashModern;

public class UITools {
    public static final String MAIN_FREEPLANE_FRAME = "mainFreeplaneFrame";
    public static final String SCROLLBAR_INCREMENT = "scrollbar_increment";
    public static final Dimension MAX_BUTTON_DIMENSION = new Dimension(1000, 1000);
    public static final float FONT_SCALE_FACTOR;

    public static void addEscapeActionToDialog(JDialog dialog) {
        class EscapeAction
        extends AbstractAction {
            private static final long serialVersionUID = 1L;
            final /* synthetic */ JDialog val$dialog;

            EscapeAction(JDialog jDialog) {
                this.val$dialog = jDialog;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$dialog.dispose();
            }
        }
        UITools.addEscapeActionToDialog(dialog, new EscapeAction(dialog));
    }

    public static void addEscapeActionToDialog(JDialog dialog, Action action) {
        UITools.addKeyActionToDialog(dialog, action, "ESCAPE", "end_dialog");
    }

    public static void addKeyActionToDialog(JDialog dialog, Action action, String keyStroke, String actionId) {
        action.putValue("Name", actionId);
        dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(keyStroke), action.getValue("Name"));
        dialog.getRootPane().getActionMap().put(action.getValue("Name"), action);
    }

    public static void convertPointFromAncestor(Component ancestor, Point p, Component c) {
        while (c != ancestor && c != null) {
            int x = c.getX();
            int y = c.getY();
            p.x -= x;
            p.y -= y;
            c = c.getParent();
        }
    }

    public static void convertPointToAncestor(Component source, Point point, Class<?> ancestorClass) {
        Container destination = SwingUtilities.getAncestorOfClass(ancestorClass, source);
        UITools.convertPointToAncestor(source, point, destination);
    }

    public static void convertRectangleToAncestor(Component from, Rectangle r, Component destination) {
        Point p = new Point(r.x, r.y);
        UITools.convertPointToAncestor(from, p, destination);
        r.x = p.x;
        r.y = p.y;
    }

    public static void convertPointToAncestor(Component from, Point p, Component destination) {
        for (Component c = from; c != destination && c != null; c = c.getParent()) {
            int x = c.getX();
            int y = c.getY();
            p.x += x;
            p.y += y;
        }
    }

    public static void errorMessage(Object message) {
        final String myMessage = message != null ? message.toString() : TextUtils.getText("undefined_error");
        LogUtils.warn(myMessage);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(UITools.getCurrentRootComponent(), myMessage, "Freeplane", 0);
            }
        });
    }

    public static Component getCurrentRootComponent() {
        return Controller.getCurrentController().getViewController().getCurrentRootComponent();
    }

    public static Frame getCurrentFrame() {
        Component currentRootComponent = UITools.getCurrentRootComponent();
        return currentRootComponent instanceof Frame ? (Frame)currentRootComponent : JOptionPane.getFrameForComponent(currentRootComponent);
    }

    public static Frame getFrame() {
        Component currentRootComponent = UITools.getMenuComponent();
        return currentRootComponent instanceof Frame ? (Frame)currentRootComponent : JOptionPane.getFrameForComponent(currentRootComponent);
    }

    public static Component getMenuComponent() {
        return Controller.getCurrentController().getViewController().getMenuComponent();
    }

    public static KeyStroke getKeyStroke(String keyStrokeDescription) {
        if (keyStrokeDescription == null) {
            return null;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyStrokeDescription);
        if (keyStroke != null) {
            return keyStroke;
        }
        int lastSpacePos = keyStrokeDescription.lastIndexOf(32) + 1;
        String modifiedDescription = keyStrokeDescription.substring(0, lastSpacePos) + "typed " + keyStrokeDescription.substring(lastSpacePos);
        return KeyStroke.getKeyStroke(modifiedDescription);
    }

    public static String keyStrokeToString(KeyStroke keyStroke) {
        String acceleratorText = "";
        if (keyStroke != null) {
            int modifiers = keyStroke.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + "+";
            }
            acceleratorText = acceleratorText + KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        return acceleratorText;
    }

    public static void informationMessage(String message) {
        UITools.informationMessage(UITools.getCurrentRootComponent(), message);
    }

    public static void informationMessage(Component frame, String message) {
        UITools.informationMessage(frame, message, "Freeplane");
    }

    public static void informationMessage(Component frame, String message, String title) {
        JOptionPane.showMessageDialog(frame, message, title, 1);
    }

    public static void informationMessage(Component frame, String text, String string, int type) {
        JOptionPane.showMessageDialog(frame, text, string, type);
    }

    public static void setBounds(Component frame, int win_x, int win_y, int win_width, int win_height) {
        Rectangle frameBounds = UITools.getValidFrameBounds(frame, win_x, win_y, win_width, win_height);
        frame.setBounds(frameBounds);
    }

    public static Rectangle getValidFrameBounds(Component frame, int win_x, int win_y, int win_width, int win_height) {
        GraphicsConfiguration graphicsConfiguration = UITools.findGraphicsConfiguration(frame, win_x, win_y);
        Rectangle screenBounds = UITools.getScreenBounds(graphicsConfiguration);
        int screenWidth = screenBounds.width;
        win_width = win_width != -1 ? Math.min(win_width, screenWidth) : screenWidth * 4 / 5;
        int screenHeight = screenBounds.height;
        win_height = win_height != -1 ? Math.min(win_height, screenHeight) : screenHeight * 4 / 5;
        if (win_x != -1) {
            win_x = Math.min(screenWidth + screenBounds.x - win_width, win_x);
            win_x = Math.max(screenBounds.x, win_x);
        } else {
            win_x = screenBounds.x + (screenWidth - win_width) / 2;
        }
        if (win_y != -1) {
            win_y = Math.max(screenBounds.y, win_y);
            win_y = Math.min(screenHeight + screenBounds.y - win_height, win_y);
        } else {
            win_y = screenBounds.y + (screenHeight - win_height) / 2;
        }
        Rectangle frameBounds = new Rectangle(win_x, win_y, win_width, win_height);
        return frameBounds;
    }

    private static GraphicsConfiguration findGraphicsConfiguration(Component component, int x, int y) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration[] gc = gd.getConfigurations();
            for (int i = 0; i < gc.length; ++i) {
                Rectangle screenBounds = gc[i].getBounds();
                if (!screenBounds.contains(x, y)) continue;
                return gc[i];
            }
        }
        return component != null ? component.getGraphicsConfiguration() : null;
    }

    public static Rectangle getAvailableScreenBounds(Component frame) {
        GraphicsConfiguration graphicsConfiguration = frame.getGraphicsConfiguration();
        return UITools.getScreenBounds(graphicsConfiguration);
    }

    public static Rectangle getScreenBounds(GraphicsConfiguration graphicsConfiguration) {
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        Insets screenInsets = defaultToolkit.getScreenInsets(graphicsConfiguration);
        Rectangle screenBounds = graphicsConfiguration.getBounds();
        Point screenLocation = screenBounds.getLocation();
        Dimension screenSize = screenBounds.getSize();
        int screenWidth = screenSize.width - screenInsets.left - screenInsets.right;
        int screenHeight = screenSize.height - screenInsets.top - screenInsets.bottom;
        return new Rectangle(screenLocation.x + screenInsets.left, screenLocation.y + screenInsets.top, screenWidth, screenHeight);
    }

    public static void setDialogLocationRelativeTo(JDialog dialog, Component c) {
        int bottomSpace;
        int topSpace;
        int rightSpace;
        int leftSpace;
        if (c == null || !c.isShowing()) {
            return;
        }
        Point compLocation = c.getLocationOnScreen();
        int cw = c.getWidth();
        int ch = c.getHeight();
        Container parent = dialog.getParent();
        Point parentLocation = parent.getLocationOnScreen();
        int pw = parent.getWidth();
        int ph = parent.getHeight();
        int dw = dialog.getWidth();
        int dh = dialog.getHeight();
        Rectangle desktopBounds = UITools.getAvailableScreenBounds(c);
        int minX = Math.max(parentLocation.x, desktopBounds.x);
        int minY = Math.max(parentLocation.y, desktopBounds.y);
        int maxX = Math.min(parentLocation.x + pw, desktopBounds.x + desktopBounds.width);
        int maxY = Math.min(parentLocation.y + ph, desktopBounds.y + desktopBounds.height);
        int dx = compLocation.x + cw < minX ? minX : (compLocation.x > maxX ? maxX - dw : ((leftSpace = compLocation.x - minX) > (rightSpace = maxX - (compLocation.x + cw)) ? (leftSpace > dw ? compLocation.x - dw : minX) : (rightSpace > dw ? compLocation.x + cw : maxX - dw)));
        int dy = compLocation.y + ch < minY ? minY : (compLocation.y > maxY ? maxY - dh : ((topSpace = compLocation.y - minY) > (bottomSpace = maxY - (compLocation.y + ch)) ? (topSpace > dh ? compLocation.y - dh : minY) : (bottomSpace > dh ? compLocation.y + ch : maxY - dh)));
        dialog.setLocation(dx, dy);
    }

    public static void setDialogLocationRelativeTo(JDialog dialog, NodeModel node) {
        if (node == null) {
            return;
        }
        IMapViewManager viewController = Controller.getCurrentController().getMapViewManager();
        viewController.scrollNodeToVisible(node);
        Component c = viewController.getComponent(node);
        UITools.setDialogLocationRelativeTo(dialog, c);
    }

    public static void setDialogLocationUnder(JDialog dialog, NodeModel node) {
        Controller controller = Controller.getCurrentController();
        IMapViewManager viewController = controller.getMapViewManager();
        JComponent c = (JComponent)viewController.getComponent(node);
        boolean x = false;
        int y = c.getHeight();
        Point location = new Point(0, y);
        SwingUtilities.convertPointToScreen(location, c);
        UITools.setBounds(dialog, location.x, location.y, dialog.getWidth(), dialog.getHeight());
    }

    public static void showAttributeEmptyStringErrorMessage() {
        JOptionPane.showMessageDialog(null, TextUtils.getText("attributes_adding_empty_attribute_error"), TextUtils.getText("error"), 0);
    }

    public static void showMessage(String message, int messageType) {
        UITools.backOtherWindows();
        JTextArea infoPane = new JTextArea();
        infoPane.setEditable(false);
        infoPane.setMargin(new Insets(5, 5, 5, 5));
        infoPane.setLineWrap(true);
        infoPane.setWrapStyleWord(true);
        infoPane.setText(message);
        infoPane.setColumns(60);
        JScrollPane scrollPane = new JScrollPane(infoPane);
        scrollPane.setPreferredSize(new Dimension(400, 200));
        JOptionPane.showMessageDialog(UITools.getCurrentRootComponent(), scrollPane, "Freeplane", messageType);
    }

    public static int showConfirmDialog(NodeModel node, Object message, String title, int optionType, int messageType) {
        Component parentComponent;
        Controller controller = Controller.getCurrentController();
        IMapViewManager viewController = controller.getMapViewManager();
        if (node == null) {
            parentComponent = UITools.getCurrentRootComponent();
        } else {
            viewController.scrollNodeToVisible(node);
            parentComponent = viewController.getComponent(node);
        }
        return JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType);
    }

    public static int showConfirmDialog(NodeModel node, Object message, String title, int optionType) {
        return UITools.showConfirmDialog(node, message, title, optionType, 3);
    }

    public static String showInputDialog(NodeModel node, String message, String initialValue) {
        if (node == null) {
            return null;
        }
        Controller controller = Controller.getCurrentController();
        IMapViewManager viewController = controller.getMapViewManager();
        viewController.scrollNodeToVisible(node);
        Component parentComponent = viewController.getComponent(node);
        return JOptionPane.showInputDialog(parentComponent, message, initialValue);
    }

    public static String showInputDialog(NodeModel node, String text, String title, int type) {
        if (node == null) {
            return null;
        }
        Controller controller = Controller.getCurrentController();
        IMapViewManager viewController = controller.getMapViewManager();
        viewController.scrollNodeToVisible(node);
        Component parentComponent = viewController.getComponent(node);
        return JOptionPane.showInputDialog(parentComponent, text, title, type);
    }

    public static void setScrollbarIncrement(JScrollPane scrollPane) {
        int scrollbarIncrement = ResourceController.getResourceController().getIntProperty(SCROLLBAR_INCREMENT, 1);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(scrollbarIncrement);
        scrollPane.getVerticalScrollBar().setUnitIncrement(scrollbarIncrement);
    }

    public static void addScrollbarIncrementPropertyListener(final JScrollPane scrollPane) {
        ResourceController.getResourceController().addPropertyChangeListener(new IFreeplanePropertyListener(){

            @Override
            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (!propertyName.equals(UITools.SCROLLBAR_INCREMENT)) {
                    return;
                }
                int scrollbarIncrement = Integer.valueOf(newValue);
                scrollPane.getHorizontalScrollBar().setUnitIncrement(scrollbarIncrement);
                scrollPane.getVerticalScrollBar().setUnitIncrement(scrollbarIncrement);
            }
        });
    }

    public static Color getTextColorForBackground(Color color) {
        int red = color.getRed();
        int blue = color.getBlue();
        int green = color.getGreen();
        return red > 128 && blue > 128 && green > 128 ? Color.BLACK : Color.WHITE;
    }

    public static void focusOn(JComponent component) {
        component.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                final JComponent component = event.getComponent();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        component.requestFocus();
                    }
                });
                component.removeAncestorListener(this);
            }
        });
    }

    public static BasicStroke createStroke(int width, int[] dash) {
        float[] fdash;
        if (dash != null) {
            fdash = new float[dash.length];
            int i = 0;
            int[] nArray = dash;
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                float d = nArray[j];
                fdash[i++] = d;
            }
        } else {
            fdash = null;
        }
        BasicStroke stroke = new BasicStroke(width, 0, 1, 1.0f, fdash, 0.0f);
        return stroke;
    }

    public static void repaintAll(Container root) {
        root.repaint();
        for (int i = 0; i < root.getComponentCount(); ++i) {
            Component component = root.getComponent(i);
            if (component instanceof Container) {
                UITools.repaintAll((Container)component);
                continue;
            }
            component.repaint();
        }
    }

    public static JDialog createCancelDialog(Component component, String titel, String text) {
        Object[] options = new String[]{TextUtils.getText("cancel")};
        JOptionPane infoPane = new JOptionPane(text, -1, -1, null, options);
        JDialog dialog = infoPane.createDialog(component, titel);
        dialog.setModal(false);
        return dialog;
    }

    public static void addTitledBorder(JComponent c, String title, float size) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(title);
        Font titleFont = UIManager.getFont("TitledBorder.font");
        titledBorder.setTitleFont(titleFont.deriveFont(size));
        Border btnBorder = c.getBorder();
        if (btnBorder != null) {
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(titledBorder, btnBorder);
            c.setBorder(compoundBorder);
        } else {
            c.setBorder(titledBorder);
        }
    }

    public static void backOtherWindows() {
        Component owner = UITools.getMenuComponent();
        if (owner instanceof Window) {
            Window[] ownedWindows;
            for (Window w : ownedWindows = ((Window)owner).getOwnedWindows()) {
                if (!w.isVisible()) continue;
                w.toBack();
            }
        }
    }

    public static JButton createHtmlLinkStyleButton(final URI uri, String title) {
        JButton button = new JButton("<html><a href='" + uri + "'>" + title);
        button.setBorderPainted(false);
        button.setOpaque(false);
        button.setBackground(Color.lightGray);
        button.setFocusable(false);
        button.setCursor(Cursor.getPredefinedCursor(12));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModeController modeController = Controller.getCurrentModeController();
                UrlManager urlManager = modeController.getExtension(UrlManager.class);
                urlManager.loadURL(uri);
            }
        });
        return button;
    }

    public static final int getComponentIndex(Component component) {
        if (component != null && component.getParent() != null) {
            Container c = component.getParent();
            for (int i = 0; i < c.getComponentCount(); ++i) {
                if (c.getComponent(i) != component) continue;
                return i;
            }
        }
        return -1;
    }

    private static float getScaleFactor() {
        return (float)ResourceController.getResourceController().getIntProperty("user_defined_screen_resolution", 96) / 72.0f;
    }

    public static Font scale(Font font) {
        return font.deriveFont(font.getSize2D() * FONT_SCALE_FACTOR);
    }

    public static Font scaleFontInt(Font font, double additionalFactor) {
        return font.deriveFont(font.getStyle(), Math.round((double)(font.getSize2D() * FONT_SCALE_FACTOR) * additionalFactor));
    }

    public static Font invertScale(Font font) {
        return font.deriveFont(font.getSize2D() / FONT_SCALE_FACTOR);
    }

    public static void showFrame() {
        Component component = UITools.getMenuComponent();
        if (component instanceof Window) {
            Window window = (Window)component;
            Window[] ownedWindows = window.getOwnedWindows();
            for (int i = 0; i < ownedWindows.length; ++i) {
                Window ownedWindow = ownedWindows[i];
                if (!ownedWindow.getClass().equals(FreeplaneSplashModern.class) || !ownedWindow.isVisible()) continue;
                ownedWindow.setVisible(false);
            }
            if (window != null && !window.isVisible()) {
                window.setVisible(true);
                window.toFront();
            }
        }
    }

    public static boolean isEditingText() {
        Component focusOwner = FocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean isTextComponentFocused = focusOwner instanceof JEditorPane;
        return isTextComponentFocused && focusOwner.isShowing() && ((JTextComponent)focusOwner).isEditable();
    }

    public static void executeWhenNodeHasFocus(final Runnable runnable) {
        final Component selectedComponent = Controller.getCurrentController().getMapViewManager().getSelectedComponent();
        if (selectedComponent != null && !selectedComponent.hasFocus()) {
            selectedComponent.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                }

                @Override
                public void focusGained(FocusEvent e) {
                    selectedComponent.removeFocusListener(this);
                    runnable.run();
                }
            });
            selectedComponent.requestFocusInWindow();
        } else {
            runnable.run();
        }
    }

    static {
        float factor = 1.0f;
        try {
            factor = UITools.getScaleFactor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        FONT_SCALE_FACTOR = factor;
    }

    public static final class InsertEolAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent c = (JTextComponent)e.getSource();
            c.replaceSelection("\n");
        }
    }
}

