/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.menu;

import java.awt.Container;
import javax.swing.JMenu;
import org.freeplane.core.ui.components.JFreeplaneMenuItem;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.ResourceAccessor;
import org.freeplane.core.util.TextUtils;

public class EmptyMenuItemBuilder
implements EntryVisitor {
    private final EntryAccessor entryAccessor;

    public EmptyMenuItemBuilder(ResourceAccessor resourceAccessor) {
        this.entryAccessor = new EntryAccessor(resourceAccessor);
    }

    @Override
    public void visit(Entry target) {
        Container container = this.getMenuItemContainer(target);
        if (container.getComponentCount() == 0) {
            String text = TextUtils.getText(target.getParent().getName() + ".noActions");
            JFreeplaneMenuItem noActionItem = new JFreeplaneMenuItem(text);
            noActionItem.setEnabled(false);
            this.entryAccessor.setComponent(target, noActionItem);
            container.add(noActionItem);
        }
    }

    private Container getMenuItemContainer(Entry target) {
        Container ancestorComponent = (Container)this.entryAccessor.getAncestorComponent(target);
        if (ancestorComponent instanceof JMenu) {
            return ((JMenu)ancestorComponent).getPopupMenu();
        }
        return ancestorComponent;
    }

    @Override
    public boolean shouldSkipChildren(Entry entry) {
        return true;
    }
}

