/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.ActionAcceleratorManager;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.IndexedTree;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.menubuilders.FreeplaneResourceAccessor;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.util.ActionUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.MModeController;

public class MenuUtils {
    public static DefaultMutableTreeNode createMenuEntryTree(String menuRootKey) {
        return new MenuEntryTreeBuilder().build(menuRootKey);
    }

    public static DefaultMutableTreeNode createAcceleratebleMenuEntryTree(String menuRootKey) {
        DefaultMutableTreeNode menuEntryTreeNode = MenuUtils.createMenuEntryTree(menuRootKey);
        DefaultMutableTreeNode result = new DefaultMutableTreeNode(menuEntryTreeNode.getUserObject());
        MenuUtils.addAcceleratableChildrenRecursively(result, menuEntryTreeNode.children());
        return result;
    }

    public static void insertAsNodeModelRecursively(NodeModel nodeModel, Enumeration children, MapController mapController) {
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            NodeModel newNodeModel = MenuUtils.insertAsNodeModel(nodeModel, child, mapController);
            if (child.isLeaf()) continue;
            MenuUtils.insertAsNodeModelRecursively(newNodeModel, child.children(), mapController);
        }
    }

    private static NodeModel insertAsNodeModel(NodeModel nodeModel, DefaultMutableTreeNode treeNode, MapController mapController) {
        MindIcon mindIcon;
        MenuEntry menuEntry = (MenuEntry)treeNode.getUserObject();
        String text = menuEntry.getKeyStroke() == null ? menuEntry.getLabel() : menuEntry.getLabel() + ": " + MenuUtils.formatKeyStroke(menuEntry.getKeyStroke());
        NodeModel newNodeModel = mapController.newNode(text, nodeModel.getMap());
        if (!treeNode.isLeaf()) {
            newNodeModel.setFolded(true);
        }
        if (menuEntry.getIconKey() != null && (mindIcon = menuEntry.createMindIcon()) != null) {
            newNodeModel.addIcon(mindIcon);
        }
        nodeModel.insert(newNodeModel);
        return newNodeModel;
    }

    private static void addAcceleratableChildrenRecursively(DefaultMutableTreeNode target, Enumeration sourceChildren) {
        while (sourceChildren.hasMoreElements()) {
            DefaultMutableTreeNode sourceChild = (DefaultMutableTreeNode)sourceChildren.nextElement();
            MenuEntry menuEntry = (MenuEntry)sourceChild.getUserObject();
            if (sourceChild.isLeaf()) {
                if (menuEntry.getKeyStroke() == null) continue;
                target.add(new DefaultMutableTreeNode(menuEntry));
                continue;
            }
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(menuEntry);
            target.add(newNode);
            MenuUtils.addAcceleratableChildrenRecursively(newNode, sourceChild.children());
            if (!newNode.isLeaf()) continue;
            target.remove(newNode);
        }
    }

    public static String formatKeyStroke(KeyStroke keyStroke) {
        String keyModifiersText = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
        String keyText = KeyEvent.getKeyText(keyStroke.getKeyCode());
        return keyModifiersText.length() == 0 ? keyText : keyModifiersText + "+" + keyText;
    }

    public static IndexedTree.Node findAssignedMenuItemNodeRecursively(DefaultMutableTreeNode menubarNode, KeyStroke keystroke) {
        Enumeration<TreeNode> children = menubarNode.children();
        while (children.hasMoreElements()) {
            JMenuItem childMenuItem;
            IndexedTree.Node child = (IndexedTree.Node)children.nextElement();
            Object childUserObject = child.getUserObject();
            if (childUserObject instanceof JMenuItem && keystroke.equals((childMenuItem = (JMenuItem)childUserObject).getAccelerator())) {
                return child;
            }
            IndexedTree.Node assignedMenuItemNode = MenuUtils.findAssignedMenuItemNodeRecursively(child, keystroke);
            if (assignedMenuItemNode == null) continue;
            return assignedMenuItemNode;
        }
        return null;
    }

    public static void executeMenuItems(List<String> menuItemKeys) {
        LogUtils.info("menu items to execute: " + menuItemKeys);
        Entry genericMenuStructure = MenuUtils.genericMenuStructure();
        EntryAccessor entryAccessor = new EntryAccessor(new FreeplaneResourceAccessor());
        for (String menuItemKey : menuItemKeys) {
            AFreeplaneAction action;
            Entry menuItem = genericMenuStructure.findEntry(menuItemKey);
            AFreeplaneAction aFreeplaneAction = action = menuItem != null ? entryAccessor.getAction(menuItem) : null;
            if (action == null) {
                UITools.errorMessage(TextUtils.format("MenuUtils.invalid_menuitem", menuItemKey));
                return;
            }
            LogUtils.info("executing " + ActionUtils.getActionTitle(action) + "(" + menuItemKey + ")");
            ActionEvent e = new ActionEvent(menuItem, 0, null);
            action.actionPerformed(e);
        }
    }

    public static Icon getMenuItemIcon(String menuItemKey) {
        Entry menuItem = MenuUtils.genericMenuStructure().findEntry(menuItemKey);
        if (menuItem == null) {
            return null;
        }
        EntryAccessor entryAccessor = new EntryAccessor(new FreeplaneResourceAccessor());
        AFreeplaneAction action = entryAccessor.getAction(menuItem);
        return (Icon)action.getValue("SmallIcon");
    }

    private static IUserInputListenerFactory userInputFactory() {
        MModeController modeController = (MModeController)Controller.getCurrentModeController();
        return modeController.getUserInputListenerFactory();
    }

    private static Entry genericMenuStructure() {
        return MenuUtils.userInputFactory().getGenericMenuStructure();
    }

    public static class MenuEntryTreeBuilder {
        private final ActionAcceleratorManager acceleratorManager = ResourceController.getResourceController().getAcceleratorManager();

        private MenuEntryTreeBuilder() {
        }

        private DefaultMutableTreeNode build(String menuRootKey) {
            Entry entry = MenuUtils.genericMenuStructure().findEntry(menuRootKey);
            if (entry == null) {
                throw new IllegalArgumentException("not found: menuRootKey=" + menuRootKey);
            }
            DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode(this.menuNode2menuEntryNode(entry));
            this.addChildrenRecursively(treeRoot, entry.children());
            return treeRoot;
        }

        private void addChildrenRecursively(DefaultMutableTreeNode treeNode, Iterable<Entry> menuElements) {
            for (Entry childMenu : menuElements) {
                DefaultMutableTreeNode treeChild = this.menuNode2menuEntryNode(childMenu);
                if (treeChild != null) {
                    this.addChildrenRecursively(treeChild, childMenu.children());
                    if (!this.entryIsActionOrIsSubmenu(childMenu, treeChild)) continue;
                    treeNode.add(treeChild);
                    continue;
                }
                this.addChildrenRecursively(treeNode, childMenu.children());
            }
        }

        private boolean entryIsActionOrIsSubmenu(Entry childMenu, DefaultMutableTreeNode treeChild) {
            return !treeChild.isLeaf() || childMenu.isLeaf();
        }

        private DefaultMutableTreeNode menuNode2menuEntryNode(Entry menuItem) {
            EntryAccessor entryAccessor = new EntryAccessor(new FreeplaneResourceAccessor());
            AFreeplaneAction action = entryAccessor.getAction(menuItem);
            String name = menuItem.getName();
            if (menuItem.hasChildren() && StringUtils.isNotEmpty((String)name)) {
                String text = TextUtils.removeMnemonic(entryAccessor.getText(menuItem));
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(new MenuEntry(name, text));
                if (action != null) {
                    MenuEntry menuEntry = this.menuEntry(action);
                    node.add(new DefaultMutableTreeNode(menuEntry));
                }
                return node;
            }
            if (action != null) {
                MenuEntry menuEntry = this.menuEntry(action);
                return new DefaultMutableTreeNode(menuEntry);
            }
            return null;
        }

        private MenuEntry menuEntry(AFreeplaneAction action) {
            String text = ActionUtils.getActionTitle(action);
            String iconKey = action.getIconKey();
            String tooltip = (String)action.getValue("LongDescription");
            KeyStroke accelerator = this.acceleratorManager.getAccelerator(action);
            MenuEntry menuEntry = new MenuEntry(action.getKey(), text, iconKey, accelerator, tooltip);
            return menuEntry;
        }
    }

    public static class MenuEntry {
        private final String key;
        private final String label;
        private final String iconKey;
        private final KeyStroke keyStroke;
        private final String toolTipText;

        public MenuEntry(String key, String label, String iconKey, KeyStroke keyStroke, String toolTipText) {
            this.key = key;
            this.label = label;
            this.iconKey = iconKey;
            this.keyStroke = keyStroke;
            this.toolTipText = toolTipText;
        }

        public MenuEntry(String key, String label) {
            this(key, label, null, null, null);
        }

        public String getKey() {
            return this.key;
        }

        public String getLabel() {
            return this.label;
        }

        public String getIconKey() {
            return this.iconKey;
        }

        public KeyStroke getKeyStroke() {
            return this.keyStroke;
        }

        public String getToolTipText() {
            return this.toolTipText;
        }

        public MindIcon createMindIcon() {
            String resource = ResourceController.getResourceController().getProperty(this.iconKey, null);
            if (resource == null) {
                return null;
            }
            return new MindIcon(resource.replaceAll("/images/(.*).png", "../$1"));
        }

        public String toString() {
            return this.label;
        }
    }
}

