/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.edge;

import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.components.OptionalDontShowMeAgainDialog;
import org.freeplane.features.edge.AutomaticEdgeColor;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.edge.EdgeModel;
import org.freeplane.features.edge.mindmapmode.MEdgeController;
import org.freeplane.features.map.AMapChangeListenerAdapter;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeMoveEvent;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.NodeHookDescriptor;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.styles.AutomaticLayoutController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.LogicalStyleModel;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.n3.nanoxml.XMLElement;

@NodeHookDescriptor(hookName="AutomaticEdgeColor")
public class AutomaticEdgeColorHook
extends PersistentNodeHook
implements IExtension {
    private ModeController modeController;

    public AutomaticEdgeColorHook() {
        Listener listener = new Listener();
        this.modeController = Controller.getCurrentModeController();
        this.modeController.addExtension(AutomaticEdgeColorHook.class, this);
        MapController mapController = this.modeController.getMapController();
        mapController.addMapChangeListener(listener);
    }

    @Override
    protected void registerActions() {
    }

    @Override
    protected Class<? extends IExtension> getExtensionClass() {
        return AutomaticEdgeColor.class;
    }

    @Override
    protected IExtension createExtension(NodeModel node, XMLElement element) {
        int colorCount = element == null ? 0 : element.getAttribute("COUNTER", 0);
        AutomaticEdgeColor.Rule rule = element == null ? AutomaticEdgeColor.Rule.ON_BRANCH_CREATION : AutomaticEdgeColorHook.safeValueOf(element.getAttribute("RULE", null), AutomaticEdgeColor.Rule.ON_BRANCH_CREATION);
        return new AutomaticEdgeColor(rule, colorCount);
    }

    public static <T extends Enum<T>> T safeValueOf(String value, T defaultValue) {
        try {
            return (T)(value == null ? defaultValue : Enum.valueOf(defaultValue.getClass(), value));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    protected void saveExtension(IExtension extension, XMLElement element) {
        AutomaticEdgeColor automaticEdgeColor = (AutomaticEdgeColor)extension;
        super.saveExtension(extension, element);
        int colorCount = automaticEdgeColor.getColorCounter();
        element.setAttribute("COUNTER", Integer.toString(colorCount));
        element.setAttribute("RULE", automaticEdgeColor.rule.toString());
    }

    @Override
    protected IExtension toggle(NodeModel node, IExtension extension) {
        extension = super.toggle(node, extension);
        MModeController modeController = (MModeController)Controller.getCurrentModeController();
        if (modeController.isUndoAction()) {
            return extension;
        }
        LogicalStyleController.getController().refreshMap(node.getMap());
        return extension;
    }

    private class Listener
    extends AMapChangeListenerAdapter {
        private Listener() {
        }

        @Override
        public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
            if (!this.isActiveOnCreation(child) || AutomaticEdgeColorHook.this.modeController.isUndoAction()) {
                return;
            }
            if (MapStyleModel.FLOATING_STYLE.equals(LogicalStyleModel.getStyle(child))) {
                return;
            }
            if (parent.isRoot()) {
                EdgeModel edgeModel = EdgeModel.createEdgeModel(child);
                if (null == edgeModel.getColor()) {
                    MEdgeController controller = (MEdgeController)EdgeController.getController();
                    AutomaticEdgeColor model = (AutomaticEdgeColor)AutomaticEdgeColorHook.this.getMapHook(parent.getMap());
                    model.increaseColorCounter();
                    int colorCounter = model.getColorCounter();
                    AutomaticLayoutController automaticLatoutController = AutomaticEdgeColorHook.this.modeController.getExtension(AutomaticLayoutController.class);
                    NodeModel styleNode = automaticLatoutController.getStyleNode(parent.getMap(), colorCounter, true);
                    if (styleNode != null) {
                        controller.setColor(child, controller.getColor(styleNode));
                    }
                }
            } else {
                MEdgeController controller = (MEdgeController)EdgeController.getController();
                controller.setColor(child, null);
                boolean edgeStylesEquals = controller.getColor(child).equals(controller.getColor(parent));
                if (!edgeStylesEquals) {
                    OptionalDontShowMeAgainDialog.show("edge_is_formatted_by_style", "confirmation", "ignore_edge_format_by_style", 2);
                }
            }
        }

        private boolean isActiveOnCreation(NodeModel node) {
            AutomaticEdgeColor extension = node.getMap().getRootNode().getExtension(AutomaticEdgeColor.class);
            return extension != null && extension.rule.isActiveOnCreation;
        }

        @Override
        public void onNodeMoved(NodeMoveEvent nodeMoveEvent) {
            this.onNodeInserted(nodeMoveEvent.newParent, nodeMoveEvent.child, nodeMoveEvent.newIndex);
        }
    }
}

