/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.format;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TypeReference;
import org.freeplane.features.format.DatePatternFormat;
import org.freeplane.features.format.DecimalPatternFormat;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.FormatterPatternFormat;
import org.freeplane.features.format.IdentityPatternFormat;
import org.freeplane.features.format.StandardPatternFormat;
import org.freeplane.features.mode.Controller;
import org.freeplane.n3.nanoxml.XMLElement;

public abstract class PatternFormat {
    private static final String SERIALIZATION_SEPARATOR = ":";
    public static final String IDENTITY_PATTERN = "NO_FORMAT";
    public static final String STANDARD_FORMAT_PATTERN = "STANDARD_FORMAT";
    private static final PatternFormat IDENTITY = new IdentityPatternFormat();
    private static final PatternFormat STANDARD = new StandardPatternFormat();
    static final String STYLE_FORMATTER = "formatter";
    static final String STYLE_DATE = "date";
    static final String STYLE_DECIMAL = "decimal";
    static final String TYPE_IDENTITY = "identity";
    static final String TYPE_STANDARD = "standard";
    private static final String ELEMENT_NAME = "format";
    private final String type;
    private final String pattern;
    private String name;
    private Locale locale;
    static final Pattern datePattern = Pattern.compile("yy|[Hh]{1,2}:mm");
    static final Pattern formatterPattern = Pattern.compile("%(?:[-#+ 0,(]+)?(?:[\\d.]+)?([sSdoxXeEfgGaA]|[tT][HIklMSLNpzZsQBbhAaCYyjmdeRTrDFc])");

    public PatternFormat(String pattern, String type) {
        this.pattern = pattern;
        this.type = type;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public abstract String getStyle();

    public static PatternFormat guessPatternFormat(String pattern) {
        try {
            if (pattern == null || pattern.length() == 0) {
                return null;
            }
            Matcher matcher = formatterPattern.matcher(pattern);
            if (matcher.find()) {
                char conversion = matcher.group(1).charAt(0);
                if (matcher.find()) {
                    LogUtils.warn("found multiple formats in this formatter pattern: '" + pattern + "'");
                    return null;
                }
                switch (conversion) {
                    case 'S': 
                    case 's': {
                        return new FormatterPatternFormat(pattern, "string");
                    }
                    case 'A': 
                    case 'E': 
                    case 'G': 
                    case 'X': 
                    case 'a': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'o': 
                    case 'x': {
                        return new FormatterPatternFormat(pattern, "number");
                    }
                    case 'T': 
                    case 't': {
                        return new FormatterPatternFormat(pattern, STYLE_DATE);
                    }
                }
            }
            if (datePattern.matcher(pattern).find()) {
                return new DatePatternFormat(pattern);
            }
            if (pattern.indexOf(35) != -1 || pattern.indexOf(48) != -1) {
                return new DecimalPatternFormat(pattern);
            }
            for (PatternFormat f : Controller.getCurrentController().getExtension(FormatController.class).getSpecialFormats()) {
                if (!pattern.equals(f.getPattern())) continue;
                return f;
            }
            LogUtils.warn("not a pattern format: '" + pattern + "'");
            return null;
        }
        catch (Exception e) {
            LogUtils.warn("can't build a formatter for this pattern '" + pattern + "'", e);
            return null;
        }
    }

    public static PatternFormat getIdentityPatternFormat() {
        return IDENTITY;
    }

    public static PatternFormat getStandardPatternFormat() {
        return STANDARD;
    }

    public XMLElement toXml() {
        XMLElement xmlElement = new XMLElement(ELEMENT_NAME);
        xmlElement.setAttribute("type", this.getType());
        xmlElement.setAttribute("style", this.getStyle());
        if (this.getName() != null) {
            xmlElement.setAttribute("name", this.getName());
        }
        if (this.getLocale() != null) {
            xmlElement.setAttribute("locale", this.getLocale().toString());
        }
        xmlElement.setContent(this.getPattern());
        return xmlElement;
    }

    public String serialize() {
        return this.getType() + SERIALIZATION_SEPARATOR + this.getStyle() + SERIALIZATION_SEPARATOR + TypeReference.encode(this.getPattern());
    }

    public static PatternFormat deserialize(String string) {
        String[] tokens = string.split(SERIALIZATION_SEPARATOR, 3);
        return FormatController.getController().createFormat(TypeReference.decode(tokens[2]), tokens[1], tokens[0]);
    }

    public boolean acceptsDate() {
        return this.getType().equals(STYLE_DATE) || this.getPattern().equals(STANDARD_FORMAT_PATTERN);
    }

    public boolean acceptsNumber() {
        return this.getType().equals("number") || this.getPattern().equals(STANDARD_FORMAT_PATTERN);
    }

    public boolean acceptsString() {
        return this.getType().equals("string") || this.getPattern().equals(STANDARD_FORMAT_PATTERN);
    }

    public abstract Object formatObject(Object var1);

    public int hashCode() {
        String style = this.getStyle();
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        result = 31 * result + (style == null ? 0 : style.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatternFormat other = (PatternFormat)obj;
        if (this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern)) {
            return false;
        }
        String style = this.getStyle();
        if (style == null ? other.getStyle() != null : !style.equals(other.getStyle())) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return this.pattern;
    }

    public boolean canFormat(Class<?> clazz) {
        return true;
    }
}

