/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.link.ConnectorLabelCondition;
import org.freeplane.features.link.ConnectorModel;

public class ConnectorLabelContainsCondition
extends ConnectorLabelCondition {
    public static final String NAME = "connector_label_contains";

    public ConnectorLabelContainsCondition(String text, boolean matchCase, boolean matchApproximately) {
        super(text, matchCase, matchApproximately);
    }

    @Override
    protected boolean checkLink(ConnectorModel connector) {
        String middleLabel = connector.getMiddleLabel();
        if (this.contains(middleLabel)) {
            return true;
        }
        String sourceLabel = connector.getSourceLabel();
        if (this.contains(sourceLabel)) {
            return true;
        }
        String targetLabel = connector.getTargetLabel();
        return this.contains(targetLabel);
    }

    private boolean contains(String middleLabel) {
        if (middleLabel == null) {
            return false;
        }
        return this.getStringMatchingStrategy().matches(this.getText(), middleLabel, true, this.matchCase());
    }

    @Override
    protected String createDescription() {
        String condition = TextUtils.getText("connector_label");
        String simpleCondition = TextUtils.getText("filter_contains");
        return ConditionFactory.createDescription(condition, simpleCondition, this.getText(), this.matchCase(), this.matchApproximately());
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

