/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionSnapshotFactory;
import org.freeplane.features.map.CloneOfSelectedViewSnapshotCondition;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.n3.nanoxml.XMLElement;

public class CloneOfSelectedViewCondition
extends ASelectableCondition
implements ConditionSnapshotFactory {
    static final String NAME = "clone_condition";
    private static String description;

    public static ASelectableCondition CreateCondition() {
        return new CloneOfSelectedViewCondition();
    }

    @Override
    public boolean checkNode(NodeModel node) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection != null) {
            for (NodeModel clone : node.allClones()) {
                if (!selection.isSelected(clone)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected String createDescription() {
        if (description == null) {
            description = TextUtils.getText("filter_clones");
        }
        return description;
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    public void toXml(XMLElement element) {
    }

    public static ASelectableCondition load(XMLElement element) {
        return new CloneOfSelectedViewCondition();
    }

    @Override
    public ASelectableCondition createSnapshotCondition() {
        return new CloneOfSelectedViewSnapshotCondition(Controller.getCurrentController().getSelection().getSelection());
    }
}

