/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodestyle;

import java.awt.Color;
import java.io.IOException;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.BackwardCompatibleQuantityWriter;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.IAttributeWriter;
import org.freeplane.core.io.IElementDOMHandler;
import org.freeplane.core.io.IElementWriter;
import org.freeplane.core.io.IExtensionAttributeWriter;
import org.freeplane.core.io.IExtensionElementWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.ui.LengthUnits;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.core.util.Quantity;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeWriter;
import org.freeplane.features.nodestyle.NodeSizeModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.ShapeConfigurationModel;
import org.freeplane.n3.nanoxml.XMLElement;

class NodeStyleBuilder
implements IElementDOMHandler,
IExtensionElementWriter,
IExtensionAttributeWriter,
IAttributeWriter,
IElementWriter {
    private final NodeStyleController nsc;

    public NodeStyleBuilder(NodeStyleController nsc) {
        this.nsc = nsc;
    }

    @Override
    public Object createElement(Object parent, String tag, XMLElement attributes) {
        if (tag.equals("font")) {
            return new FontProperties();
        }
        return null;
    }

    @Override
    public void endElement(Object parent, String tag, Object userObject, XMLElement dom) {
        if (parent instanceof NodeModel) {
            NodeModel node = (NodeModel)parent;
            if (tag.equals("font")) {
                FontProperties fp = (FontProperties)userObject;
                NodeStyleModel nodeStyleModel = NodeStyleModel.getModel(node);
                if (nodeStyleModel == null) {
                    nodeStyleModel = new NodeStyleModel();
                    node.addExtension(nodeStyleModel);
                }
                nodeStyleModel.setFontFamilyName(fp.fontName);
                nodeStyleModel.setFontSize(fp.fontSize);
                nodeStyleModel.setItalic(fp.isItalic);
                nodeStyleModel.setBold(fp.isBold);
                return;
            }
            return;
        }
    }

    private void registerAttributeHandlers(ReadManager reader) {
        IAttributeHandler colorHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                NodeStyleModel.setColor(node, ColorUtils.stringToColor(value, NodeStyleModel.getColor(node)));
            }
        };
        IAttributeHandler alphaHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                NodeStyleModel.setColor(node, ColorUtils.alphaToColor(value, NodeStyleModel.getColor(node)));
            }
        };
        reader.addAttributeHandler("node", "COLOR", colorHandler);
        reader.addAttributeHandler("node", "ALPHA", alphaHandler);
        reader.addAttributeHandler("stylenode", "COLOR", colorHandler);
        reader.addAttributeHandler("stylenode", "ALPHA", alphaHandler);
        IAttributeHandler bgHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                NodeStyleModel.setBackgroundColor(node, ColorUtils.stringToColor(value, NodeStyleModel.getBackgroundColor(node)));
            }
        };
        IAttributeHandler bgAlphaHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                NodeStyleModel.setBackgroundColor(node, ColorUtils.alphaToColor(value, NodeStyleModel.getBackgroundColor(node)));
            }
        };
        reader.addAttributeHandler("node", "BACKGROUND_COLOR", bgHandler);
        reader.addAttributeHandler("node", "BACKGROUND_ALPHA", bgAlphaHandler);
        reader.addAttributeHandler("stylenode", "BACKGROUND_COLOR", bgHandler);
        reader.addAttributeHandler("stylenode", "BACKGROUND_ALPHA", bgAlphaHandler);
        IAttributeHandler shapeHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                NodeStyleModel.setShape(node, value);
            }
        };
        reader.addAttributeHandler("node", "STYLE", shapeHandler);
        reader.addAttributeHandler("stylenode", "STYLE", shapeHandler);
        IAttributeHandler shapeHorizontalMarginHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                NodeStyleModel.setShapeHorizontalMargin(node, Quantity.fromString(value, LengthUnits.px));
            }
        };
        reader.addAttributeHandler("node", "SHAPE_HORIZONTAL_MARGIN", shapeHorizontalMarginHandler);
        reader.addAttributeHandler("stylenode", "SHAPE_HORIZONTAL_MARGIN", shapeHorizontalMarginHandler);
        IAttributeHandler shapeVerticalMarginHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                NodeStyleModel.setShapeVerticalMargin(node, Quantity.fromString(value, LengthUnits.px));
            }
        };
        reader.addAttributeHandler("node", "SHAPE_VERTICAL_MARGIN", shapeVerticalMarginHandler);
        reader.addAttributeHandler("stylenode", "SHAPE_VERTICAL_MARGIN", shapeVerticalMarginHandler);
        IAttributeHandler uniformShapeHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                NodeStyleModel.setShapeUniform(node, Boolean.valueOf(value));
            }
        };
        reader.addAttributeHandler("node", "UNIFORM_SHAPE", uniformShapeHandler);
        reader.addAttributeHandler("stylenode", "UNIFORM_SHAPE", uniformShapeHandler);
        reader.addAttributeHandler("font", "SIZE", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                FontProperties fp = (FontProperties)userObject;
                fp.fontSize = Integer.parseInt(value.toString());
            }
        });
        reader.addAttributeHandler("font", "NAME", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                FontProperties fp = (FontProperties)userObject;
                fp.fontName = value;
            }
        });
        reader.addAttributeHandler("font", "BOLD", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                FontProperties fp = (FontProperties)userObject;
                fp.isBold = value.equals("true");
            }
        });
        reader.addAttributeHandler("font", "ITALIC", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                FontProperties fp = (FontProperties)userObject;
                fp.isItalic = value.equals("true");
            }
        });
        IAttributeHandler nodenumberingHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                NodeStyleModel.setNodeNumbering(node, value.equals("true"));
            }
        };
        reader.addAttributeHandler("node", "NUMBERED", nodenumberingHandler);
        reader.addAttributeHandler("stylenode", "NUMBERED", nodenumberingHandler);
        IAttributeHandler formatHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                NodeStyleModel.setNodeFormat(node, value);
            }
        };
        reader.addAttributeHandler("node", "FORMAT", formatHandler);
        reader.addAttributeHandler("stylenode", "FORMAT", formatHandler);
        if (FreeplaneVersion.getVersion().isOlderThan(new FreeplaneVersion(1, 3, 0))) {
            reader.addAttributeHandler("node", "TEMPLATE", formatHandler);
            reader.addAttributeHandler("stylenode", "TEMPLATE", formatHandler);
        }
        final IAttributeHandler nodeMaxNodeWidthQuantityHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                Quantity<LengthUnits> width = Quantity.fromString(value, LengthUnits.px);
                NodeSizeModel.setMaxNodeWidth(node, width);
            }
        };
        reader.addAttributeHandler("node", "MAX_WIDTH_QUANTITY", nodeMaxNodeWidthQuantityHandler);
        reader.addAttributeHandler("stylenode", "MAX_WIDTH_QUANTITY", nodeMaxNodeWidthQuantityHandler);
        IAttributeHandler nodeMaxNodeWidthHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                if (NodeSizeModel.getMaxNodeWidth(node) == null) {
                    nodeMaxNodeWidthQuantityHandler.setAttribute(node, value);
                }
            }
        };
        reader.addAttributeHandler("node", "MAX_WIDTH", nodeMaxNodeWidthHandler);
        reader.addAttributeHandler("stylenode", "MAX_WIDTH", nodeMaxNodeWidthHandler);
        final IAttributeHandler nodeMinNodeWidthQuantityHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                Quantity<LengthUnits> width = Quantity.fromString(value, LengthUnits.px);
                NodeSizeModel.setNodeMinWidth(node, width);
            }
        };
        reader.addAttributeHandler("node", "MIN_WIDTH_QUANTITY", nodeMinNodeWidthQuantityHandler);
        reader.addAttributeHandler("stylenode", "MIN_WIDTH_QUANTITY", nodeMinNodeWidthQuantityHandler);
        IAttributeHandler nodeMinWidthHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                if (NodeSizeModel.getMinNodeWidth(node) == null) {
                    nodeMinNodeWidthQuantityHandler.setAttribute(node, value);
                }
            }
        };
        reader.addAttributeHandler("node", "MIN_WIDTH", nodeMinWidthHandler);
        reader.addAttributeHandler("stylenode", "MIN_WIDTH", nodeMinWidthHandler);
        IAttributeHandler textAlignHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                NodeStyleModel.setTextAlign(node, NodeStyleModel.TextAlign.valueOf(value));
            }
        };
        reader.addAttributeHandler("node", "TEXT_ALIGN", textAlignHandler);
        reader.addAttributeHandler("stylenode", "TEXT_ALIGN", textAlignHandler);
    }

    public void registerBy(ReadManager reader, WriteManager writer) {
        reader.addElementHandler("font", this);
        this.registerAttributeHandlers(reader);
        writer.addAttributeWriter("node", this);
        writer.addAttributeWriter("stylenode", this);
        writer.addElementWriter("node", this);
        writer.addElementWriter("stylenode", this);
        writer.addExtensionElementWriter(NodeStyleModel.class, this);
        writer.addExtensionAttributeWriter(NodeStyleModel.class, this);
        writer.addExtensionAttributeWriter(NodeSizeModel.class, this);
    }

    public void setAttributes(String tag, Object node, XMLElement attributes) {
    }

    @Override
    public void writeAttributes(ITreeWriter writer, Object userObject, String tag) {
        boolean forceFormatting = Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.FORCE_FORMATTING));
        if (!forceFormatting) {
            return;
        }
        NodeModel node = (NodeModel)userObject;
        this.writeAttributes(writer, node, (NodeStyleModel)null, true);
        this.writeAttributes(writer, node, (NodeSizeModel)null, true);
    }

    @Override
    public void writeAttributes(ITreeWriter writer, Object userObject, IExtension extension) {
        boolean forceFormatting = Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.FORCE_FORMATTING));
        if (forceFormatting) {
            return;
        }
        if (extension instanceof NodeStyleModel) {
            NodeStyleModel style = (NodeStyleModel)extension;
            this.writeAttributes(writer, null, style, false);
            return;
        }
        if (extension instanceof NodeSizeModel) {
            NodeSizeModel size = (NodeSizeModel)extension;
            this.writeAttributes(writer, null, size, false);
            return;
        }
    }

    private void writeAttributes(ITreeWriter writer, NodeModel node, NodeStyleModel style, boolean forceFormatting) {
        NodeStyleModel.TextAlign textAlign;
        String format;
        Boolean numbered;
        boolean uniformShape;
        Quantity<LengthUnits> shapeVerticalMargin;
        Quantity<LengthUnits> shapeHorizontalMargin;
        ShapeConfigurationModel shapeConfiguration;
        NodeStyleModel.Shape shape;
        Color backgroundColor;
        Color color;
        Color color2 = color = forceFormatting ? this.nsc.getColor(node) : style.getColor();
        if (color != null) {
            ColorUtils.addColorAttributes(writer, "COLOR", "ALPHA", color);
        }
        Color color3 = backgroundColor = forceFormatting ? this.nsc.getBackgroundColor(node) : style.getBackgroundColor();
        if (backgroundColor != null) {
            ColorUtils.addColorAttributes(writer, "BACKGROUND_COLOR", "BACKGROUND_ALPHA", backgroundColor);
        }
        if ((shape = (shapeConfiguration = forceFormatting ? this.nsc.getShapeConfiguration(node) : style.getShapeConfiguration()).getShape()) != null) {
            writer.addAttribute("STYLE", shape.toString());
        }
        if (!(shapeHorizontalMargin = shapeConfiguration.getHorizontalMargin()).equals(ShapeConfigurationModel.DEFAULT_MARGIN)) {
            BackwardCompatibleQuantityWriter.forWriter(writer).writeQuantity("SHAPE_HORIZONTAL_MARGIN", shapeHorizontalMargin);
        }
        if (!(shapeVerticalMargin = shapeConfiguration.getVerticalMargin()).equals(ShapeConfigurationModel.DEFAULT_MARGIN)) {
            BackwardCompatibleQuantityWriter.forWriter(writer).writeQuantity("SHAPE_VERTICAL_MARGIN", shapeVerticalMargin);
        }
        if (uniformShape = shapeConfiguration.isUniform()) {
            writer.addAttribute("UNIFORM_SHAPE", "true");
        }
        Boolean bl = numbered = forceFormatting ? this.nsc.getNodeNumbering(node) : style.getNodeNumbering();
        if (numbered != null && numbered.booleanValue()) {
            writer.addAttribute("NUMBERED", numbered.toString());
        }
        String string = format = forceFormatting ? this.nsc.getNodeFormat(node) : style.getNodeFormat();
        if (format != null) {
            writer.addAttribute("FORMAT", format);
        }
        NodeStyleModel.TextAlign textAlign2 = textAlign = forceFormatting ? this.nsc.getTextAlign(node) : style.getTextAlign();
        if (textAlign != null) {
            writer.addAttribute("TEXT_ALIGN", textAlign.toString());
        }
    }

    private void writeAttributes(ITreeWriter writer, NodeModel node, NodeSizeModel size, boolean forceFormatting) {
        Quantity<LengthUnits> minTextWidth;
        Quantity<LengthUnits> maxTextWidth;
        Quantity<LengthUnits> quantity = maxTextWidth = forceFormatting ? this.nsc.getMaxWidth(node) : size.getMaxNodeWidth();
        if (maxTextWidth != null) {
            BackwardCompatibleQuantityWriter.forWriter(writer).writeQuantity("MAX_WIDTH", maxTextWidth);
        }
        Quantity<LengthUnits> quantity2 = minTextWidth = forceFormatting ? this.nsc.getMinWidth(node) : size.getMinNodeWidth();
        if (minTextWidth != null) {
            BackwardCompatibleQuantityWriter.forWriter(writer).writeQuantity("MIN_WIDTH", minTextWidth);
        }
    }

    @Override
    public void writeContent(ITreeWriter writer, Object userObject, String tag) throws IOException {
        boolean forceFormatting = Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.FORCE_FORMATTING));
        if (!forceFormatting) {
            return;
        }
        NodeModel node = (NodeModel)userObject;
        this.writeContent(writer, node, null, true);
    }

    @Override
    public void writeContent(ITreeWriter writer, Object userObject, IExtension extension) throws IOException {
        boolean forceFormatting = Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.FORCE_FORMATTING));
        if (forceFormatting) {
            return;
        }
        NodeStyleModel style = (NodeStyleModel)extension;
        this.writeContent(writer, null, style, false);
    }

    private void writeContent(ITreeWriter writer, NodeModel node, NodeStyleModel style, boolean forceFormatting) throws IOException {
        if (!NodeWriter.shouldWriteSharedContent(writer)) {
            return;
        }
        if (forceFormatting || style != null) {
            Boolean italic;
            Boolean bold;
            Integer fontSize;
            String fontFamilyName;
            XMLElement fontElement = new XMLElement();
            fontElement.setName("font");
            boolean isRelevant = forceFormatting;
            String string = fontFamilyName = forceFormatting ? this.nsc.getFontFamilyName(node) : style.getFontFamilyName();
            if (fontFamilyName != null) {
                fontElement.setAttribute("NAME", fontFamilyName);
                isRelevant = true;
            }
            Integer n = fontSize = forceFormatting ? Integer.valueOf(this.nsc.getFontSize(node)) : style.getFontSize();
            if (fontSize != null) {
                fontElement.setAttribute("SIZE", Integer.toString(fontSize));
                isRelevant = true;
            }
            Boolean bl = bold = forceFormatting ? Boolean.valueOf(this.nsc.isBold(node)) : style.isBold();
            if (bold != null) {
                fontElement.setAttribute("BOLD", bold != false ? "true" : "false");
                isRelevant = true;
            }
            Boolean bl2 = italic = forceFormatting ? Boolean.valueOf(this.nsc.isItalic(node)) : style.isItalic();
            if (italic != null) {
                fontElement.setAttribute("ITALIC", italic != false ? "true" : "false");
                isRelevant = true;
            }
            if (isRelevant) {
                writer.addElement((Object)style, fontElement);
            }
        }
    }

    static class FontProperties {
        String fontName;
        Integer fontSize;
        Boolean isBold;
        Boolean isItalic;

        FontProperties() {
        }
    }
}

