/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodestyle;

import org.freeplane.core.ui.LengthUnits;
import org.freeplane.core.util.Quantity;
import org.freeplane.features.nodestyle.NodeStyleModel;

public class ShapeConfigurationModel {
    private final NodeStyleModel.Shape shape;
    private final Quantity<LengthUnits> horizontalMargin;
    private final Quantity<LengthUnits> verticalMargin;
    private final boolean isUniform;
    public static final Quantity<LengthUnits> DEFAULT_MARGIN = new Quantity<LengthUnits>(2.0, LengthUnits.pt);
    public static ShapeConfigurationModel NULL_SHAPE = new ShapeConfigurationModel(null, DEFAULT_MARGIN, DEFAULT_MARGIN, false);
    public static final ShapeConfigurationModel AS_PARENT = NULL_SHAPE.withShape(NodeStyleModel.Shape.as_parent);
    public static final ShapeConfigurationModel FORK = NULL_SHAPE.withShape(NodeStyleModel.Shape.fork);
    private static final Quantity<LengthUnits> DEFAULT_HORIZONTAL_OVAL_MARGIN = new Quantity<LengthUnits>(6.0, LengthUnits.pt);
    private static final Quantity<LengthUnits> DEFAULT_VERTICAL_OVAL_MARGIN = new Quantity<LengthUnits>(12.0, LengthUnits.pt);
    public static final ShapeConfigurationModel DEFAULT_ROOT_OVAL = NULL_SHAPE.withShape(NodeStyleModel.Shape.oval).withHorizontalMargin(DEFAULT_HORIZONTAL_OVAL_MARGIN).withVerticalMargin(DEFAULT_VERTICAL_OVAL_MARGIN);

    private ShapeConfigurationModel(NodeStyleModel.Shape shape, Quantity<LengthUnits> horizontalMargin, Quantity<LengthUnits> verticalMargin, boolean isUniform) {
        this.shape = shape;
        this.horizontalMargin = horizontalMargin;
        this.verticalMargin = verticalMargin;
        this.isUniform = isUniform;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.horizontalMargin == null ? 0 : this.horizontalMargin.hashCode());
        result = 31 * result + (this.isUniform ? 1231 : 1237);
        result = 31 * result + (this.shape == null ? 0 : this.shape.hashCode());
        result = 31 * result + (this.verticalMargin == null ? 0 : this.verticalMargin.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShapeConfigurationModel other = (ShapeConfigurationModel)obj;
        if (this.shape != other.shape) {
            return false;
        }
        if (this.isUniform != other.isUniform) {
            return false;
        }
        if (!this.horizontalMargin.equals(other.horizontalMargin)) {
            return false;
        }
        return this.verticalMargin.equals(other.verticalMargin);
    }

    public NodeStyleModel.Shape getShape() {
        return this.shape;
    }

    public Quantity<LengthUnits> getHorizontalMargin() {
        return this.horizontalMargin;
    }

    public Quantity<LengthUnits> getVerticalMargin() {
        return this.verticalMargin;
    }

    public boolean isUniform() {
        return this.isUniform;
    }

    public ShapeConfigurationModel withShape(NodeStyleModel.Shape shape) {
        return new ShapeConfigurationModel(shape, this.horizontalMargin, this.verticalMargin, this.isUniform);
    }

    public ShapeConfigurationModel withHorizontalMargin(Quantity<LengthUnits> horizontalMargin) {
        return new ShapeConfigurationModel(this.shape, horizontalMargin, this.verticalMargin, this.isUniform);
    }

    public ShapeConfigurationModel withVerticalMargin(Quantity<LengthUnits> verticalMargin) {
        return new ShapeConfigurationModel(this.shape, this.horizontalMargin, verticalMargin, this.isUniform);
    }

    public ShapeConfigurationModel withUniform(boolean isUniform) {
        return new ShapeConfigurationModel(this.shape, this.horizontalMargin, this.verticalMargin, isUniform);
    }
}

