/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.note;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.net.URL;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.html.CssRuleBuilder;
import org.freeplane.features.icon.IStateIconProvider;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.ITooltipProvider;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeSizeModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.note.NoteBuilder;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.note.NoteWriter;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.text.TextController;

public class NoteController
implements IExtension {
    private static boolean firstRun = true;
    public static final String NODE_NOTE_ICON = "accessories.plugins.NodeNoteIcon";
    private static UIIcon noteIcon;
    public static URL bwNoteIconUrl;
    public static final String SHOW_NOTE_ICONS = "show_note_icons";
    private static final Integer NOTE_TOOLTIP;
    public static final String SHOW_NOTES_IN_MAP = "show_notes_in_map";
    private final ModeController modeController;

    public static NoteController getController() {
        ModeController modeController = Controller.getCurrentModeController();
        return NoteController.getController(modeController);
    }

    public static NoteController getController(ModeController modeController) {
        return modeController.getExtension(NoteController.class);
    }

    public static void install(NoteController noteController) {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addExtension(NoteController.class, noteController);
        if (firstRun) {
            noteIcon = IconStoreFactory.create().getUIIcon("knotes.png");
            bwNoteIconUrl = ResourceController.getResourceController().getResource("/images/note_black_and_transp.png");
            firstRun = false;
        }
    }

    public NoteController() {
        ModeController modeController;
        this.modeController = modeController = Controller.getCurrentModeController();
        modeController.getMapController().getReadManager().addElementHandler("richcontent", new NoteBuilder(this));
        NoteWriter noteWriter = new NoteWriter(this);
        WriteManager writeManager = modeController.getMapController().getWriteManager();
        writeManager.addAttributeWriter("map", noteWriter);
        writeManager.addExtensionElementWriter(NoteModel.class, noteWriter);
        this.registerNoteTooltipProvider(modeController);
        this.registerStateIconProvider();
    }

    public final String getNoteText(NodeModel node) {
        NoteModel extension = node.getExtension(NoteModel.class);
        return extension != null ? extension.getHtml() : null;
    }

    public final String getXmlNoteText(NodeModel node) {
        NoteModel extension = node.getExtension(NoteModel.class);
        return extension != null ? extension.getXml() : null;
    }

    protected void onWrite(MapModel map) {
    }

    private void registerNoteTooltipProvider(ModeController modeController) {
        modeController.addToolTipProvider(NOTE_TOOLTIP, new ITooltipProvider(){

            @Override
            public String getTooltip(ModeController modeController, NodeModel node, Component view) {
                if (NoteController.this.showNotesInMap(node.getMap()) && !TextController.getController(modeController).isMinimized(node)) {
                    return null;
                }
                String noteText = NoteModel.getNoteText(node);
                if (noteText == null) {
                    return null;
                }
                String rule = NoteController.this.getNoteCSSStyle(modeController, node, true);
                StringBuilder tooltipBodyBegin = new StringBuilder("<body><div style=\"");
                tooltipBodyBegin.append(rule);
                tooltipBodyBegin.append("\">");
                tooltipBodyBegin.append("<img src =\"");
                tooltipBodyBegin.append(bwNoteIconUrl.toString());
                tooltipBodyBegin.append("\">");
                String tooltipText = noteText.replaceFirst("<body>", tooltipBodyBegin.toString()).replaceFirst("</body>", "</div></body>");
                return tooltipText;
            }
        });
    }

    private void registerStateIconProvider() {
        IconController.getController().addStateIconProvider(new IStateIconProvider(){

            @Override
            public UIIcon getStateIcon(NodeModel node) {
                String showNoteIcon;
                boolean showIcon;
                if (NoteModel.getNote(node) != null && (showIcon = Boolean.parseBoolean(showNoteIcon = MapStyle.getController(NoteController.this.modeController).getPropertySetDefault(node.getMap(), NoteController.SHOW_NOTE_ICONS)))) {
                    return noteIcon;
                }
                return null;
            }
        });
    }

    public boolean showNotesInMap(MapModel model) {
        String property = MapStyleModel.getExtension(model).getProperty(SHOW_NOTES_IN_MAP);
        return Boolean.parseBoolean(property);
    }

    protected String getNoteCSSStyle(ModeController modeController, NodeModel node, boolean withWidth) {
        StringBuilder rule = new StringBuilder();
        NodeStyleController style = Controller.getCurrentModeController().getExtension(NodeStyleController.class);
        MapModel map = modeController.getController().getMap();
        if (map != null) {
            MapStyleModel model = MapStyleModel.getExtension(map);
            NodeModel noteStyleNode = model.getStyleNodeSafe(MapStyleModel.NOTE_STYLE);
            Font noteFont = style.getFont(noteStyleNode);
            Color noteBackground = style.getBackgroundColor(noteStyleNode);
            Color noteForeground = style.getColor(noteStyleNode);
            int alignment = style.getTextAlign((NodeModel)noteStyleNode).swingConstant;
            CssRuleBuilder cssRuleBuilder = new CssRuleBuilder().withFont(noteFont).withColor(noteForeground).withBackground(noteBackground).withAlignment(alignment);
            if (withWidth) {
                cssRuleBuilder.withMaxWidthAsPt(NodeSizeModel.getMaxNodeWidth(noteStyleNode), style.getMaxWidth(node));
            }
            rule.append(cssRuleBuilder);
        }
        return rule.toString();
    }

    static {
        NOTE_TOOLTIP = 9;
    }
}

