/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text;

import java.io.IOException;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.IAttributeWriter;
import org.freeplane.core.io.IElementContentHandler;
import org.freeplane.core.io.IElementWriter;
import org.freeplane.core.io.IExtensionAttributeWriter;
import org.freeplane.core.io.IExtensionElementWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.TypeReference;
import org.freeplane.features.format.IFormattedObject;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeWriter;
import org.freeplane.features.styles.StyleFactory;
import org.freeplane.features.styles.StyleString;
import org.freeplane.features.styles.StyleTranslatedObject;
import org.freeplane.features.text.DetailTextModel;
import org.freeplane.features.text.ShortenedTextModel;
import org.freeplane.features.text.TextController;
import org.freeplane.n3.nanoxml.XMLElement;

public class NodeTextBuilder
implements IElementContentHandler,
IElementWriter,
IAttributeWriter,
IExtensionElementWriter,
IExtensionAttributeWriter {
    public static final String XML_NODE_TEXT = "TEXT";
    public static final String XML_NODE_LOCALIZED_TEXT = "LOCALIZED_TEXT";
    public static final String XML_NODE_XHTML_CONTENT_TAG = "richcontent";
    public static final String XML_NODE_XHTML_TYPE_NODE = "NODE";
    public static final String XML_NODE_XHTML_TYPE_NOTE = "NOTE";
    public static final String XML_NODE_XHTML_TYPE_DETAILS = "DETAILS";
    public static final String XML_NODE_XHTML_TYPE_TAG = "TYPE";
    public static final String XML_NODE_OBJECT = "OBJECT";
    private static final String XML_NODE_TEXT_SHORTENED = "TEXT_SHORTENED";

    @Override
    public Object createElement(Object parent, String tag, XMLElement attributes) {
        if (attributes == null) {
            return null;
        }
        String typeAttribute = attributes.getAttribute(XML_NODE_XHTML_TYPE_TAG, null);
        if (XML_NODE_XHTML_TYPE_NODE.equals(typeAttribute) || XML_NODE_XHTML_TYPE_DETAILS.equals(typeAttribute)) {
            return parent;
        }
        return null;
    }

    @Override
    public void endElement(Object parent, String tag, Object obj, XMLElement attributes, String content) {
        assert (tag.equals(XML_NODE_XHTML_CONTENT_TAG));
        String localizedHtml = attributes.getAttribute("LOCALIZED_HTML", null);
        String xmlText = localizedHtml != null ? TextUtils.getRawText(localizedHtml) : content.trim();
        String typeAttribute = attributes.getAttribute(XML_NODE_XHTML_TYPE_TAG, null);
        NodeModel nodeModel = (NodeModel)obj;
        if (XML_NODE_XHTML_TYPE_NODE.equals(typeAttribute)) {
            nodeModel.setXmlText(xmlText);
        } else if (XML_NODE_XHTML_TYPE_DETAILS.equals(typeAttribute)) {
            boolean hidden = "true".equals(attributes.getAttribute("HIDDEN", "false"));
            DetailTextModel details = new DetailTextModel(hidden);
            details.setXml(xmlText);
            nodeModel.addExtension(details);
            if (localizedHtml != null) {
                details.setLocalizedHtmlPropertyName(localizedHtml);
            }
        }
    }

    private void registerAttributeHandlers(ReadManager reader) {
        reader.addAttributeHandler("node", XML_NODE_TEXT, new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                Object nodeContent = node.getUserObject();
                if (nodeContent == null || nodeContent.equals("")) {
                    node.setText(value);
                }
            }
        });
        reader.addAttributeHandler("node", XML_NODE_OBJECT, new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                Object newInstance = TypeReference.create(value);
                if (newInstance instanceof IFormattedObject) {
                    node.setUserObject(((IFormattedObject)newInstance).getObject());
                } else {
                    node.setUserObject(newInstance);
                }
            }
        });
        IAttributeHandler textShortenedHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                try {
                    if (Boolean.valueOf(value).booleanValue()) {
                        node.addExtension(new ShortenedTextModel());
                    }
                }
                catch (Exception e) {
                    LogUtils.warn(e);
                }
            }
        };
        reader.addAttributeHandler("node", XML_NODE_TEXT_SHORTENED, textShortenedHandler);
        reader.addAttributeHandler("stylenode", XML_NODE_TEXT_SHORTENED, textShortenedHandler);
        reader.addAttributeHandler("stylenode", XML_NODE_TEXT, new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                node.setUserObject(StyleFactory.create(value));
            }
        });
        reader.addAttributeHandler("node", XML_NODE_LOCALIZED_TEXT, new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                node.setUserObject(StyleFactory.create(TranslatedObject.format(value)));
            }
        });
        reader.addAttributeHandler("stylenode", XML_NODE_LOCALIZED_TEXT, new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                node.setUserObject(StyleFactory.create(TranslatedObject.format(value)));
            }
        });
    }

    public void registerBy(ReadManager reader, WriteManager writeManager) {
        this.registerAttributeHandlers(reader);
        reader.addElementHandler(XML_NODE_XHTML_CONTENT_TAG, this);
        writeManager.addElementWriter("node", this);
        writeManager.addElementWriter("stylenode", this);
        writeManager.addAttributeWriter("node", this);
        writeManager.addAttributeWriter("stylenode", this);
    }

    @Override
    public void writeAttributes(ITreeWriter writer, Object userObject, String tag) {
        if (!NodeWriter.shouldWriteSharedContent(writer)) {
            return;
        }
        NodeModel node = (NodeModel)userObject;
        Object data = node.getUserObject();
        if (data == null) {
            return;
        }
        Class<?> dataClass = data.getClass();
        if (dataClass.equals(StyleTranslatedObject.class)) {
            writer.addAttribute(XML_NODE_LOCALIZED_TEXT, ((StyleTranslatedObject)data).getObject().toString());
            return;
        }
        if (dataClass.equals(TranslatedObject.class)) {
            writer.addAttribute(XML_NODE_LOCALIZED_TEXT, ((TranslatedObject)data).getObject().toString());
            return;
        }
        boolean forceFormatting = Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.FORCE_FORMATTING));
        if (forceFormatting) {
            String text = TextController.getController().getTransformedTextNoThrow(data, node, data);
            if (!HtmlUtils.isHtmlNode(text)) {
                writer.addAttribute(XML_NODE_TEXT, text.replace('\u0000', ' '));
            } else {
                node.addExtension(new TransformedXMLExtension(text));
            }
        } else {
            String text = data.toString();
            if (node.getXmlText() == null) {
                writer.addAttribute(XML_NODE_TEXT, text.replace('\u0000', ' '));
            }
            if (!(data instanceof String) && !(data instanceof StyleString)) {
                writer.addAttribute(XML_NODE_OBJECT, TypeReference.toSpec(data));
            }
        }
    }

    @Override
    public void writeContent(ITreeWriter writer, Object element, String tag) throws IOException {
        if (!NodeWriter.shouldWriteSharedContent(writer)) {
            return;
        }
        NodeModel node = (NodeModel)element;
        TransformedXMLExtension transformedXML = node.getExtension(TransformedXMLExtension.class);
        if (transformedXML != null || node.getXmlText() != null) {
            String xmlText;
            XMLElement htmlElement = new XMLElement();
            htmlElement.setName(XML_NODE_XHTML_CONTENT_TAG);
            htmlElement.setAttribute(XML_NODE_XHTML_TYPE_TAG, XML_NODE_XHTML_TYPE_NODE);
            if (transformedXML != null) {
                xmlText = transformedXML.xml;
                node.removeExtension(transformedXML);
            } else {
                xmlText = node.getXmlText();
            }
            String content = xmlText.replace('\u0000', ' ');
            writer.addElement((Object)('\n' + content + '\n'), htmlElement);
        }
    }

    @Override
    public void writeContent(ITreeWriter writer, Object element, IExtension note) throws IOException {
        DetailTextModel model = (DetailTextModel)note;
        if (model.getXml() != null) {
            XMLElement htmlElement = new XMLElement();
            htmlElement.setName(XML_NODE_XHTML_CONTENT_TAG);
            htmlElement.setAttribute(XML_NODE_XHTML_TYPE_TAG, XML_NODE_XHTML_TYPE_DETAILS);
            if (model.isHidden()) {
                htmlElement.setAttribute("HIDDEN", "true");
            }
            if (model.getLocalizedHtmlPropertyName() != null) {
                htmlElement.setAttribute("LOCALIZED_HTML", model.getLocalizedHtmlPropertyName());
                writer.addElement(null, htmlElement);
            } else {
                String content = model.getXml().replace('\u0000', ' ');
                writer.addElement((Object)('\n' + content + '\n'), htmlElement);
            }
        }
    }

    @Override
    public void writeAttributes(ITreeWriter writer, Object userObject, IExtension extension) {
        writer.addAttribute(XML_NODE_TEXT_SHORTENED, Boolean.TRUE.toString());
    }

    private static class TransformedXMLExtension
    implements IExtension {
        final String xml;

        public TransformedXMLExtension(String html) {
            this.xml = HtmlUtils.toXhtml(html);
        }
    }
}

